/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.powers;

import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.localization.PowerStrings;
import com.megacrit.cardcrawl.powers.AbstractPower;

public class GeneratorPower
extends AbstractPower {
    public static final String POWER_ID = "Generator";
    private static final PowerStrings powerStrings = CardCrawlGame.languagePack.getPowerStrings("Generator");
    public static final String NAME = GeneratorPower.powerStrings.NAME;
    public static final String[] DESCRIPTIONS = GeneratorPower.powerStrings.DESCRIPTIONS;

    public GeneratorPower(AbstractCreature owner, int chargeAmt) {
        this.name = NAME;
        this.ID = POWER_ID;
        this.owner = owner;
        this.amount = chargeAmt;
        this.updateDescription();
        this.img = ImageMaster.loadImage("images/powers/32/generator.png");
    }

    @Override
    public void updateDescription() {
        this.description = DESCRIPTIONS[0] + this.amount + DESCRIPTIONS[1];
    }

    @Override
    public void onEnergyRecharge() {
        this.flash();
        AbstractDungeon.player.gainCharge(this.amount);
    }
}

