/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.powers;

import com.megacrit.cardcrawl.actions.common.ReducePowerAction;
import com.megacrit.cardcrawl.actions.common.RemoveSpecificPowerAction;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.localization.PowerStrings;
import com.megacrit.cardcrawl.powers.AbstractPower;

public class DrawDownPower
extends AbstractPower {
    public static final String POWER_ID = "Draw Down";
    private static final PowerStrings powerStrings = CardCrawlGame.languagePack.getPowerStrings("Draw Down");
    public static final String NAME = DrawDownPower.powerStrings.NAME;
    public static final String[] DESCRIPTIONS = DrawDownPower.powerStrings.DESCRIPTIONS;
    private static final int EXHAUSTION_AMT = 1;

    public DrawDownPower(AbstractCreature owner, int numTurns) {
        this.name = NAME;
        this.ID = POWER_ID;
        this.owner = owner;
        this.amount = numTurns;
        this.updateDescription();
        this.img = ImageMaster.loadImage("images/powers/32/exhaustion.png");
        this.type = AbstractPower.PowerType.DEBUFF;
        this.isTurnBased = true;
    }

    @Override
    public void onInitialApplication() {
        --AbstractDungeon.player.gameHandSize;
    }

    @Override
    public void atStartOfTurnPostDraw() {
        if (this.amount == 0) {
            AbstractDungeon.actionManager.addToBottom(new RemoveSpecificPowerAction(this.owner, this.owner, POWER_ID));
        } else {
            AbstractDungeon.actionManager.addToBottom(new ReducePowerAction(this.owner, this.owner, POWER_ID, 1));
        }
    }

    @Override
    public void onRemove() {
        ++AbstractDungeon.player.gameHandSize;
    }

    @Override
    public void updateDescription() {
        this.description = this.amount == 1 ? DESCRIPTIONS[0] + 1 + DESCRIPTIONS[1] : DESCRIPTIONS[0] + 1 + DESCRIPTIONS[2] + this.amount + DESCRIPTIONS[3];
    }
}

