/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.powers;

import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.colorless.Shiv;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.localization.PowerStrings;
import com.megacrit.cardcrawl.powers.AbstractPower;

public class AccuracyPower
extends AbstractPower {
    public static final String POWER_ID = "Accuracy";
    private static final PowerStrings powerStrings = CardCrawlGame.languagePack.getPowerStrings("Accuracy");
    public static final String NAME = AccuracyPower.powerStrings.NAME;
    public static final String[] DESCRIPTIONS = AccuracyPower.powerStrings.DESCRIPTIONS;

    public AccuracyPower(AbstractCreature owner, int amt) {
        this.name = NAME;
        this.ID = POWER_ID;
        this.owner = owner;
        this.amount = amt;
        this.updateDescription();
        this.loadRegion("accuracy");
        this.updateShivsInHand();
    }

    @Override
    public void updateDescription() {
        this.description = DESCRIPTIONS[0] + this.amount + DESCRIPTIONS[1];
    }

    @Override
    public void stackPower(int stackAmount) {
        this.fontScale = 8.0f;
        this.amount += stackAmount;
        this.updateShivsInHand();
    }

    private void updateShivsInHand() {
        for (AbstractCard c : AbstractDungeon.player.hand.group) {
            if (!(c instanceof Shiv)) continue;
            c.baseDamage = 4 + this.amount;
        }
    }

    @Override
    public void onDrawOrDiscard() {
        for (AbstractCard c : AbstractDungeon.player.hand.group) {
            if (!(c instanceof Shiv)) continue;
            c.baseDamage = 4 + this.amount;
        }
    }
}

