/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.potions;

import com.megacrit.cardcrawl.actions.common.DrawCardAction;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.PowerTip;
import com.megacrit.cardcrawl.localization.PotionStrings;
import com.megacrit.cardcrawl.potions.AbstractPotion;

public class SwiftPotion
extends AbstractPotion {
    public static final String POTION_ID = "Swift Potion";
    private static final PotionStrings potionStrings = CardCrawlGame.languagePack.getPotionString("Swift Potion");
    public static final String NAME = SwiftPotion.potionStrings.NAME;
    public static final String[] DESCRIPTIONS = SwiftPotion.potionStrings.DESCRIPTIONS;

    public SwiftPotion() {
        super(NAME, POTION_ID, AbstractPotion.PotionSize.H, AbstractPotion.PotionColor.SWIFT);
        this.potency = 3;
        this.description = DESCRIPTIONS[1] + this.potency + DESCRIPTIONS[2];
        this.isThrown = false;
        this.tips.add(new PowerTip(this.name, this.description));
    }

    @Override
    public void use(AbstractCreature target) {
        AbstractDungeon.actionManager.addToBottom(new DrawCardAction(AbstractDungeon.player, this.potency));
    }

    @Override
    public AbstractPotion makeCopy() {
        return new SwiftPotion();
    }
}

