/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.monsters.thecity;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.MathUtils;
import com.esotericsoftware.spine.AnimationState;
import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.actions.animations.VFXAction;
import com.megacrit.cardcrawl.actions.common.ApplyPowerAction;
import com.megacrit.cardcrawl.actions.common.DamageAction;
import com.megacrit.cardcrawl.cards.DamageInfo;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.localization.MonsterStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;
import com.megacrit.cardcrawl.powers.FrailPower;
import com.megacrit.cardcrawl.powers.MalleablePower;
import com.megacrit.cardcrawl.powers.WeakPower;
import com.megacrit.cardcrawl.vfx.combat.BiteEffect;

public class SnakePlant
extends AbstractMonster {
    public static final String ID = "SnakePlant";
    private static final MonsterStrings monsterStrings = CardCrawlGame.languagePack.getMonsterStrings("SnakePlant");
    public static final String NAME = SnakePlant.monsterStrings.NAME;
    public static final String[] MOVES = SnakePlant.monsterStrings.MOVES;
    public static final String[] DIALOG = SnakePlant.monsterStrings.DIALOG;
    private static final byte CHOMPY_CHOMPS = 1;
    private static final byte SPORES = 2;
    private static final int CHOMPY_AMT = 3;
    private static final int RAIN_OF_BLOWS_DMG = 7;

    public SnakePlant(float x, float y) {
        super(NAME, ID, 77, 0.0f, -44.0f, 350.0f, 360.0f, null, x, y + 50.0f);
        this.loadAnimation("images/monsters/theCity/snakePlant/skeleton.atlas", "images/monsters/theCity/snakePlant/skeleton.json", 1.0f);
        AnimationState.TrackEntry e = this.state.setAnimation(0, "idle", true);
        e.setTime(e.getEndTime() * MathUtils.random());
        this.damage.add(new DamageInfo(this, 7));
    }

    @Override
    public void usePreBattleAction() {
        AbstractDungeon.actionManager.addToBottom(new ApplyPowerAction(this, this, new MalleablePower(this)));
    }

    @Override
    public void damage(DamageInfo info) {
        super.damage(info);
        if (info.output > 0) {
            AnimationState.TrackEntry e = this.state.setAnimation(0, "hit", false);
            this.state.setTimeScale(1.5f);
            e.setTime(e.getEndTime() * 0.3f);
            this.state.addAnimation(0, "idle", true, 0.0f);
        }
    }

    @Override
    public void takeTurn() {
        AbstractPlayer p = AbstractDungeon.player;
        switch (this.nextMove) {
            case 1: {
                int numBlows = 3;
                for (int i = 0; i < numBlows; ++i) {
                    AbstractDungeon.actionManager.addToBottom(new VFXAction(new BiteEffect(AbstractDungeon.player.hb.cX + MathUtils.random(-50.0f, 50.0f) * Settings.scale, AbstractDungeon.player.hb.cY + MathUtils.random(-50.0f, 50.0f) * Settings.scale, Color.CHARTREUSE.cpy()), 0.3f));
                    AbstractDungeon.actionManager.addToBottom(new DamageAction((AbstractCreature)p, (DamageInfo)this.damage.get(0), AbstractGameAction.AttackEffect.NONE));
                }
                break;
            }
            case 2: {
                AbstractDungeon.actionManager.addToBottom(new ApplyPowerAction(AbstractDungeon.player, this, new FrailPower(AbstractDungeon.player, 2, true), 2));
                AbstractDungeon.actionManager.addToBottom(new ApplyPowerAction(AbstractDungeon.player, this, new WeakPower(AbstractDungeon.player, 2, true), 2));
                break;
            }
        }
        this.rollMove();
    }

    @Override
    protected void getMove(int num) {
        if (num < 65) {
            if (this.lastTwoMoves((byte)1)) {
                this.setMove(MOVES[0], (byte)2, AbstractMonster.Intent.STRONG_DEBUFF);
            } else {
                this.setMove((byte)1, AbstractMonster.Intent.ATTACK, 7, 3, true);
            }
        } else if (this.lastMove((byte)2)) {
            this.setMove((byte)1, AbstractMonster.Intent.ATTACK, 7, 3, true);
        } else {
            this.setMove(MOVES[0], (byte)2, AbstractMonster.Intent.STRONG_DEBUFF);
        }
    }
}

