/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.monsters.thecity;

import com.badlogic.gdx.math.MathUtils;
import com.esotericsoftware.spine.AnimationState;
import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.actions.animations.AnimateFastAttackAction;
import com.megacrit.cardcrawl.actions.animations.AnimateJumpAction;
import com.megacrit.cardcrawl.actions.animations.AnimateSlowAttackAction;
import com.megacrit.cardcrawl.actions.animations.ShoutAction;
import com.megacrit.cardcrawl.actions.animations.TalkAction;
import com.megacrit.cardcrawl.actions.animations.VFXAction;
import com.megacrit.cardcrawl.actions.common.ApplyPowerAction;
import com.megacrit.cardcrawl.actions.common.DamageAction;
import com.megacrit.cardcrawl.actions.common.GainBlockAction;
import com.megacrit.cardcrawl.actions.common.RollMoveAction;
import com.megacrit.cardcrawl.actions.unique.RemoveDebuffsAction;
import com.megacrit.cardcrawl.actions.utility.SFXAction;
import com.megacrit.cardcrawl.actions.utility.WaitAction;
import com.megacrit.cardcrawl.cards.DamageInfo;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.localization.MonsterStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;
import com.megacrit.cardcrawl.powers.FrailPower;
import com.megacrit.cardcrawl.powers.MetallicizePower;
import com.megacrit.cardcrawl.powers.StrengthPower;
import com.megacrit.cardcrawl.powers.VulnerablePower;
import com.megacrit.cardcrawl.powers.WeakPower;
import com.megacrit.cardcrawl.unlock.UnlockTracker;
import com.megacrit.cardcrawl.vfx.combat.InflameEffect;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Champ
extends AbstractMonster {
    private static final Logger logger = LogManager.getLogger(Champ.class.getName());
    public static final String ID = "Champ";
    private static final MonsterStrings monsterStrings = CardCrawlGame.languagePack.getMonsterStrings("Champ");
    public static final String NAME = Champ.monsterStrings.NAME;
    public static final String[] MOVES = Champ.monsterStrings.MOVES;
    public static final String[] DIALOG = Champ.monsterStrings.DIALOG;
    public static final int HP = 420;
    private static final byte HEAVY_SLASH = 1;
    private static final byte DEFENSIVE_STANCE = 2;
    private static final byte EXECUTE = 3;
    private static final byte FACE_SLAP = 4;
    private static final byte GLOAT = 5;
    private static final byte TAUNT = 6;
    private static final String STANCE_NAME = MOVES[0];
    private static final String EXECUTE_NAME = MOVES[1];
    private static final String SLAP_NAME = MOVES[2];
    public static final int SLASH_DMG = 18;
    public static final int EXECUTE_DMG = 7;
    public static final int SLAP_DMG = 10;
    private static final int BLOCK_AMT = 16;
    private static final int FORGE_AMT = 5;
    private static final int DEBUFF_AMT = 2;
    private static final int STR_AMT = 2;
    private static final int EXEC_COUNT = 3;
    private int numTurns = 0;
    private boolean thresholdReached = false;

    public Champ() {
        super(NAME, ID, 420, 0.0f, -60.0f, 400.0f, 410.0f, null, -90.0f, 40.0f);
        this.type = AbstractMonster.EnemyType.BOSS;
        this.dialogX = -100.0f * Settings.scale;
        this.dialogY = 10.0f * Settings.scale;
        this.loadAnimation("images/monsters/theCity/champ/skeleton.atlas", "images/monsters/theCity/champ/skeleton.json", 1.0f);
        AnimationState.TrackEntry e = this.state.setAnimation(0, "idle", true);
        e.setTime(e.getEndTime() * MathUtils.random());
        e.setTimeScale(1.5f);
        this.damage.add(new DamageInfo(this, 18));
        this.damage.add(new DamageInfo(this, 7));
        this.damage.add(new DamageInfo(this, 10));
    }

    @Override
    public void usePreBattleAction() {
        CardCrawlGame.music.unsilenceBGM();
        AbstractDungeon.scene.fadeOutAmbiance();
        AbstractDungeon.getCurrRoom().playBgmInstantly("BOSS_CITY");
        UnlockTracker.markBossAsSeen("CHAMP");
    }

    @Override
    public void takeTurn() {
        switch (this.nextMove) {
            case 1: {
                AbstractDungeon.actionManager.addToBottom(new AnimateFastAttackAction(this));
                AbstractDungeon.actionManager.addToBottom(new DamageAction((AbstractCreature)AbstractDungeon.player, (DamageInfo)this.damage.get(0), AbstractGameAction.AttackEffect.SLASH_DIAGONAL));
                break;
            }
            case 2: {
                AbstractDungeon.actionManager.addToBottom(new GainBlockAction(this, this, 16));
                AbstractDungeon.actionManager.addToBottom(new ApplyPowerAction(this, this, new MetallicizePower(this, 5), 5));
                break;
            }
            case 3: {
                AbstractDungeon.actionManager.addToBottom(new AnimateJumpAction(this));
                AbstractDungeon.actionManager.addToBottom(new WaitAction(0.5f));
                AbstractDungeon.actionManager.addToBottom(new DamageAction((AbstractCreature)AbstractDungeon.player, (DamageInfo)this.damage.get(1), AbstractGameAction.AttackEffect.BLUNT_LIGHT));
                AbstractDungeon.actionManager.addToBottom(new DamageAction((AbstractCreature)AbstractDungeon.player, (DamageInfo)this.damage.get(1), AbstractGameAction.AttackEffect.BLUNT_HEAVY));
                AbstractDungeon.actionManager.addToBottom(new DamageAction((AbstractCreature)AbstractDungeon.player, (DamageInfo)this.damage.get(1), AbstractGameAction.AttackEffect.SLASH_DIAGONAL));
                break;
            }
            case 4: {
                AbstractDungeon.actionManager.addToBottom(new AnimateSlowAttackAction(this));
                AbstractDungeon.actionManager.addToBottom(new DamageAction((AbstractCreature)AbstractDungeon.player, (DamageInfo)this.damage.get(2), AbstractGameAction.AttackEffect.BLUNT_LIGHT));
                AbstractDungeon.actionManager.addToBottom(new ApplyPowerAction(AbstractDungeon.player, this, new FrailPower(AbstractDungeon.player, 2, true), 2));
                AbstractDungeon.actionManager.addToBottom(new ApplyPowerAction(AbstractDungeon.player, this, new VulnerablePower(AbstractDungeon.player, 2, true), 2));
                break;
            }
            case 5: {
                AbstractDungeon.actionManager.addToBottom(new ApplyPowerAction(this, this, new StrengthPower(this, 2), 2));
                break;
            }
            case 6: {
                AbstractDungeon.actionManager.addToBottom(new SFXAction("VO_CHAMP_2A"));
                AbstractDungeon.actionManager.addToBottom(new TalkAction(this, this.getTaunt()));
                AbstractDungeon.actionManager.addToBottom(new ApplyPowerAction(AbstractDungeon.player, this, new WeakPower(AbstractDungeon.player, 2, true), 2));
                AbstractDungeon.actionManager.addToBottom(new ApplyPowerAction(AbstractDungeon.player, this, new VulnerablePower(AbstractDungeon.player, 2, true), 2));
            }
        }
        AbstractDungeon.actionManager.addToBottom(new RollMoveAction(this));
    }

    private String getTaunt() {
        ArrayList<String> derp = new ArrayList<String>();
        derp.add(DIALOG[0]);
        derp.add(DIALOG[1]);
        derp.add(DIALOG[2]);
        derp.add(DIALOG[3]);
        return (String)derp.get(MathUtils.random(derp.size() - 1));
    }

    private String getLimitBreak() {
        ArrayList<String> derp = new ArrayList<String>();
        derp.add(DIALOG[4]);
        derp.add(DIALOG[5]);
        return (String)derp.get(MathUtils.random(derp.size() - 1));
    }

    private String getDeathQuote() {
        ArrayList<String> derp = new ArrayList<String>();
        derp.add(DIALOG[6]);
        derp.add(DIALOG[7]);
        return (String)derp.get(MathUtils.random(derp.size() - 1));
    }

    @Override
    protected void getMove(int num) {
        logger.info("TURN: " + this.numTurns);
        if (this.numTurns == 3 && this.currentHealth > this.maxHealth / 2) {
            this.setMove((byte)6, AbstractMonster.Intent.DEBUFF);
            this.numTurns = 0;
            return;
        }
        if (num >= 80) {
            if (!this.lastTwoMoves((byte)1)) {
                this.setMove((byte)1, AbstractMonster.Intent.ATTACK, 18);
            } else {
                this.getMove(MathUtils.random(0, 79));
            }
        } else if (num >= 70) {
            if (!this.lastMove((byte)2)) {
                this.setMove(STANCE_NAME, (byte)2, AbstractMonster.Intent.DEFEND_BUFF);
            } else if (MathUtils.randomBoolean(0.2f)) {
                this.getMove(99);
            } else {
                this.getMove(MathUtils.random(0, 69));
            }
        } else if (num >= 50) {
            if (!this.lastMove((byte)5)) {
                this.setMove((byte)5, AbstractMonster.Intent.BUFF);
            } else if (MathUtils.randomBoolean()) {
                this.getMove(MathUtils.random(69, 99));
            } else {
                this.getMove(MathUtils.random(0, 49));
            }
        } else if (num >= 30) {
            if (!this.lastTwoMoves((byte)4)) {
                this.setMove(SLAP_NAME, (byte)4, AbstractMonster.Intent.ATTACK_DEBUFF, 10);
            } else if (this.currentHealth < this.maxHealth / 2 && MathUtils.randomBoolean(0.3f)) {
                this.getMove(0);
            } else {
                this.getMove(MathUtils.random(50, 99));
            }
        } else if (!this.lastMove((byte)3) && this.thresholdReached) {
            AbstractDungeon.actionManager.addToTop(new TalkAction(this, this.getDeathQuote(), 2.0f, 2.0f));
            this.setMove(EXECUTE_NAME, (byte)3, AbstractMonster.Intent.ATTACK, 7, 3, true);
        } else {
            this.getMove(MathUtils.random(31, 99));
        }
        ++this.numTurns;
    }

    @Override
    public void damage(DamageInfo info) {
        super.damage(info);
        if (this.currentHealth < this.maxHealth / 2 && !this.thresholdReached) {
            this.thresholdReached = true;
            AbstractDungeon.actionManager.addToBottom(new SFXAction("VO_CHAMP_1A"));
            AbstractDungeon.actionManager.addToBottom(new ShoutAction(this, this.getLimitBreak(), 2.0f, 3.0f));
            AbstractDungeon.actionManager.addToBottom(new VFXAction(this, new InflameEffect(this), 0.25f));
            AbstractDungeon.actionManager.addToBottom(new VFXAction(this, new InflameEffect(this), 0.25f));
            AbstractDungeon.actionManager.addToBottom(new VFXAction(this, new InflameEffect(this), 0.25f));
            AbstractDungeon.actionManager.addToBottom(new RemoveDebuffsAction(this));
        }
    }

    @Override
    public void die() {
        this.useFastShakeAnimation(5.0f);
        CardCrawlGame.screenShake.rumble(4.0f);
        this.deathTimer += 1.5f;
        super.die();
        if (MathUtils.randomBoolean()) {
            CardCrawlGame.sound.play("VO_CHAMP_3A");
        } else {
            CardCrawlGame.sound.play("VO_CHAMP_3B");
        }
        AbstractDungeon.scene.fadeInAmbiance();
        this.onBossVictoryLogic();
        UnlockTracker.hardUnlockOverride("CHAMP");
        UnlockTracker.unlockAchievement("CHAMP");
    }
}

