/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.monsters.thebeyond;

import com.badlogic.gdx.math.MathUtils;
import com.esotericsoftware.spine.AnimationState;
import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.actions.animations.AnimateSlowAttackAction;
import com.megacrit.cardcrawl.actions.common.ApplyPowerAction;
import com.megacrit.cardcrawl.actions.common.DamageAction;
import com.megacrit.cardcrawl.actions.common.MakeTempCardInHandAction;
import com.megacrit.cardcrawl.actions.common.RollMoveAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.DamageInfo;
import com.megacrit.cardcrawl.cards.status.Wound;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.localization.MonsterStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;
import com.megacrit.cardcrawl.powers.RepulsePower;
import com.megacrit.cardcrawl.powers.StrengthPower;

public class Repulsor
extends AbstractMonster {
    public static final String ID = "Repulsor";
    private static final MonsterStrings monsterStrings = CardCrawlGame.languagePack.getMonsterStrings("Repulsor");
    public static final String NAME = Repulsor.monsterStrings.NAME;
    public static final String[] MOVES = Repulsor.monsterStrings.MOVES;
    public static final String[] DIALOG = Repulsor.monsterStrings.DIALOG;
    public static final String ENCOUNTER_NAME_W = "Ancient Shapes Weak";
    public static final String ENCOUNTER_NAME = "Ancient Shapes";
    private static final int HP_MAX = 34;
    private static final int HP_MIN = 30;
    private static final float HB_X = -8.0f;
    private static final float HB_Y = -10.0f;
    private static final float HB_W = 150.0f;
    private static final float HB_H = 150.0f;
    private static final byte STR_UP = 1;
    private static final int STR_AMT = 3;
    private static final byte ATTACK = 2;
    private static final int ATTACK_DMG = 8;

    public Repulsor(float x, float y) {
        super(NAME, ID, MathUtils.random(30, 34), -8.0f, -10.0f, 150.0f, 150.0f, null, x, y + 10.0f);
        this.loadAnimation("images/monsters/theForest/repulser/skeleton.atlas", "images/monsters/theForest/repulser/skeleton.json", 1.0f);
        AnimationState.TrackEntry e = this.state.setAnimation(0, "idle", true);
        e.setTime(e.getEndTime() * MathUtils.random());
        this.damage.add(new DamageInfo(this, 8));
    }

    @Override
    public void usePreBattleAction() {
        AbstractDungeon.actionManager.addToBottom(new ApplyPowerAction(this, this, new RepulsePower(this)));
    }

    @Override
    public void takeTurn() {
        switch (this.nextMove) {
            case 2: {
                AbstractDungeon.actionManager.addToBottom(new AnimateSlowAttackAction(this));
                AbstractDungeon.actionManager.addToBottom(new DamageAction((AbstractCreature)AbstractDungeon.player, (DamageInfo)this.damage.get(0), AbstractGameAction.AttackEffect.SLASH_HORIZONTAL));
                break;
            }
            case 1: {
                for (AbstractMonster m : AbstractDungeon.getCurrRoom().monsters.monsters) {
                    if (m.isDead || m.isDying || m.isEscaping) continue;
                    AbstractDungeon.actionManager.addToBottom(new ApplyPowerAction(m, this, new StrengthPower(m, 3), 3));
                }
                break;
            }
        }
        AbstractDungeon.actionManager.addToBottom(new RollMoveAction(this));
    }

    @Override
    public void damage(DamageInfo info) {
        super.damage(info);
        if (info.type != DamageInfo.DamageType.HP_LOSS && info.type != DamageInfo.DamageType.THORNS && info.owner != null) {
            AbstractDungeon.actionManager.addToBottom(new MakeTempCardInHandAction((AbstractCard)new Wound(), false));
        }
    }

    @Override
    protected void getMove(int num) {
        if (num < 20 && !this.lastMove((byte)2)) {
            this.setMove((byte)2, AbstractMonster.Intent.ATTACK, ((DamageInfo)this.damage.get((int)0)).base);
            return;
        }
        this.setMove((byte)1, AbstractMonster.Intent.BUFF);
    }
}

