/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.monsters.thebeyond;

import com.badlogic.gdx.math.MathUtils;
import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.actions.animations.AnimateSlowAttackAction;
import com.megacrit.cardcrawl.actions.animations.VFXAction;
import com.megacrit.cardcrawl.actions.common.DamageAction;
import com.megacrit.cardcrawl.actions.common.HealAction;
import com.megacrit.cardcrawl.actions.common.MakeTempCardInDiscardAction;
import com.megacrit.cardcrawl.actions.common.ReviveMonsterAction;
import com.megacrit.cardcrawl.actions.common.RollMoveAction;
import com.megacrit.cardcrawl.actions.common.SpawnMonsterAction;
import com.megacrit.cardcrawl.actions.common.SuicideAction;
import com.megacrit.cardcrawl.actions.utility.HideHealthBarAction;
import com.megacrit.cardcrawl.cards.DamageInfo;
import com.megacrit.cardcrawl.cards.status.Burn;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.localization.MonsterStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;
import com.megacrit.cardcrawl.monsters.thebeyond.FireOrb;
import com.megacrit.cardcrawl.vfx.combat.InflameEffect;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FlameBruiser
extends AbstractMonster {
    private static final Logger logger = LogManager.getLogger(FlameBruiser.class.getName());
    public static final String ID = "FlameBruiser";
    private static final MonsterStrings monsterStrings = CardCrawlGame.languagePack.getMonsterStrings("FlameBruiser");
    public static final String NAME = FlameBruiser.monsterStrings.NAME;
    public static final String[] MOVES = FlameBruiser.monsterStrings.MOVES;
    public static final String[] DIALOG = FlameBruiser.monsterStrings.DIALOG;
    public static final String ONE_ORB = "Flame Bruiser (One Orb)";
    public static final String TWO_ORB = "Flame Bruiser (Two Orb)";
    private static final int HP_MIN = 120;
    private static final int HP_MAX = 130;
    private static final float HB_X_F = 0.0f;
    private static final float HB_Y_F = 10.0f;
    private static final float HB_W = 220.0f;
    private static final float HB_H = 320.0f;
    private static final int HEAL_AMT = 30;
    private static final int BURN_STRIKE_DMG = 11;
    private static final byte BURN_STRIKE = 1;
    private static final byte SPAWN_FLAME_ORB = 2;
    private static final byte HEAL = 3;
    private boolean firstMove = true;
    private static final float pos1X = -180.0f;
    private static final float pos1Y = 80.0f;
    private static final float pos2X = 310.0f;
    private static final float pos2Y = 90.0f;
    private static final float pos3X = -360.0f;
    private static final float pos3Y = 40.0f;

    public FlameBruiser() {
        super(NAME, ID, MathUtils.random(120, 130), 0.0f, 10.0f, 220.0f, 320.0f, "images/monsters/theForest/fireBro.png", 0.0f, 0.0f);
        this.damage.add(new DamageInfo(this, 11));
    }

    @Override
    public void takeTurn() {
        switch (this.nextMove) {
            case 1: {
                AbstractDungeon.actionManager.addToBottom(new AnimateSlowAttackAction(this));
                AbstractDungeon.actionManager.addToBottom(new DamageAction((AbstractCreature)AbstractDungeon.player, (DamageInfo)this.damage.get(0), AbstractGameAction.AttackEffect.FIRE));
                AbstractDungeon.actionManager.addToBottom(new DamageAction((AbstractCreature)AbstractDungeon.player, (DamageInfo)this.damage.get(0), AbstractGameAction.AttackEffect.FIRE));
                AbstractDungeon.actionManager.addToBottom(new MakeTempCardInDiscardAction(new Burn(), 1));
                break;
            }
            case 2: {
                this.spawn();
                break;
            }
            case 3: {
                AbstractDungeon.actionManager.addToBottom(new HealAction(this, this, 30));
            }
        }
        AbstractDungeon.actionManager.addToBottom(new RollMoveAction(this));
    }

    private void spawn() {
        int count = 0;
        for (AbstractMonster m : AbstractDungeon.getMonsters().monsters) {
            if (m == this) continue;
            if (m.isDying) {
                AbstractDungeon.actionManager.addToBottom(new ReviveMonsterAction(m, this, false));
                return;
            }
            ++count;
        }
        logger.info("SPAWN COUNT: " + count);
        if (count == 1) {
            AbstractDungeon.actionManager.addToBottom(new SpawnMonsterAction(new FireOrb(-180.0f, 80.0f)));
        } else if (count == 2) {
            AbstractDungeon.actionManager.addToBottom(new SpawnMonsterAction(new FireOrb(310.0f, 90.0f)));
        } else if (count == 3) {
            AbstractDungeon.actionManager.addToBottom(new SpawnMonsterAction(new FireOrb(-360.0f, 40.0f)));
        }
    }

    private boolean canSpawn() {
        int aliveCount = 0;
        for (AbstractMonster m : AbstractDungeon.getMonsters().monsters) {
            if (m == this || m.isDying) continue;
            ++aliveCount;
        }
        return aliveCount <= 3;
    }

    @Override
    public void die() {
        for (AbstractMonster m : AbstractDungeon.getCurrRoom().monsters.monsters) {
            if (m.isDead || m.isDying) continue;
            AbstractDungeon.actionManager.addToTop(new HideHealthBarAction(m));
            AbstractDungeon.actionManager.addToTop(new SuicideAction(m));
            AbstractDungeon.actionManager.addToTop(new VFXAction(m, new InflameEffect(m), 0.2f));
        }
    }

    @Override
    protected void getMove(int num) {
        if (this.firstMove) {
            this.firstMove = false;
            this.setMove((byte)2, AbstractMonster.Intent.UNKNOWN);
            return;
        }
        if (num < 33) {
            if (!this.lastMove((byte)1)) {
                this.setMove((byte)1, AbstractMonster.Intent.ATTACK, 11, 2, true);
            } else {
                this.getMove(MathUtils.random(33, 99));
            }
        } else if (num < 66) {
            if (!this.lastTwoMoves((byte)2)) {
                if (this.canSpawn()) {
                    this.setMove((byte)2, AbstractMonster.Intent.UNKNOWN);
                } else {
                    this.setMove((byte)3, AbstractMonster.Intent.BUFF);
                }
            } else {
                this.setMove((byte)1, AbstractMonster.Intent.ATTACK, 11, 2, true);
            }
        } else if (!this.lastTwoMoves((byte)3) && this.currentHealth < this.maxHealth / 2) {
            this.setMove((byte)3, AbstractMonster.Intent.BUFF);
        } else {
            this.getMove(MathUtils.random(65));
        }
    }
}

