/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.map;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.daily.DailyMods;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.Hitbox;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.helpers.InputHelper;
import com.megacrit.cardcrawl.helpers.MathHelper;
import com.megacrit.cardcrawl.map.Legend;
import com.megacrit.cardcrawl.map.MapEdge;
import com.megacrit.cardcrawl.map.MapRoomNode;
import com.megacrit.cardcrawl.rooms.AbstractRoom;
import com.megacrit.cardcrawl.rooms.MonsterRoomBoss;
import com.megacrit.cardcrawl.screens.DungeonMapScreen;

public class DungeonMap {
    private static Texture top;
    private static Texture mid;
    private static Texture bot;
    private static Texture blend;
    private static Texture boss;
    private float targetAlpha = 0.0f;
    private static final Color NOT_TAKEN_COLOR;
    private Color bossNodeColor = NOT_TAKEN_COLOR.cpy();
    private Color baseMapColor = Color.WHITE.cpy();
    private float mapMidDist;
    private static float mapOffsetY;
    private static final float BOSS_W;
    private static final float BOSS_OFFSET_Y;
    private static final float H;
    private static final float BLEND_H;
    private Hitbox bossHb;
    public boolean atBoss = false;
    private Legend legend = new Legend();

    public DungeonMap() {
        if (top == null) {
            top = ImageMaster.loadImage("images/ui/map/mapTop.png");
            mid = ImageMaster.loadImage("images/ui/map/mapMid.png");
            bot = ImageMaster.loadImage("images/ui/map/mapBot.png");
            blend = ImageMaster.loadImage("images/ui/map/mapBlend.png");
            boss = ImageMaster.loadImage("images/ui/map/bossIcon.png");
        }
        this.bossHb = new Hitbox(-1000.0f, -1000.0f, 400.0f * Settings.scale, 360.0f * Settings.scale);
    }

    public void update() {
        this.legend.update(this.baseMapColor.a, AbstractDungeon.screen == AbstractDungeon.CurrentScreen.MAP);
        this.baseMapColor.a = MathHelper.fadeLerpSnap(this.baseMapColor.a, this.targetAlpha);
        this.bossHb.move((float)Settings.WIDTH / 2.0f, DungeonMapScreen.offsetY + mapOffsetY + BOSS_OFFSET_Y + BOSS_W / 2.0f);
        this.bossHb.update();
        if (AbstractDungeon.getCurrRoom().phase == AbstractRoom.RoomPhase.COMPLETE && AbstractDungeon.screen == AbstractDungeon.CurrentScreen.MAP && (Settings.isDebug || AbstractDungeon.getCurrMapNode().y == 14) && this.bossHb.hovered && InputHelper.justClickedLeft) {
            AbstractDungeon.getCurrMapNode().taken = true;
            MapRoomNode node2 = AbstractDungeon.getCurrMapNode();
            for (MapEdge e : node2.getEdges()) {
                if (e == null) continue;
                e.markAsTaken();
            }
            InputHelper.justClickedLeft = false;
            CardCrawlGame.music.fadeOutTempBGM();
            MapRoomNode node = new MapRoomNode(-1, 15);
            node.room = new MonsterRoomBoss();
            AbstractDungeon.nextRoom = node;
            if (AbstractDungeon.pathY.size() > 1) {
                AbstractDungeon.pathX.add(AbstractDungeon.pathX.get(AbstractDungeon.pathX.size() - 1));
                AbstractDungeon.pathY.add(AbstractDungeon.pathY.get(AbstractDungeon.pathY.size() - 1) + 1);
            } else {
                AbstractDungeon.pathX.add(1);
                AbstractDungeon.pathY.add(15);
            }
            AbstractDungeon.nextRoomTransitionStart();
            this.bossHb.hovered = false;
        }
        if (this.bossHb.hovered || this.atBoss) {
            this.bossNodeColor = MapRoomNode.AVAILABLE_COLOR.cpy();
        } else {
            this.bossNodeColor.lerp(NOT_TAKEN_COLOR, Gdx.graphics.getDeltaTime() * 8.0f);
        }
        this.bossNodeColor.a = this.baseMapColor.a;
    }

    private float calculateMapSize() {
        return Settings.MAP_DST_Y * 16.0f - 1380.0f * Settings.scale;
    }

    public void show() {
        this.targetAlpha = 1.0f;
        this.mapMidDist = this.calculateMapSize();
        mapOffsetY = this.mapMidDist - 120.0f * Settings.scale;
    }

    public void hide() {
        this.targetAlpha = 0.0f;
    }

    public void hideInstantly() {
        this.targetAlpha = 0.0f;
        this.baseMapColor.a = 0.0f;
        this.legend.c.a = 0.0f;
    }

    public void render(SpriteBatch sb) {
        sb.setColor(this.baseMapColor);
        sb.draw(top, 0.0f, H + DungeonMapScreen.offsetY + mapOffsetY, (float)Settings.WIDTH, (float)Settings.HEIGHT);
        this.renderMapCenters(sb);
        sb.draw(bot, 0.0f, -this.mapMidDist + DungeonMapScreen.offsetY + mapOffsetY + 1.0f, (float)Settings.WIDTH, (float)Settings.HEIGHT);
        this.renderMapBlender(sb);
        this.renderBossIcon(sb);
        if (Settings.isDailyRun) {
            for (int i = 0; i < DailyMods.modList.size(); ++i) {
                FontHelper.renderSmartText(sb, FontHelper.tipBodyFont, DailyMods.modList.get(i), 20.0f * Settings.scale, 30.0f * Settings.scale + (float)i * 24.0f * Settings.scale, 100000.0f, 20.0f * Settings.scale, new Color(1.0f, 0.965f, 0.886f, this.baseMapColor.a));
            }
            FontHelper.renderSmartText(sb, FontHelper.tipBodyFont, "Daily Modifiers: ", 20.0f * Settings.scale, 30.0f * Settings.scale + (float)DailyMods.modList.size() * 24.0f * Settings.scale, 100000.0f, 20.0f * Settings.scale, new Color(0.882f, 0.737f, 0.294f, this.baseMapColor.a));
        }
        this.legend.render(sb);
    }

    private void renderBossIcon(SpriteBatch sb) {
        sb.setColor(this.bossNodeColor);
        sb.draw(boss, (float)Settings.WIDTH / 2.0f - BOSS_W / 2.0f, DungeonMapScreen.offsetY + mapOffsetY + BOSS_OFFSET_Y, BOSS_W, BOSS_W);
        if (AbstractDungeon.screen == AbstractDungeon.CurrentScreen.MAP) {
            this.bossHb.render(sb);
        }
    }

    private void renderMapCenters(SpriteBatch sb) {
        sb.draw(mid, 0.0f, DungeonMapScreen.offsetY + mapOffsetY, (float)Settings.WIDTH, (float)Settings.HEIGHT);
    }

    private void renderMapBlender(SpriteBatch sb) {
        if (!Settings.isSixteenByTen) {
            sb.draw(blend, 0.0f, DungeonMapScreen.offsetY + mapOffsetY + 800.0f * Settings.scale, (float)Settings.WIDTH, BLEND_H);
            sb.draw(blend, 0.0f, DungeonMapScreen.offsetY + mapOffsetY - 200.0f * Settings.scale, (float)Settings.WIDTH, BLEND_H);
        } else {
            sb.draw(blend, 0.0f, DungeonMapScreen.offsetY + mapOffsetY + 900.0f * Settings.scale, (float)Settings.WIDTH, BLEND_H);
            sb.draw(blend, 0.0f, DungeonMapScreen.offsetY + mapOffsetY - 100.0f * Settings.scale, (float)Settings.WIDTH, BLEND_H);
        }
    }

    static {
        NOT_TAKEN_COLOR = new Color(0.34f, 0.34f, 0.34f, 1.0f);
        BOSS_W = 512.0f * Settings.scale;
        BOSS_OFFSET_Y = 1416.0f * Settings.scale;
        H = 1020.0f * Settings.scale;
        BLEND_H = 512.0f * Settings.scale;
    }
}

