/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.helpers;

import com.megacrit.cardcrawl.daily.mods.AbstractDailyMod;
import com.megacrit.cardcrawl.daily.mods.CursedRun;
import com.megacrit.cardcrawl.daily.mods.DoubleElites;
import com.megacrit.cardcrawl.daily.mods.LethalEnemies;
import com.megacrit.cardcrawl.daily.mods.NightTerrors;
import com.megacrit.cardcrawl.daily.mods.RestlessJourney;
import com.megacrit.cardcrawl.daily.mods.Vintage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModHelper {
    private static final Logger logger = LogManager.getLogger(ModHelper.class.getName());
    private static HashMap<String, AbstractDailyMod> mods = new HashMap();

    public static void initialize() {
        ModHelper.add(new CursedRun());
        ModHelper.add(new DoubleElites());
        ModHelper.add(new LethalEnemies());
        ModHelper.add(new RestlessJourney());
        ModHelper.add(new Vintage());
        ModHelper.add(new NightTerrors());
    }

    public static void add(AbstractDailyMod mod) {
        mods.put(mod.name, mod);
    }

    public static AbstractDailyMod getMod(String key) {
        return mods.get(key);
    }

    public static HashMap<String, Boolean> getMods(int numOfMods, Random random) {
        HashMap<String, Boolean> retVal = new HashMap<String, Boolean>();
        ArrayList<AbstractDailyMod> tmp = new ArrayList<AbstractDailyMod>();
        for (Map.Entry<String, AbstractDailyMod> m : mods.entrySet()) {
            tmp.add(m.getValue());
            retVal.put(m.getKey(), false);
        }
        Collections.shuffle(tmp, random);
        logger.info(tmp);
        for (int i = 0; i < numOfMods; ++i) {
            retVal.put(((AbstractDailyMod)tmp.get((int)i)).name, true);
        }
        return retVal;
    }

    public static HashMap<String, Boolean> noMods() {
        HashMap<String, Boolean> retVal = new HashMap<String, Boolean>();
        for (Map.Entry<String, AbstractDailyMod> m : mods.entrySet()) {
            retVal.put(m.getKey(), false);
        }
        return retVal;
    }
}

