/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.gashapon;

import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.MathUtils;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.characters.AnimatedNpc;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.events.AbstractEvent;
import com.megacrit.cardcrawl.events.RoomEventDialog;
import com.megacrit.cardcrawl.gashapon.NeowReward;
import com.megacrit.cardcrawl.helpers.PotionHelper;
import com.megacrit.cardcrawl.helpers.TipTracker;
import com.megacrit.cardcrawl.localization.CharacterStrings;
import com.megacrit.cardcrawl.potions.AbstractPotion;
import com.megacrit.cardcrawl.potions.PotionPlaceholder;
import com.megacrit.cardcrawl.relics.AbstractRelic;
import com.megacrit.cardcrawl.rooms.AbstractRoom;
import com.megacrit.cardcrawl.screens.stats.StatsScreen;
import com.megacrit.cardcrawl.vfx.AbstractGameEffect;
import com.megacrit.cardcrawl.vfx.InfiniteSpeechBubble;
import com.megacrit.cardcrawl.vfx.cardManip.ShowCardAndObtainEffect;
import com.megacrit.cardcrawl.vfx.scene.LevelTransitionTextOverlayEffect;
import java.util.ArrayList;

public class NeowEvent
extends AbstractEvent {
    private static final CharacterStrings characterStrings = CardCrawlGame.languagePack.getCharacterString("Neow Event");
    public static final String[] NAMES = NeowEvent.characterStrings.NAMES;
    public static final String[] TEXT = NeowEvent.characterStrings.TEXT;
    public static final String[] OPTIONS = NeowEvent.characterStrings.OPTIONS;
    private AnimatedNpc npc;
    public static final String NAME = NAMES[0];
    private int screenNum = 2;
    private int bossCount;
    private boolean setPhaseToEvent = false;
    private ArrayList<NeowReward> rewards = new ArrayList();
    private static final float DIALOG_X = 1100.0f * Settings.scale;
    private static final float DIALOG_Y = 400.0f * Settings.scale;

    public NeowEvent() {
        this.npc = new AnimatedNpc(1534.0f * Settings.scale, 280.0f * Settings.scale, "images/npcs/neow/skeleton.atlas", "images/npcs/neow/skeleton.json", "idle");
        AbstractDungeon.dialog.clear();
        this.playSfx();
        AbstractDungeon.bossCount = this.bossCount = CardCrawlGame.playerPref.getInteger(AbstractDungeon.player.chosenClass.name() + "_SPIRITS", 0);
        this.body = "";
        if (!TipTracker.tips.get("NEOW_INTRO").booleanValue()) {
            this.screenNum = 0;
            TipTracker.neverShowAgain("NEOW_INTRO");
            this.talk(TEXT[0]);
            RoomEventDialog.addDialogOption(OPTIONS[1]);
        } else {
            this.screenNum = 1;
            this.talk(TEXT[MathUtils.random(1, 3)]);
            RoomEventDialog.addDialogOption(OPTIONS[1]);
        }
        this.hasDialog = true;
        this.hasFocus = true;
        AbstractDungeon.topLevelEffects.add(new LevelTransitionTextOverlayEffect(AbstractDungeon.name, AbstractDungeon.levelNum, true));
    }

    @Override
    public void update() {
        super.update();
        for (NeowReward r : this.rewards) {
            r.update();
        }
        if (!this.setPhaseToEvent) {
            AbstractDungeon.getCurrRoom().phase = AbstractRoom.RoomPhase.EVENT;
            this.setPhaseToEvent = true;
        }
        if (!RoomEventDialog.waitForInput) {
            this.buttonEffect(RoomEventDialog.getSelectedOption());
        }
    }

    private void talk(String msg) {
        AbstractDungeon.effectList.add(new InfiniteSpeechBubble(DIALOG_X, DIALOG_Y, msg));
    }

    private void buttonEffect(int buttonPressed) {
        switch (this.screenNum) {
            case 0: {
                this.dismissBubble();
                this.talk(TEXT[4]);
                RoomEventDialog.updateDialogOption(0, OPTIONS[0]);
                if (this.bossCount != 0 || Settings.isTestingNeow) {
                    this.blessing();
                    break;
                }
                this.screenNum = 99;
                break;
            }
            case 1: {
                this.dismissBubble();
                if (this.bossCount == 0 && !Settings.isTestingNeow) {
                    this.talk(TEXT[MathUtils.random(4, 6)]);
                    RoomEventDialog.updateDialogOption(0, OPTIONS[3]);
                    this.screenNum = 99;
                    break;
                }
                this.blessing();
                break;
            }
            case 2: {
                if (buttonPressed == 0) {
                    this.blessing();
                    break;
                }
                this.openMap();
                break;
            }
            case 3: {
                this.dismissBubble();
                RoomEventDialog.clearRemainingOptions();
                switch (buttonPressed) {
                    case 0: {
                        this.rewards.get(0).activate();
                        this.talk(TEXT[8]);
                        break;
                    }
                    case 1: {
                        this.rewards.get(1).activate();
                        this.talk(TEXT[8]);
                        break;
                    }
                    case 2: {
                        this.rewards.get(2).activate();
                        this.talk(TEXT[9]);
                        break;
                    }
                }
                this.screenNum = 99;
                RoomEventDialog.updateDialogOption(0, OPTIONS[3]);
                RoomEventDialog.clearRemainingOptions();
                break;
            }
            default: {
                this.openMap();
            }
        }
    }

    private void blessing() {
        AbstractDungeon.bossCount = 0;
        this.dismissBubble();
        this.talk(TEXT[7]);
        this.generateRewards();
        this.rewards.add(new NeowReward(0));
        this.rewards.add(new NeowReward(1));
        this.rewards.add(new NeowReward(2));
        RoomEventDialog.clearRemainingOptions();
        RoomEventDialog.updateDialogOption(0, this.rewards.get((int)0).optionLabel);
        RoomEventDialog.addDialogOption(this.rewards.get((int)1).optionLabel);
        RoomEventDialog.addDialogOption(this.rewards.get((int)2).optionLabel);
        RoomEventDialog.addDialogOption(OPTIONS[2]);
        CardCrawlGame.playerPref.putInteger(AbstractDungeon.player.chosenClass.name() + "_SPIRITS", 0);
        CardCrawlGame.playerPref.flush();
        StatsScreen.incrementCrystalFed(AbstractDungeon.bossCount);
        AbstractDungeon.bossCount = 0;
        this.screenNum = 3;
    }

    private void dismissBubble() {
        for (AbstractGameEffect e : AbstractDungeon.effectList) {
            if (!(e instanceof InfiniteSpeechBubble)) continue;
            ((InfiniteSpeechBubble)e).dismiss();
        }
    }

    private void generateRewards() {
    }

    private void playSfx() {
        int roll = MathUtils.random(3);
        if (roll == 0) {
            CardCrawlGame.sound.play("VO_NEOW_1A");
        } else if (roll == 1) {
            CardCrawlGame.sound.play("VO_NEOW_1B");
        } else if (roll == 2) {
            CardCrawlGame.sound.play("VO_NEOW_2A");
        } else {
            CardCrawlGame.sound.play("VO_NEOW_2B");
        }
    }

    private void getFreeReward() {
        switch (MathUtils.random(2)) {
            case 0: {
                AbstractDungeon.player.increaseMaxHp(3, true);
                break;
            }
            case 1: {
                CardCrawlGame.sound.play("GOLD_JINGLE");
                AbstractDungeon.player.gainGold(25);
                break;
            }
            case 2: {
                this.getPotion(PotionHelper.getRandomPotion());
                break;
            }
        }
    }

    private void getOnePointReward() {
        switch (MathUtils.random(5)) {
            case 0: {
                AbstractDungeon.player.increaseMaxHp(MathUtils.random(5, 9), true);
                break;
            }
            case 1: {
                CardCrawlGame.sound.play("GOLD_JINGLE");
                AbstractDungeon.player.gainGold(MathUtils.random(40, 60));
                break;
            }
            case 2: {
                this.getPotion(PotionHelper.getRandomPotion());
                this.getPotion(PotionHelper.getRandomPotion());
                break;
            }
            case 3: {
                if (MathUtils.randomBoolean(0.25f)) {
                    AbstractDungeon.effectList.add(new ShowCardAndObtainEffect(AbstractDungeon.getCardWithoutRng(AbstractCard.CardRarity.UNCOMMON), (float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT / 2.0f));
                    break;
                }
                AbstractDungeon.effectList.add(new ShowCardAndObtainEffect(AbstractDungeon.getCardWithoutRng(AbstractCard.CardRarity.COMMON), (float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT / 2.0f));
                break;
            }
            case 4: {
                if (MathUtils.randomBoolean(0.25f)) {
                    AbstractDungeon.effectList.add(new ShowCardAndObtainEffect(AbstractDungeon.getCardWithoutRng(AbstractCard.CardRarity.UNCOMMON), (float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT / 2.0f));
                    break;
                }
                AbstractDungeon.effectList.add(new ShowCardAndObtainEffect(AbstractDungeon.getCardWithoutRng(AbstractCard.CardRarity.COMMON), (float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT / 2.0f));
                break;
            }
            default: {
                AbstractDungeon.effectList.add(new ShowCardAndObtainEffect(AbstractDungeon.getColorlessCardFromPool(AbstractCard.CardRarity.UNCOMMON), (float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT / 2.0f));
            }
        }
    }

    private void getTwoPointReward() {
        switch (MathUtils.random(3)) {
            case 0: {
                if (MathUtils.randomBoolean(0.25f)) {
                    AbstractDungeon.effectList.add(new ShowCardAndObtainEffect(AbstractDungeon.getCardWithoutRng(AbstractCard.CardRarity.UNCOMMON), (float)Settings.WIDTH / 2.0f - AbstractCard.IMG_WIDTH - 30.0f * Settings.scale, (float)Settings.HEIGHT / 2.0f));
                } else {
                    AbstractDungeon.effectList.add(new ShowCardAndObtainEffect(AbstractDungeon.getCardWithoutRng(AbstractCard.CardRarity.COMMON), (float)Settings.WIDTH / 2.0f - AbstractCard.IMG_WIDTH - 30.0f * Settings.scale, (float)Settings.HEIGHT / 2.0f));
                }
                if (MathUtils.randomBoolean(0.25f)) {
                    AbstractDungeon.effectList.add(new ShowCardAndObtainEffect(AbstractDungeon.getCardWithoutRng(AbstractCard.CardRarity.UNCOMMON), (float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT / 2.0f));
                } else {
                    AbstractDungeon.effectList.add(new ShowCardAndObtainEffect(AbstractDungeon.getCardWithoutRng(AbstractCard.CardRarity.COMMON), (float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT / 2.0f));
                }
                if (MathUtils.randomBoolean(0.25f)) {
                    AbstractDungeon.effectList.add(new ShowCardAndObtainEffect(AbstractDungeon.getCardWithoutRng(AbstractCard.CardRarity.UNCOMMON), (float)Settings.WIDTH / 2.0f + AbstractCard.IMG_WIDTH + 30.0f * Settings.scale, (float)Settings.HEIGHT / 2.0f));
                    break;
                }
                AbstractDungeon.effectList.add(new ShowCardAndObtainEffect(AbstractDungeon.getCardWithoutRng(AbstractCard.CardRarity.COMMON), (float)Settings.WIDTH / 2.0f + AbstractCard.IMG_WIDTH + 30.0f * Settings.scale, (float)Settings.HEIGHT / 2.0f));
                break;
            }
            case 1: {
                AbstractDungeon.effectList.add(new ShowCardAndObtainEffect(AbstractDungeon.getCardWithoutRng(AbstractCard.CardRarity.RARE), (float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT / 2.0f));
                break;
            }
            case 2: {
                this.getPotion(PotionHelper.getRandomPotion());
                this.getPotion(PotionHelper.getRandomPotion());
                this.getPotion(PotionHelper.getRandomPotion());
                break;
            }
            case 3: {
                if (MathUtils.randomBoolean(0.25f)) {
                    AbstractDungeon.getCurrRoom().spawnRelicAndObtain(Settings.WIDTH / 2, Settings.HEIGHT / 2, AbstractDungeon.returnRandomRelic(AbstractRelic.RelicTier.UNCOMMON));
                    break;
                }
                AbstractDungeon.getCurrRoom().spawnRelicAndObtain(Settings.WIDTH / 2, Settings.HEIGHT / 2, AbstractDungeon.returnRandomRelic(AbstractRelic.RelicTier.COMMON));
                break;
            }
        }
    }

    private void getPotion(AbstractPotion p) {
        for (int i = 0; i < 3; ++i) {
            if (!(AbstractDungeon.player.potions[i] instanceof PotionPlaceholder)) continue;
            CardCrawlGame.sound.play("POTION_1");
            p.moveInstantly(AbstractDungeon.player.potions[i].currentX, AbstractDungeon.player.potions[i].currentY);
            p.isObtained = true;
            p.isDone = true;
            p.isAnimating = false;
            p.flash();
            AbstractDungeon.player.potions[i] = p;
            break;
        }
    }

    public void logMetric(String actionTaken) {
        AbstractEvent.logMetric(NAME, actionTaken);
    }

    @Override
    public void render(SpriteBatch sb) {
        this.npc.render(sb);
    }
}

