/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.gashapon;

import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.gashapon.GashaponRoom;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GashaponType
implements Comparable<GashaponType> {
    private static final Logger logger = LogManager.getLogger(GashaponType.class.getName());
    public GashaponRoom.GashaContent contents;
    public float weight;

    public GashaponType(GashaponRoom.GashaContent contents, float weight) {
        this.contents = contents;
        this.weight = weight;
    }

    public static void normalizeWeights(ArrayList<GashaponType> list) {
        Collections.sort(list);
        float total = 0.0f;
        for (GashaponType i : list) {
            total += i.weight;
        }
        for (GashaponType i : list) {
            i.weight /= total;
            if (!Settings.isInfo) continue;
            logger.info(i.contents.name() + ": " + i.weight + "%");
        }
    }

    public static GashaponRoom.GashaContent roll(ArrayList<GashaponType> list, float roll) {
        float currentWeight = 0.0f;
        for (GashaponType i : list) {
            if (!(roll < (currentWeight += i.weight))) continue;
            return i.contents;
        }
        return null;
    }

    @Override
    public int compareTo(GashaponType other) {
        return Float.compare(this.weight, other.weight);
    }
}

