/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.gashapon;

import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.MathUtils;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.gashapon.GashaponType;
import com.megacrit.cardcrawl.gashapon.NeowEvent;
import com.megacrit.cardcrawl.rooms.AbstractRoom;
import com.megacrit.cardcrawl.unlock.UnlockTracker;
import java.util.ArrayList;

public class GashaponRoom
extends AbstractRoom {
    private ArrayList<GashaponType> typeList = new ArrayList();
    private ArrayList<GashaContent> contents = new ArrayList();

    public GashaponRoom() {
        this.initializeRewards();
        this.phase = AbstractRoom.RoomPhase.EVENT;
        this.event = new NeowEvent();
        this.event.onEnterRoom();
    }

    @Override
    public void onPlayerEntry() {
        AbstractDungeon.overlayMenu.proceedButton.hide();
    }

    private void initializeRewards() {
        this.typeList.add(new GashaponType(GashaContent.GOLD, 5.0f));
        this.typeList.add(new GashaponType(GashaContent.HP, 5.0f));
        this.typeList.add(new GashaponType(GashaContent.POTION, 5.0f));
        this.typeList.add(new GashaponType(GashaContent.RELIC, 5.0f));
        this.typeList.add(new GashaponType(GashaContent.CARD, 5.0f));
        if (!UnlockTracker.lockedRelics.isEmpty()) {
            this.typeList.add(new GashaponType(GashaContent.UNLOCK_RELIC, 2.0f));
        }
        if (!UnlockTracker.lockedCards.isEmpty()) {
            this.typeList.add(new GashaponType(GashaContent.UNLOCK_CARD, 2.0f));
        }
        GashaponType.normalizeWeights(this.typeList);
        this.contents.add(GashaponType.roll(this.typeList, MathUtils.random()));
        this.contents.add(GashaponType.roll(this.typeList, MathUtils.random()));
        this.contents.add(GashaponType.roll(this.typeList, MathUtils.random()));
    }

    @Override
    public void update() {
        super.update();
        if (!AbstractDungeon.isScreenUp) {
            this.event.update();
        }
        if (this.event.waitTimer == 0.0f && !this.event.hasFocus && this.phase != AbstractRoom.RoomPhase.COMBAT) {
            this.phase = AbstractRoom.RoomPhase.COMPLETE;
            this.event.reopen();
        }
    }

    @Override
    public AbstractCard.CardRarity getCardRarity(int roll) {
        return null;
    }

    @Override
    public void render(SpriteBatch sb) {
        super.render(sb);
        this.event.render(sb);
    }

    @Override
    public void renderAboveTopPanel(SpriteBatch sb) {
        super.renderAboveTopPanel(sb);
        if (this.event != null) {
            this.event.renderAboveTopPanel(sb);
        }
    }

    public static enum GashaContent {
        GOLD,
        HP,
        POTION,
        RELIC,
        CARD,
        UNLOCK_RELIC,
        UNLOCK_CARD;

    }
}

