/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.gashapon;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.helpers.RelicLibrary;
import com.megacrit.cardcrawl.localization.UIStrings;
import com.megacrit.cardcrawl.ui.buttons.UnlockConfirmButton;
import com.megacrit.cardcrawl.unlock.AbstractUnlock;
import com.megacrit.cardcrawl.unlock.UnlockTracker;
import com.megacrit.cardcrawl.vfx.ConeEffect;
import com.megacrit.cardcrawl.vfx.RoomShineEffect;
import com.megacrit.cardcrawl.vfx.RoomShineEffect2;
import java.util.ArrayList;
import java.util.Iterator;

public class GashaUnlockScreen {
    public ArrayList<AbstractUnlock> unlockBundle;
    private ArrayList<ConeEffect> cones = new ArrayList();
    private static final int CONE_AMT = 30;
    private static final Color RED_OUTLINE_COLOR = new Color(-10132568);
    private static final Color GREEN_OUTLINE_COLOR = new Color(2147418280);
    private static final Color BLUE_OUTLINE_COLOR = new Color(-2016482392);
    private static final Color BLACK_OUTLINE_COLOR = new Color(168);
    private float shinyTimer = 0.0f;
    private static final float SHINY_INTERVAL = 0.2f;
    public UnlockConfirmButton button = new UnlockConfirmButton();
    public long id;
    private static final UIStrings uiStrings = CardCrawlGame.languagePack.getUIString("UnlockScreen");
    public static final String[] TEXT = GashaUnlockScreen.uiStrings.TEXT;

    public void open(ArrayList<AbstractUnlock> unlock) {
        int i;
        AbstractDungeon.screen = AbstractDungeon.CurrentScreen.GASHA_UNLOCK;
        this.unlockBundle = unlock;
        this.button.show();
        this.id = CardCrawlGame.sound.play("UNLOCK_SCREEN");
        this.cones.clear();
        for (i = 0; i < 30; ++i) {
            this.cones.add(new ConeEffect());
        }
        switch (this.unlockBundle.get((int)0).type) {
            case CARD: {
                for (i = 0; i < this.unlockBundle.size(); ++i) {
                    UnlockTracker.unlockCard(this.unlockBundle.get((int)i).card.cardID);
                    AbstractDungeon.dynamicBanner.appearInstantly(TEXT[0]);
                    this.unlockBundle.get((int)i).card.targetDrawScale = 1.0f;
                    this.unlockBundle.get((int)i).card.drawScale = 0.01f;
                    this.unlockBundle.get((int)i).card.current_x = (float)Settings.WIDTH * (0.25f * (float)(i + 1));
                    this.unlockBundle.get((int)i).card.current_y = (float)Settings.HEIGHT / 2.0f;
                    this.unlockBundle.get((int)i).card.target_x = (float)Settings.WIDTH * (0.25f * (float)(i + 1));
                    this.unlockBundle.get((int)i).card.target_y = (float)Settings.HEIGHT / 2.0f - 30.0f * Settings.scale;
                }
                break;
            }
            case RELIC: {
                for (i = 0; i < this.unlockBundle.size(); ++i) {
                    UnlockTracker.hardUnlockOverride(this.unlockBundle.get((int)i).relic.relicId);
                    UnlockTracker.markRelicAsSeen(this.unlockBundle.get((int)i).relic.relicId);
                    AbstractDungeon.dynamicBanner.appearInstantly(TEXT[1]);
                    this.unlockBundle.get((int)i).relic.currentX = (float)Settings.WIDTH * (0.25f * (float)(i + 1));
                    this.unlockBundle.get((int)i).relic.currentY = (float)Settings.HEIGHT / 2.0f;
                    this.unlockBundle.get((int)i).relic.hitbox.move(this.unlockBundle.get((int)i).relic.currentX, this.unlockBundle.get((int)i).relic.currentY);
                }
                break;
            }
            case CHARACTER: {
                this.unlockBundle.get(0).onUnlockScreenOpen();
                AbstractDungeon.dynamicBanner.appearInstantly(TEXT[2]);
                break;
            }
            case MISC: {
                break;
            }
        }
    }

    public void reOpen() {
        int i;
        AbstractDungeon.screen = AbstractDungeon.CurrentScreen.GASHA_UNLOCK;
        this.button.show();
        this.id = CardCrawlGame.sound.play("UNLOCK_SCREEN");
        this.cones.clear();
        for (i = 0; i < 30; ++i) {
            this.cones.add(new ConeEffect());
        }
        switch (this.unlockBundle.get((int)0).type) {
            case CARD: {
                for (i = 0; i < this.unlockBundle.size(); ++i) {
                    UnlockTracker.unlockCard(this.unlockBundle.get((int)i).card.cardID);
                    AbstractDungeon.dynamicBanner.appearInstantly(TEXT[0]);
                    this.unlockBundle.get((int)i).card.targetDrawScale = 1.0f;
                    this.unlockBundle.get((int)i).card.drawScale = 0.01f;
                    this.unlockBundle.get((int)i).card.current_x = (float)Settings.WIDTH * (0.25f * (float)(i + 1));
                    this.unlockBundle.get((int)i).card.current_y = (float)Settings.HEIGHT / 2.0f;
                    this.unlockBundle.get((int)i).card.target_x = (float)Settings.WIDTH * (0.25f * (float)(i + 1));
                    this.unlockBundle.get((int)i).card.target_y = (float)Settings.HEIGHT / 2.0f - 30.0f * Settings.scale;
                }
                break;
            }
            case RELIC: {
                for (i = 0; i < this.unlockBundle.size(); ++i) {
                    UnlockTracker.hardUnlockOverride(this.unlockBundle.get((int)i).relic.relicId);
                    UnlockTracker.markRelicAsSeen(this.unlockBundle.get((int)i).relic.relicId);
                    AbstractDungeon.dynamicBanner.appearInstantly(TEXT[1]);
                    this.unlockBundle.get((int)i).relic.currentX = (float)Settings.WIDTH * (0.25f * (float)(i + 1));
                    this.unlockBundle.get((int)i).relic.currentY = (float)Settings.HEIGHT / 2.0f;
                    this.unlockBundle.get((int)i).relic.hitbox.move(this.unlockBundle.get((int)i).relic.currentX, this.unlockBundle.get((int)i).relic.currentY);
                }
                break;
            }
            case CHARACTER: {
                this.unlockBundle.get(0).onUnlockScreenOpen();
                AbstractDungeon.dynamicBanner.appearInstantly(TEXT[2]);
                break;
            }
            case MISC: {
                break;
            }
        }
    }

    public void update() {
        this.shinyTimer -= Gdx.graphics.getDeltaTime();
        if (this.shinyTimer < 0.0f) {
            this.shinyTimer = 0.2f;
            AbstractDungeon.topLevelEffects.add(new RoomShineEffect());
            AbstractDungeon.topLevelEffects.add(new RoomShineEffect());
            AbstractDungeon.topLevelEffects.add(new RoomShineEffect2());
        }
        switch (this.unlockBundle.get((int)0).type) {
            case CARD: {
                this.updateConeEffect();
                for (int i = 0; i < this.unlockBundle.size(); ++i) {
                    this.unlockBundle.get((int)i).card.update();
                    this.unlockBundle.get((int)i).card.updateHoverLogic();
                    this.unlockBundle.get((int)i).card.targetDrawScale = 1.0f;
                }
                break;
            }
            case RELIC: {
                this.updateConeEffect();
                for (int i = 0; i < this.unlockBundle.size(); ++i) {
                    this.unlockBundle.get((int)i).relic.update();
                }
                break;
            }
            case CHARACTER: {
                this.updateConeEffect();
                this.unlockBundle.get((int)0).player.update();
                break;
            }
        }
        this.button.update();
    }

    private void updateConeEffect() {
        Iterator<ConeEffect> e = this.cones.iterator();
        while (e.hasNext()) {
            ConeEffect d = e.next();
            d.update();
            if (!d.isDone) continue;
            e.remove();
        }
        if (this.cones.size() < 30) {
            this.cones.add(new ConeEffect());
        }
    }

    public void render(SpriteBatch sb) {
        sb.setColor(new Color(0.05f, 0.15f, 0.18f, 1.0f));
        sb.draw(ImageMaster.WHITE_SQUARE_IMG, 0.0f, 0.0f, (float)Settings.WIDTH, (float)Settings.HEIGHT);
        sb.setBlendFunction(770, 1);
        for (ConeEffect e : this.cones) {
            e.render(sb);
        }
        sb.setBlendFunction(770, 771);
        switch (this.unlockBundle.get((int)0).type) {
            case CARD: {
                for (int i = 0; i < this.unlockBundle.size(); ++i) {
                    this.unlockBundle.get((int)i).card.renderHoverShadow(sb);
                    this.unlockBundle.get((int)i).card.render(sb);
                    this.unlockBundle.get((int)i).card.renderCardTip(sb);
                }
                sb.setColor(new Color(0.0f, 0.0f, 0.0f, 0.66f));
                sb.draw(ImageMaster.UNLOCK_TEXT_BG, (float)Settings.WIDTH / 2.0f - 500.0f, 274.0f * Settings.scale - 130.0f, 500.0f, 130.0f, 1000.0f, 130.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 1000, 260, false, false);
                FontHelper.renderFontCentered(sb, FontHelper.cardTitleFont_small_N, TEXT[3], (float)Settings.WIDTH / 2.0f, 210.0f * Settings.scale, Settings.CREAM_COLOR);
                break;
            }
            case CHARACTER: {
                this.unlockBundle.get(0).render(sb);
                this.unlockBundle.get((int)0).player.renderPlayerImage(sb);
                break;
            }
            case RELIC: {
                for (int i = 0; i < this.unlockBundle.size(); ++i) {
                    if (RelicLibrary.redList.contains(this.unlockBundle.get((int)i).relic)) {
                        this.unlockBundle.get((int)i).relic.render(sb, false, RED_OUTLINE_COLOR);
                    } else if (RelicLibrary.greenList.contains(this.unlockBundle.get((int)i).relic)) {
                        this.unlockBundle.get((int)i).relic.render(sb, false, GREEN_OUTLINE_COLOR);
                    } else if (RelicLibrary.blueList.contains(this.unlockBundle.get((int)i).relic)) {
                        this.unlockBundle.get((int)i).relic.render(sb, false, BLUE_OUTLINE_COLOR);
                    } else {
                        this.unlockBundle.get((int)i).relic.render(sb, false, BLACK_OUTLINE_COLOR);
                    }
                    sb.setColor(new Color(0.0f, 0.0f, 0.0f, 0.66f));
                    sb.draw(ImageMaster.UNLOCK_TEXT_BG, (float)Settings.WIDTH / 2.0f - 500.0f, 280.0f * Settings.scale - 130.0f, 500.0f, 130.0f, 1000.0f, 130.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 1000, 260, false, false);
                    FontHelper.renderFontCentered(sb, FontHelper.bannerFont, this.unlockBundle.get((int)i).relic.name, (float)Settings.WIDTH * (0.25f * (float)(i + 1)), (float)Settings.HEIGHT / 2.0f - 150.0f * Settings.scale, Settings.GOLD_COLOR);
                }
                FontHelper.renderFontCentered(sb, FontHelper.cardTitleFont_small_N, TEXT[4], (float)Settings.WIDTH / 2.0f, 220.0f * Settings.scale, Settings.CREAM_COLOR);
                break;
            }
        }
        this.button.render(sb);
    }
}

