/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.events.thecity;

import com.badlogic.gdx.math.MathUtils;
import com.megacrit.cardcrawl.cards.curses.Writhe;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.events.AbstractEvent;
import com.megacrit.cardcrawl.events.AbstractImageEvent;
import com.megacrit.cardcrawl.events.GenericEventDialog;
import com.megacrit.cardcrawl.helpers.CardLibrary;
import com.megacrit.cardcrawl.localization.EventStrings;
import com.megacrit.cardcrawl.unlock.UnlockTracker;
import com.megacrit.cardcrawl.vfx.cardManip.ShowCardAndObtainEffect;

public class TheMausoleum
extends AbstractImageEvent {
    public static final String ID = "The Mausoleum";
    private static final EventStrings eventStrings = CardCrawlGame.languagePack.getEventString("The Mausoleum");
    public static final String NAME = TheMausoleum.eventStrings.NAME;
    public static final String[] DESCRIPTIONS = TheMausoleum.eventStrings.DESCRIPTIONS;
    public static final String[] OPTIONS = TheMausoleum.eventStrings.OPTIONS;
    private static final String DIALOG_1 = DESCRIPTIONS[0];
    private static final String CURSED_RESULT = DESCRIPTIONS[1];
    private static final String NORMAL_RESULT = DESCRIPTIONS[2];
    private static final String NOPE_RESULT = DESCRIPTIONS[3];
    private CurScreen screen = CurScreen.INTRO;

    public TheMausoleum() {
        super(NAME, DIALOG_1, "images/events/mausoleum.jpg");
        GenericEventDialog.setDialogOption(OPTIONS[0], CardLibrary.getCopy("Writhe"));
        GenericEventDialog.setDialogOption(OPTIONS[1]);
    }

    @Override
    public void update() {
        super.update();
    }

    @Override
    protected void buttonEffect(int buttonPressed) {
        switch (this.screen) {
            case INTRO: {
                switch (buttonPressed) {
                    case 0: {
                        if (MathUtils.randomBoolean()) {
                            GenericEventDialog.updateBodyText(CURSED_RESULT);
                            AbstractDungeon.effectList.add(new ShowCardAndObtainEffect(new Writhe(), Settings.WIDTH / 2, Settings.HEIGHT / 2));
                            UnlockTracker.markCardAsSeen("Writhe");
                        } else {
                            GenericEventDialog.updateBodyText(NORMAL_RESULT);
                        }
                        CardCrawlGame.sound.play("BLUNT_HEAVY");
                        CardCrawlGame.screenShake.rumble(2.0f);
                        AbstractDungeon.getCurrRoom().spawnRelicAndObtain(Settings.WIDTH / 2, Settings.HEIGHT / 2, AbstractDungeon.returnRandomScreenlessRelic(AbstractDungeon.returnRandomRelicTier()));
                        this.logMetric("Yes");
                        break;
                    }
                    default: {
                        GenericEventDialog.updateBodyText(NOPE_RESULT);
                        this.logMetric("No");
                    }
                }
                GenericEventDialog.clearAllDialogs();
                GenericEventDialog.setDialogOption(OPTIONS[1]);
                this.screen = CurScreen.RESULT;
                break;
            }
            default: {
                this.openMap();
            }
        }
    }

    public void logMetric(String actionTaken) {
        AbstractEvent.logMetric(ID, actionTaken);
    }

    private static enum CurScreen {
        INTRO,
        RESULT;

    }
}

