/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.events.thecity;

import com.badlogic.gdx.math.MathUtils;
import com.megacrit.cardcrawl.cards.DamageInfo;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.events.AbstractEvent;
import com.megacrit.cardcrawl.events.AbstractImageEvent;
import com.megacrit.cardcrawl.events.GenericEventDialog;
import com.megacrit.cardcrawl.helpers.RelicLibrary;
import com.megacrit.cardcrawl.localization.EventStrings;
import com.megacrit.cardcrawl.relics.AbstractRelic;

public class CursedTome
extends AbstractImageEvent {
    public static final String ID = "Cursed Tome";
    private static final EventStrings eventStrings = CardCrawlGame.languagePack.getEventString("Cursed Tome");
    public static final String NAME = CursedTome.eventStrings.NAME;
    public static final String[] DESCRIPTIONS = CursedTome.eventStrings.DESCRIPTIONS;
    public static final String[] OPTIONS = CursedTome.eventStrings.OPTIONS;
    private static final String INTRO_MSG = DESCRIPTIONS[0];
    private static final String READ_1 = DESCRIPTIONS[1];
    private static final String READ_2 = DESCRIPTIONS[2];
    private static final String READ_3 = DESCRIPTIONS[3];
    private static final String READ_4 = DESCRIPTIONS[4];
    private static final String OBTAIN_MSG = DESCRIPTIONS[5];
    private static final String IGNORE_MSG = DESCRIPTIONS[6];
    private static final String STOP_MSG = DESCRIPTIONS[7];
    private static final String OPT_READ = OPTIONS[0];
    private static final String OPT_CONTINUE_1 = OPTIONS[1];
    private static final String OPT_CONTINUE_2 = OPTIONS[2];
    private static final String OPT_CONTINUE_3 = OPTIONS[3];
    private static final String OPT_STOP = OPTIONS[4];
    private static final String OPT_OBTAIN = OPTIONS[5];
    private static final String OPT_LEAVE = OPTIONS[6];
    private static final int DMG_BOOK_OPEN = 1;
    private static final int DMG_SECOND_PAGE = 2;
    private static final int DMG_THIRD_PAGE = 3;
    private static final int DMG_OBTAIN_BOOK = 10;
    private static final int DMG_STOP_READING = 3;
    private CurScreen screen = CurScreen.INTRO;

    public CursedTome() {
        super(NAME, INTRO_MSG, "images/events/cursedTome.jpg");
        GenericEventDialog.setDialogOption(OPT_READ);
        GenericEventDialog.setDialogOption(OPT_LEAVE);
    }

    @Override
    protected void buttonEffect(int buttonPressed) {
        switch (this.screen) {
            case INTRO: {
                GenericEventDialog.clearAllDialogs();
                if (buttonPressed == 0) {
                    GenericEventDialog.clearAllDialogs();
                    GenericEventDialog.setDialogOption(OPT_CONTINUE_1);
                    GenericEventDialog.updateBodyText(READ_1);
                    this.screen = CurScreen.PAGE_1;
                    break;
                }
                GenericEventDialog.clearAllDialogs();
                GenericEventDialog.setDialogOption(OPT_LEAVE);
                GenericEventDialog.updateBodyText(IGNORE_MSG);
                this.screen = CurScreen.END;
                this.logMetric("Ignored");
                break;
            }
            case PAGE_1: {
                AbstractDungeon.player.damage(new DamageInfo(null, 1, DamageInfo.DamageType.HP_LOSS));
                GenericEventDialog.clearAllDialogs();
                GenericEventDialog.setDialogOption(OPT_CONTINUE_2);
                GenericEventDialog.updateBodyText(READ_2);
                this.screen = CurScreen.PAGE_2;
                break;
            }
            case PAGE_2: {
                AbstractDungeon.player.damage(new DamageInfo(null, 2, DamageInfo.DamageType.HP_LOSS));
                GenericEventDialog.clearAllDialogs();
                GenericEventDialog.setDialogOption(OPT_CONTINUE_3);
                GenericEventDialog.updateBodyText(READ_3);
                this.screen = CurScreen.PAGE_3;
                break;
            }
            case PAGE_3: {
                AbstractDungeon.player.damage(new DamageInfo(null, 3, DamageInfo.DamageType.HP_LOSS));
                GenericEventDialog.clearAllDialogs();
                GenericEventDialog.setDialogOption(OPT_OBTAIN);
                GenericEventDialog.setDialogOption(OPT_STOP);
                GenericEventDialog.updateBodyText(READ_4);
                this.screen = CurScreen.LAST_PAGE;
                break;
            }
            case LAST_PAGE: {
                if (buttonPressed == 0) {
                    AbstractDungeon.player.damage(new DamageInfo(null, 10, DamageInfo.DamageType.HP_LOSS));
                    GenericEventDialog.updateBodyText(OBTAIN_MSG);
                    this.logMetric("Obtained Book");
                    this.randomBook();
                    GenericEventDialog.clearAllDialogs();
                    GenericEventDialog.setDialogOption(OPT_LEAVE);
                    this.screen = CurScreen.END;
                    break;
                }
                AbstractDungeon.player.damage(new DamageInfo(null, 3, DamageInfo.DamageType.HP_LOSS));
                GenericEventDialog.updateBodyText(STOP_MSG);
                this.logMetric("Stopped");
                GenericEventDialog.clearAllDialogs();
                GenericEventDialog.setDialogOption(OPT_LEAVE);
                this.screen = CurScreen.END;
                break;
            }
            case END: {
                this.openMap();
                break;
            }
        }
    }

    private void randomBook() {
        int roll = MathUtils.random(2);
        AbstractRelic r = roll == 0 ? RelicLibrary.getRelic("Nilry's Codex").makeCopy() : (roll == 1 ? RelicLibrary.getRelic("Necronomicon").makeCopy() : RelicLibrary.getRelic("Enchiridion").makeCopy());
        AbstractDungeon.getCurrRoom().spawnRelicAndObtain((float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT / 2.0f, r);
    }

    public void logMetric(String msg) {
        AbstractEvent.logMetric(ID, msg);
    }

    private static enum CurScreen {
        INTRO,
        PAGE_1,
        PAGE_2,
        PAGE_3,
        LAST_PAGE,
        END,
        IGNORED;

    }
}

