/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.events.thecity;

import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.colorless.JAX;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.events.AbstractEvent;
import com.megacrit.cardcrawl.events.AbstractImageEvent;
import com.megacrit.cardcrawl.events.GenericEventDialog;
import com.megacrit.cardcrawl.helpers.CardHelper;
import com.megacrit.cardcrawl.localization.EventStrings;
import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Addict
extends AbstractImageEvent {
    private static final Logger logger = LogManager.getLogger(Addict.class.getName());
    public static final String ID = "Addict";
    private static final EventStrings eventStrings = CardCrawlGame.languagePack.getEventString("Addict");
    public static final String NAME = Addict.eventStrings.NAME;
    public static final String[] DESCRIPTIONS = Addict.eventStrings.DESCRIPTIONS;
    public static final String[] OPTIONS = Addict.eventStrings.OPTIONS;
    private static final int GOLD_COST = 85;
    private static final String INTRO_BODY = DESCRIPTIONS[0];
    private static final String ACCEPT_BODY = DESCRIPTIONS[1];
    private static final String REJECT_BODY = DESCRIPTIONS[2];
    private int screenNum = 0;

    public Addict() {
        super(NAME, INTRO_BODY, "images/events/addict.jpg");
        if (AbstractDungeon.player.gold >= 85) {
            GenericEventDialog.setDialogOption(OPTIONS[0] + 85 + OPTIONS[1], AbstractDungeon.player.gold < 85);
        } else {
            GenericEventDialog.setDialogOption(OPTIONS[2] + 85 + OPTIONS[3], AbstractDungeon.player.gold < 85);
        }
        boolean hasJax = CardHelper.hasCardWithID("J.A.X.");
        if (hasJax) {
            GenericEventDialog.setDialogOption(OPTIONS[4], !hasJax);
        } else {
            GenericEventDialog.setDialogOption(OPTIONS[5], !hasJax);
        }
        GenericEventDialog.setDialogOption(OPTIONS[6]);
    }

    @Override
    protected void buttonEffect(int buttonPressed) {
        switch (this.screenNum) {
            case 0: {
                switch (buttonPressed) {
                    case 2: {
                        this.logMetric("Ignored");
                        GenericEventDialog.updateBodyText(REJECT_BODY);
                        GenericEventDialog.updateDialogOption(0, OPTIONS[7]);
                        GenericEventDialog.clearRemainingOptions();
                        break;
                    }
                    case 0: {
                        GenericEventDialog.updateBodyText(ACCEPT_BODY);
                        if (AbstractDungeon.player.gold < 85) break;
                        this.logMetric("Obtained Relic");
                        AbstractDungeon.player.loseGold(85);
                        AbstractDungeon.getCurrRoom().spawnRelicAndObtain(this.drawX, this.drawY, AbstractDungeon.returnRandomScreenlessRelic(AbstractDungeon.returnRandomRelicTier()));
                        GenericEventDialog.updateDialogOption(0, OPTIONS[7]);
                        GenericEventDialog.clearRemainingOptions();
                        break;
                    }
                    case 1: {
                        GenericEventDialog.updateBodyText(ACCEPT_BODY);
                        this.logMetric("Gave JAX");
                        Iterator<AbstractCard> i = AbstractDungeon.player.masterDeck.group.iterator();
                        while (i.hasNext()) {
                            AbstractCard e = i.next();
                            if (!(e instanceof JAX)) continue;
                            i.remove();
                        }
                        AbstractDungeon.getCurrRoom().spawnRelicAndObtain(this.drawX, this.drawY, AbstractDungeon.returnRandomScreenlessRelic(AbstractDungeon.returnRandomRelicTier()));
                        GenericEventDialog.updateDialogOption(0, OPTIONS[7]);
                        GenericEventDialog.clearRemainingOptions();
                        break;
                    }
                    default: {
                        logger.info("ERROR: Unhandled case " + buttonPressed);
                    }
                }
                this.screenNum = 1;
                break;
            }
            case 1: {
                this.openMap();
            }
        }
    }

    public void logMetric(String actionTaken) {
        AbstractEvent.logMetric(ID, actionTaken);
    }
}

