/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.events.thebottom;

import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.DamageInfo;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.events.AbstractEvent;
import com.megacrit.cardcrawl.events.AbstractImageEvent;
import com.megacrit.cardcrawl.events.GenericEventDialog;
import com.megacrit.cardcrawl.localization.EventStrings;
import com.megacrit.cardcrawl.vfx.UpgradeShineEffect;
import com.megacrit.cardcrawl.vfx.cardManip.ShowCardBrieflyEffect;
import com.megacrit.cardcrawl.vfx.combat.FlashAtkImgEffect;
import java.util.ArrayList;
import java.util.Collections;

public class ShiningLight
extends AbstractImageEvent {
    public static final String ID = "Shining Light";
    private static final EventStrings eventStrings = CardCrawlGame.languagePack.getEventString("Shining Light");
    public static final String NAME = ShiningLight.eventStrings.NAME;
    public static final String[] DESCRIPTIONS = ShiningLight.eventStrings.DESCRIPTIONS;
    public static final String[] OPTIONS = ShiningLight.eventStrings.OPTIONS;
    private static final String INTRO = DESCRIPTIONS[0];
    private static final String AGREE_DIALOG = DESCRIPTIONS[1];
    private static final String DISAGREE_DIALOG = DESCRIPTIONS[2];
    private int damage = 0;
    private CUR_SCREEN screen = CUR_SCREEN.INTRO;

    public ShiningLight() {
        super(NAME, INTRO, "images/events/shiningLight.jpg");
        this.damage = AbstractDungeon.player.maxHealth / 5;
        GenericEventDialog.setDialogOption(OPTIONS[0] + this.damage + OPTIONS[1]);
        GenericEventDialog.setDialogOption(OPTIONS[2]);
    }

    @Override
    protected void buttonEffect(int buttonPressed) {
        switch (this.screen) {
            case INTRO: {
                if (buttonPressed == 0) {
                    GenericEventDialog.updateBodyText(AGREE_DIALOG);
                    GenericEventDialog.removeDialogOption(1);
                    GenericEventDialog.updateDialogOption(0, OPTIONS[2]);
                    this.screen = CUR_SCREEN.COMPLETE;
                    AbstractDungeon.player.damage(new DamageInfo(AbstractDungeon.player, this.damage));
                    AbstractDungeon.effectList.add(new FlashAtkImgEffect(AbstractDungeon.player.hb.cX, AbstractDungeon.player.hb.cY, AbstractGameAction.AttackEffect.FIRE));
                    this.upgradeCards();
                    this.logMetric("Entered Light");
                    break;
                }
                GenericEventDialog.updateBodyText(DISAGREE_DIALOG);
                GenericEventDialog.removeDialogOption(1);
                GenericEventDialog.updateDialogOption(0, OPTIONS[2]);
                this.screen = CUR_SCREEN.COMPLETE;
                this.logMetric("Ignored");
                break;
            }
            default: {
                this.openMap();
            }
        }
    }

    private void upgradeCards() {
        AbstractDungeon.topLevelEffects.add(new UpgradeShineEffect((float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT / 2.0f));
        ArrayList<AbstractCard> upgradableCards = new ArrayList<AbstractCard>();
        for (AbstractCard c : AbstractDungeon.player.masterDeck.group) {
            if (!c.canUpgrade()) continue;
            upgradableCards.add(c);
        }
        Collections.shuffle(upgradableCards);
        if (!upgradableCards.isEmpty()) {
            if (upgradableCards.size() == 1) {
                ((AbstractCard)upgradableCards.get(0)).upgrade();
                AbstractDungeon.player.bottledCardUpgradeCheck((AbstractCard)upgradableCards.get(0));
                AbstractDungeon.effectList.add(new ShowCardBrieflyEffect(((AbstractCard)upgradableCards.get(0)).makeStatEquivalentCopy()));
            } else {
                ((AbstractCard)upgradableCards.get(0)).upgrade();
                ((AbstractCard)upgradableCards.get(1)).upgrade();
                AbstractDungeon.player.bottledCardUpgradeCheck((AbstractCard)upgradableCards.get(0));
                AbstractDungeon.player.bottledCardUpgradeCheck((AbstractCard)upgradableCards.get(1));
                AbstractDungeon.effectList.add(new ShowCardBrieflyEffect(((AbstractCard)upgradableCards.get(0)).makeStatEquivalentCopy(), (float)Settings.WIDTH / 2.0f - 190.0f * Settings.scale, (float)Settings.HEIGHT / 2.0f));
                AbstractDungeon.effectList.add(new ShowCardBrieflyEffect(((AbstractCard)upgradableCards.get(1)).makeStatEquivalentCopy(), (float)Settings.WIDTH / 2.0f + 190.0f * Settings.scale, (float)Settings.HEIGHT / 2.0f));
            }
        }
    }

    public void logMetric(String actionTaken) {
        AbstractEvent.logMetric(ID, actionTaken);
    }

    private static enum CUR_SCREEN {
        INTRO,
        COMPLETE;

    }
}

