/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.events.thebottom;

import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.events.AbstractEvent;
import com.megacrit.cardcrawl.events.AbstractImageEvent;
import com.megacrit.cardcrawl.events.GenericEventDialog;
import com.megacrit.cardcrawl.helpers.CardLibrary;
import com.megacrit.cardcrawl.localization.EventStrings;
import com.megacrit.cardcrawl.unlock.UnlockTracker;
import com.megacrit.cardcrawl.vfx.cardManip.ShowCardAndObtainEffect;

public class BigFish
extends AbstractImageEvent {
    public static final String ID = "Big Fish";
    private static final EventStrings eventStrings = CardCrawlGame.languagePack.getEventString("Big Fish");
    public static final String NAME = BigFish.eventStrings.NAME;
    public static final String[] DESCRIPTIONS = BigFish.eventStrings.DESCRIPTIONS;
    public static final String[] OPTIONS = BigFish.eventStrings.OPTIONS;
    private static final String DIALOG_1 = DESCRIPTIONS[0];
    private static final String BANANA_RESULT = DESCRIPTIONS[1];
    private static final String DONUT_RESULT = DESCRIPTIONS[2];
    private static final String BOX_RESULT = DESCRIPTIONS[4];
    private static final String BOX_BAD = DESCRIPTIONS[5];
    private int healAmt = 0;
    private static final int MAX_HP_AMT = 5;
    private CurScreen screen = CurScreen.INTRO;

    public BigFish() {
        super(NAME, DIALOG_1, "images/events/fishing.jpg");
        this.healAmt = AbstractDungeon.player.maxHealth / 3;
        GenericEventDialog.setDialogOption(OPTIONS[0] + this.healAmt + OPTIONS[1]);
        GenericEventDialog.setDialogOption(OPTIONS[2] + 5 + OPTIONS[3]);
        GenericEventDialog.setDialogOption(OPTIONS[4], CardLibrary.getCopy("Regret"));
    }

    @Override
    protected void buttonEffect(int buttonPressed) {
        switch (this.screen) {
            case INTRO: {
                switch (buttonPressed) {
                    case 0: {
                        AbstractDungeon.player.heal(this.healAmt, true);
                        GenericEventDialog.updateBodyText(BANANA_RESULT);
                        this.logMetric("Banana");
                        break;
                    }
                    case 1: {
                        AbstractDungeon.player.increaseMaxHp(5, true);
                        GenericEventDialog.updateBodyText(DONUT_RESULT);
                        this.logMetric("Donut");
                        break;
                    }
                    default: {
                        GenericEventDialog.updateBodyText(BOX_RESULT + BOX_BAD);
                        AbstractDungeon.effectList.add(new ShowCardAndObtainEffect(CardLibrary.getCopy("Regret"), Settings.WIDTH / 2, Settings.HEIGHT / 2));
                        UnlockTracker.markCardAsSeen("Regret");
                        AbstractDungeon.getCurrRoom().spawnRelicAndObtain(Settings.WIDTH / 2, Settings.HEIGHT / 2, AbstractDungeon.returnRandomScreenlessRelic(AbstractDungeon.returnRandomRelicTier()));
                        this.logMetric("Box");
                    }
                }
                GenericEventDialog.clearAllDialogs();
                GenericEventDialog.setDialogOption(OPTIONS[5]);
                this.screen = CurScreen.RESULT;
                break;
            }
            default: {
                this.openMap();
            }
        }
    }

    public void logMetric(String actionTaken) {
        AbstractEvent.logMetric(ID, actionTaken);
    }

    private static enum CurScreen {
        INTRO,
        RESULT;

    }
}

