/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.events.thebeyond;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.MathUtils;
import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.characters.AnimatedNpc;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.events.AbstractEvent;
import com.megacrit.cardcrawl.events.RoomEventDialog;
import com.megacrit.cardcrawl.helpers.HeartAnimListener;
import com.megacrit.cardcrawl.localization.EventStrings;
import com.megacrit.cardcrawl.screens.DeathScreen;
import com.megacrit.cardcrawl.steam.SteamSaveSync;
import com.megacrit.cardcrawl.vfx.BorderFlashEffect;
import com.megacrit.cardcrawl.vfx.combat.DamageHeartEffect;
import com.megacrit.cardcrawl.vfx.combat.FlashAtkImgEffect;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SpireHeart
extends AbstractEvent {
    private static final Logger logger = LogManager.getLogger(SpireHeart.class.getName());
    public static final String ID = "Spire Heart";
    private static final EventStrings eventStrings = CardCrawlGame.languagePack.getEventString("Spire Heart");
    public static final String NAME = SpireHeart.eventStrings.NAME;
    public static final String[] DESCRIPTIONS = SpireHeart.eventStrings.DESCRIPTIONS;
    public static final String[] OPTIONS = SpireHeart.eventStrings.OPTIONS;
    private CUR_SCREEN screen = CUR_SCREEN.INTRO;
    private AnimatedNpc npc;
    private float x = 1300.0f * Settings.scale;
    private float y = (float)Settings.HEIGHT - 420.0f * Settings.scale;
    private long globalDamageDealt;
    private long totalDamageDealt;
    private int damageDealt;
    private static final String HEART_DMG_KEY = "test_stat";

    public SpireHeart() {
        this.npc = new AnimatedNpc(1300.0f * Settings.scale, (float)Settings.HEIGHT - 860.0f * Settings.scale, "images/npcs/heart/skeleton.atlas", "images/npcs/heart/skeleton.json", "idle");
        this.npc.setTimeScale(1.5f);
        this.npc.addListener(new HeartAnimListener());
        this.body = DESCRIPTIONS[0];
        AbstractDungeon.dialog.clear();
        RoomEventDialog.addDialogOption(OPTIONS[0]);
        this.hasDialog = true;
        this.hasFocus = true;
        this.globalDamageDealt = SteamSaveSync.getGlobalStat(HEART_DMG_KEY);
        this.damageDealt = DeathScreen.calcScore(true);
        SteamSaveSync.incrementStat(HEART_DMG_KEY, this.damageDealt);
        this.totalDamageDealt = SteamSaveSync.getStat(HEART_DMG_KEY);
        CardCrawlGame.playerPref.putInteger("DMG_DEALT", this.damageDealt + CardCrawlGame.playerPref.getInteger("DMG_DEALT", 0));
        if (this.totalDamageDealt == -1L) {
            this.totalDamageDealt = CardCrawlGame.playerPref.getInteger("DMG_DEALT", 0);
        }
    }

    @Override
    public void update() {
        super.update();
        if (!RoomEventDialog.waitForInput) {
            this.buttonEffect(RoomEventDialog.getSelectedOption());
        }
    }

    private void buttonEffect(int buttonPressed) {
        block0 : switch (this.screen) {
            case INTRO: {
                this.screen = CUR_SCREEN.MIDDLE;
                switch (AbstractDungeon.player.chosenClass) {
                    case IRONCLAD: {
                        RoomEventDialog.updateBodyText(DESCRIPTIONS[8]);
                        break;
                    }
                    case THE_SILENT: {
                        RoomEventDialog.updateBodyText(DESCRIPTIONS[9]);
                        break;
                    }
                    case CROWBOT: {
                        RoomEventDialog.updateBodyText(DESCRIPTIONS[10]);
                        break;
                    }
                }
                RoomEventDialog.updateDialogOption(0, OPTIONS[1]);
                break;
            }
            case MIDDLE: {
                this.screen = CUR_SCREEN.MIDDLE_2;
                RoomEventDialog.updateBodyText(DESCRIPTIONS[1] + this.damageDealt + DESCRIPTIONS[2]);
                RoomEventDialog.updateDialogOption(0, OPTIONS[0]);
                AbstractGameAction.AttackEffect e = AbstractGameAction.AttackEffect.SLASH_HEAVY;
                float tmp = 0.0f;
                switch (AbstractDungeon.player.chosenClass) {
                    case IRONCLAD: {
                        AbstractDungeon.effectList.add(new BorderFlashEffect(Color.RED, true));
                        for (int i = 0; i < 6; ++i) {
                            AbstractDungeon.effectList.add(new DamageHeartEffect(tmp, 1300.0f * Settings.scale, (float)Settings.HEIGHT - 500.0f * Settings.scale, e));
                            e = e == AbstractGameAction.AttackEffect.SLASH_HEAVY ? AbstractGameAction.AttackEffect.FIRE : (e == AbstractGameAction.AttackEffect.FIRE ? AbstractGameAction.AttackEffect.BLUNT_HEAVY : AbstractGameAction.AttackEffect.SLASH_HEAVY);
                            tmp += MathUtils.random(0.05f, 0.2f);
                        }
                        break block0;
                    }
                    case THE_SILENT: {
                        AbstractDungeon.effectList.add(new BorderFlashEffect(Color.GREEN, true));
                        for (int i = 0; i < 6; ++i) {
                            AbstractDungeon.effectList.add(new DamageHeartEffect(tmp, this.x, this.y - 80.0f * Settings.scale, e));
                            e = e == AbstractGameAction.AttackEffect.SLASH_HEAVY ? AbstractGameAction.AttackEffect.POISON : (e == AbstractGameAction.AttackEffect.POISON ? AbstractGameAction.AttackEffect.SLASH_DIAGONAL : AbstractGameAction.AttackEffect.SLASH_HEAVY);
                            tmp += MathUtils.random(0.05f, 0.2f);
                        }
                        break block0;
                    }
                    case CROWBOT: {
                        new FlashAtkImgEffect(this.x, this.y, AbstractGameAction.AttackEffect.SLASH_HEAVY);
                        break;
                    }
                }
                break;
            }
            case MIDDLE_2: {
                this.screen = CUR_SCREEN.END;
                if (this.globalDamageDealt == -1L) {
                    RoomEventDialog.updateBodyText(DESCRIPTIONS[3] + this.totalDamageDealt + DESCRIPTIONS[4] + DESCRIPTIONS[7]);
                } else {
                    RoomEventDialog.updateBodyText(DESCRIPTIONS[3] + this.totalDamageDealt + DESCRIPTIONS[4] + DESCRIPTIONS[5] + this.globalDamageDealt + DESCRIPTIONS[6] + DESCRIPTIONS[7]);
                }
                RoomEventDialog.updateDialogOption(0, OPTIONS[2]);
                break;
            }
            case END: {
                AbstractDungeon.player.isDying = true;
                this.hasFocus = false;
                AbstractDungeon.dialog.hide();
                AbstractDungeon.player.isDead = true;
                AbstractDungeon.deathScreen = new DeathScreen(null);
                break;
            }
            default: {
                logger.info("WHY YOU CALLED?");
            }
        }
    }

    @Override
    public void render(SpriteBatch sb) {
        this.npc.render(sb);
    }

    private static enum CUR_SCREEN {
        INTRO,
        MIDDLE,
        MIDDLE_2,
        END;

    }
}

