/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.events.shrines;

import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.events.AbstractEvent;
import com.megacrit.cardcrawl.events.AbstractImageEvent;
import com.megacrit.cardcrawl.events.GenericEventDialog;
import com.megacrit.cardcrawl.localization.EventStrings;
import com.megacrit.cardcrawl.vfx.cardManip.PurgeCardEffect;

public class FountainOfCurseRemoval
extends AbstractImageEvent {
    public static final String ID = "Fountain of Cleansing";
    private static final EventStrings eventStrings = CardCrawlGame.languagePack.getEventString("Fountain of Cleansing");
    public static final String NAME = FountainOfCurseRemoval.eventStrings.NAME;
    public static final String[] DESCRIPTIONS = FountainOfCurseRemoval.eventStrings.DESCRIPTIONS;
    public static final String[] OPTIONS = FountainOfCurseRemoval.eventStrings.OPTIONS;
    private static final String DIALOG_1 = DESCRIPTIONS[0];
    private static final String DIALOG_2 = DESCRIPTIONS[1];
    private static final String DIALOG_3 = DESCRIPTIONS[2];
    private int screenNum = 0;

    public FountainOfCurseRemoval() {
        super(NAME, DIALOG_1, "images/events/fountain.jpg");
        GenericEventDialog.setDialogOption(OPTIONS[0]);
        GenericEventDialog.setDialogOption(OPTIONS[1]);
    }

    @Override
    public void onEnterRoom() {
        CardCrawlGame.music.playTempBGM("SHRINE");
    }

    @Override
    protected void buttonEffect(int buttonPressed) {
        block0 : switch (this.screenNum) {
            case 0: {
                switch (buttonPressed) {
                    case 0: {
                        GenericEventDialog.updateBodyText(DIALOG_2);
                        this.screenNum = 1;
                        for (int i = AbstractDungeon.player.masterDeck.group.size() - 1; i >= 0; --i) {
                            if (AbstractDungeon.player.masterDeck.group.get((int)i).type != AbstractCard.CardType.CURSE || AbstractDungeon.player.masterDeck.group.get((int)i).inBottleFlame || AbstractDungeon.player.masterDeck.group.get((int)i).inBottleLightning) continue;
                            AbstractDungeon.effectList.add(new PurgeCardEffect(AbstractDungeon.player.masterDeck.group.get(i)));
                            AbstractDungeon.player.masterDeck.removeCard(AbstractDungeon.player.masterDeck.group.get(i));
                        }
                        GenericEventDialog.updateDialogOption(0, OPTIONS[1]);
                        GenericEventDialog.clearRemainingOptions();
                        this.logMetric("Removed Curse");
                        break block0;
                    }
                }
                this.logMetric("Ignored");
                GenericEventDialog.updateBodyText(DIALOG_3);
                GenericEventDialog.updateDialogOption(0, OPTIONS[1]);
                GenericEventDialog.clearRemainingOptions();
                this.screenNum = 1;
                break;
            }
            case 1: {
                this.openMap();
                break;
            }
            default: {
                this.openMap();
            }
        }
    }

    public void logMetric(String cardGiven) {
        AbstractEvent.logMetric(ID, cardGiven);
    }
}

