/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.events.shrines;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.CardGroup;
import com.megacrit.cardcrawl.cards.blue.Lightning;
import com.megacrit.cardcrawl.cards.green.CloakAndDagger;
import com.megacrit.cardcrawl.cards.red.Bash;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.events.AbstractEvent;
import com.megacrit.cardcrawl.events.AbstractTextEvent;
import com.megacrit.cardcrawl.events.GenericEventDialog;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.InputHelper;
import com.megacrit.cardcrawl.localization.EventStrings;
import com.megacrit.cardcrawl.vfx.cardManip.ShowCardAndObtainEffect;
import java.util.ArrayList;
import java.util.Collections;

public class DemonMatchGame
extends AbstractTextEvent {
    public static final String ID = "Match and Keep!";
    private static final EventStrings eventStrings = CardCrawlGame.languagePack.getEventString("Match and Keep!");
    public static final String NAME = DemonMatchGame.eventStrings.NAME;
    public static final String[] DESCRIPTIONS = DemonMatchGame.eventStrings.DESCRIPTIONS;
    public static final String[] OPTIONS = DemonMatchGame.eventStrings.OPTIONS;
    private AbstractCard chosenCard;
    private AbstractCard hoveredCard;
    private boolean cardFlipped = false;
    private boolean gameDone = false;
    private boolean cleanUpCalled = false;
    private int attemptCount = 5;
    private CardGroup cards = new CardGroup(CardGroup.CardGroupType.UNSPECIFIED);
    private float waitTimer = 0.0f;
    private int cardsMatched = 0;
    private CUR_SCREEN screen = CUR_SCREEN.INTRO;
    private static final String MSG_2 = DESCRIPTIONS[0];
    private static final String MSG_3 = DESCRIPTIONS[1];

    public DemonMatchGame() {
        super(NAME, DESCRIPTIONS[2]);
        this.cards.group = this.initializeCards();
        Collections.shuffle(this.cards.group);
        GenericEventDialog.setDialogOption(OPTIONS[0]);
    }

    private ArrayList<AbstractCard> initializeCards() {
        ArrayList<AbstractCard> retVal = new ArrayList<AbstractCard>();
        ArrayList<AbstractCard> retVal2 = new ArrayList<AbstractCard>();
        retVal.add(AbstractDungeon.getCard(AbstractCard.CardRarity.RARE).makeCopy());
        retVal.add(AbstractDungeon.getCard(AbstractCard.CardRarity.UNCOMMON).makeCopy());
        retVal.add(AbstractDungeon.getCard(AbstractCard.CardRarity.COMMON).makeCopy());
        retVal.add(AbstractDungeon.returnColorlessCard(AbstractCard.CardRarity.UNCOMMON).makeCopy());
        retVal.add(AbstractDungeon.returnRandomCurse());
        switch (AbstractDungeon.player.chosenClass) {
            case IRONCLAD: {
                retVal.add(new Bash());
                break;
            }
            case THE_SILENT: {
                retVal.add(new CloakAndDagger());
                break;
            }
            case CROWBOT: {
                retVal.add(new Lightning());
                break;
            }
        }
        for (AbstractCard c : retVal) {
            retVal2.add(c.makeCopy());
        }
        retVal.addAll(retVal2);
        for (AbstractCard c : retVal) {
            c.target_x = c.current_x = (float)Settings.WIDTH / 2.0f;
            c.target_y = c.current_y = -300.0f * Settings.scale;
        }
        return retVal;
    }

    @Override
    public void update() {
        super.update();
        this.cards.update();
        if (this.screen == CUR_SCREEN.PLAY) {
            this.updateMatchGameLogic();
        } else if (this.screen == CUR_SCREEN.CLEAN_UP) {
            if (!this.cleanUpCalled) {
                this.cleanUpCalled = true;
                this.cleanUpCards();
            }
            if (this.waitTimer > 0.0f) {
                this.waitTimer -= Gdx.graphics.getDeltaTime();
                if (this.waitTimer < 0.0f) {
                    this.waitTimer = 0.0f;
                    this.screen = CUR_SCREEN.COMPLETE;
                    GenericEventDialog.show();
                    GenericEventDialog.updateBodyText(MSG_3);
                    GenericEventDialog.clearRemainingOptions();
                    GenericEventDialog.setDialogOption(OPTIONS[1]);
                }
            }
        }
        if (!GenericEventDialog.waitForInput) {
            this.buttonEffect(GenericEventDialog.getSelectedOption());
        }
    }

    private void cleanUpCards() {
        for (AbstractCard c : this.cards.group) {
            c.targetDrawScale = 0.5f;
            c.target_x = (float)Settings.WIDTH / 2.0f;
            c.target_y = -300.0f * Settings.scale;
        }
    }

    private void updateMatchGameLogic() {
        if (this.waitTimer == 0.0f) {
            this.hoveredCard = null;
            for (AbstractCard c : this.cards.group) {
                c.hb.update();
                if (this.hoveredCard == null && c.hb.hovered) {
                    c.drawScale = 0.7f;
                    c.targetDrawScale = 0.7f;
                    this.hoveredCard = c;
                    if (!InputHelper.justClickedLeft || !this.hoveredCard.isFlipped) continue;
                    InputHelper.justClickedLeft = false;
                    this.hoveredCard.isFlipped = false;
                    if (!this.cardFlipped) {
                        this.cardFlipped = true;
                        this.chosenCard = this.hoveredCard;
                        continue;
                    }
                    this.cardFlipped = false;
                    if (this.chosenCard.cardID.equals(this.hoveredCard.cardID)) {
                        this.waitTimer = 1.0f;
                        this.chosenCard.targetDrawScale = 0.7f;
                        this.chosenCard.target_x = (float)Settings.WIDTH / 2.0f;
                        this.chosenCard.target_y = (float)Settings.HEIGHT / 2.0f;
                        this.hoveredCard.targetDrawScale = 0.7f;
                        this.hoveredCard.target_x = (float)Settings.WIDTH / 2.0f;
                        this.hoveredCard.target_y = (float)Settings.HEIGHT / 2.0f;
                        continue;
                    }
                    this.waitTimer = 1.25f;
                    this.chosenCard.targetDrawScale = 1.0f;
                    this.hoveredCard.targetDrawScale = 1.0f;
                    continue;
                }
                if (c == this.chosenCard) continue;
                c.targetDrawScale = 0.5f;
            }
        } else {
            this.waitTimer -= Gdx.graphics.getDeltaTime();
            if (this.waitTimer < 0.0f && !this.gameDone) {
                this.waitTimer = 0.0f;
                if (this.chosenCard.cardID.equals(this.hoveredCard.cardID)) {
                    ++this.cardsMatched;
                    this.cards.group.remove(this.chosenCard);
                    this.cards.group.remove(this.hoveredCard);
                    AbstractDungeon.effectList.add(new ShowCardAndObtainEffect(this.chosenCard.makeCopy(), (float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT / 2.0f));
                    this.chosenCard = null;
                    this.hoveredCard = null;
                } else {
                    this.chosenCard.isFlipped = true;
                    this.hoveredCard.isFlipped = true;
                    this.chosenCard.targetDrawScale = 0.5f;
                    this.hoveredCard.targetDrawScale = 0.5f;
                }
                --this.attemptCount;
                if (this.attemptCount == 0) {
                    this.gameDone = true;
                    this.waitTimer = 1.0f;
                }
            } else if (this.gameDone) {
                this.screen = CUR_SCREEN.CLEAN_UP;
            }
        }
    }

    @Override
    protected void buttonEffect(int buttonPressed) {
        switch (this.screen) {
            case INTRO: {
                switch (buttonPressed) {
                    case 0: {
                        GenericEventDialog.updateBodyText(MSG_2);
                        GenericEventDialog.updateDialogOption(0, OPTIONS[2]);
                        this.screen = CUR_SCREEN.RULE_EXPLANATION;
                    }
                }
                break;
            }
            case RULE_EXPLANATION: {
                switch (buttonPressed) {
                    case 0: {
                        GenericEventDialog.removeDialogOption(0);
                        GenericEventDialog.hide();
                        this.screen = CUR_SCREEN.PLAY;
                        this.placeCards();
                    }
                }
                break;
            }
            case COMPLETE: {
                this.logMetric(this.cardsMatched + " cards matched");
                this.openMap();
                break;
            }
        }
    }

    private void placeCards() {
        for (int i = 0; i < this.cards.size(); ++i) {
            this.cards.group.get((int)i).target_x = (float)(i % 4) * 210.0f * Settings.scale + 640.0f * Settings.scale;
            this.cards.group.get((int)i).target_y = (float)(i % 3) * -230.0f * Settings.scale + 750.0f * Settings.scale;
            this.cards.group.get((int)i).targetDrawScale = 0.5f;
            this.cards.group.get((int)i).isFlipped = true;
        }
    }

    @Override
    public void render(SpriteBatch sb) {
        this.cards.render(sb);
        if (this.chosenCard != null) {
            this.chosenCard.render(sb);
        }
        if (this.hoveredCard != null) {
            this.hoveredCard.render(sb);
        }
        if (this.screen == CUR_SCREEN.PLAY) {
            FontHelper.renderSmartText(sb, FontHelper.deckBannerFont, OPTIONS[3] + this.attemptCount, 780.0f * Settings.scale, 80.0f * Settings.scale, 2000.0f * Settings.scale, 0.0f, Color.WHITE);
        }
    }

    public void logMetric(String result) {
        AbstractEvent.logMetric(ID, result);
    }

    @Override
    public void renderAboveTopPanel(SpriteBatch sb) {
    }

    private static enum CUR_SCREEN {
        INTRO,
        RULE_EXPLANATION,
        PLAY,
        COMPLETE,
        CLEAN_UP;

    }
}

