/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.events.deprecated;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.events.AbstractEvent;
import com.megacrit.cardcrawl.events.RoomEventDialog;
import com.megacrit.cardcrawl.rooms.AbstractRoom;
import com.megacrit.cardcrawl.shop.Merchant;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OLDTwinMerchants
extends AbstractEvent {
    private static final Logger logger = LogManager.getLogger(OLDTwinMerchants.class.getName());
    public static final String NAME = "Twin Merchants";
    private static final String DIALOG_1 = "Entering a fairly open area in this demented landscape, you are stunned to see *two* of the shopkeeper you have inexplicably seen scattered throughout the Spire. As you approach them the one calls out to you.";
    private static final String DIALOG_2 = "  W e l c o m e!  We are conducting important market research to determine what adventurers prefer. Please take a look at our goods. (Except for the rugs)";
    private int screenNum = 0;
    public Merchant merchant1;
    public Merchant merchant2;

    public OLDTwinMerchants() {
        this.body = "Entering a fairly open area in this demented landscape, you are stunned to see *two* of the shopkeeper you have inexplicably seen scattered throughout the Spire. As you approach them the one calls out to you.  W e l c o m e!  We are conducting important market research to determine what adventurers prefer. Please take a look at our goods. (Except for the rugs)";
        RoomEventDialog.addDialogOption("Go Shopping!");
        this.hasDialog = true;
        this.hasFocus = true;
        AbstractDungeon.getCurrRoom().playBGM("SHOP");
        AbstractDungeon.overlayMenu.proceedButton.setLabel("Skip Merchants");
    }

    @Override
    public void update() {
        super.update();
        if (!RoomEventDialog.waitForInput) {
            this.buttonEffect(RoomEventDialog.getSelectedOption());
        }
        if (!this.hasFocus && this.merchant1 != null) {
            this.merchant1.update();
            this.merchant2.update();
        }
    }

    private void buttonEffect(int buttonPressed) {
        switch (buttonPressed) {
            case 0: {
                AbstractDungeon.getCurrRoom().phase = AbstractRoom.RoomPhase.COMPLETE;
                AbstractDungeon.dialog.clear();
                this.hasFocus = false;
                AbstractDungeon.dialog.hide();
                this.hideAlpha = true;
                break;
            }
            default: {
                logger.info("UNSPECIFIED SCREEN: " + this.screenNum);
            }
        }
    }

    @Override
    public void render(SpriteBatch sb) {
        sb.setColor(Color.WHITE);
        if (this.merchant1 != null) {
            this.merchant1.render(sb);
            this.merchant2.render(sb);
        }
        AbstractDungeon.getCurrRoom().renderTips(sb);
    }
}

