/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.events.deprecated;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.DamageInfo;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.events.AbstractEvent;
import com.megacrit.cardcrawl.events.RoomEventDialog;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.vfx.cardManip.PurgeCardEffect;
import com.megacrit.cardcrawl.vfx.combat.FlashAtkImgEffect;
import java.util.ArrayList;
import java.util.Collections;

public class OLDShiningLight
extends AbstractEvent {
    public static final String NAME = "Shining Light";
    private Texture img = ImageMaster.loadImage("images/npcs/shiningLight.png");
    private static final String DIALOG_1 = "You find a shimmering mass of light encompassing the center of the room. NL Its warm glow and enchanting patterns invite you in.";
    private static final String DIALOG_2 = "As you walk through the light, you notice that the light is absorbed into you. NL It's scorching #r@hot@ ! However, the pain quickly resides. NL You feel #binvigorated, as though you received a well deserved slap.";
    private static final String DIALOG_3 = "NL You walk around it, wondering what could have been";
    private static final int IRONCLAD_DMG = 12;
    private static final int SILENT_DMG = 8;
    private int damage = 0;
    private int screenNum = 0;
    private boolean lightGone = false;

    public OLDShiningLight() {
        this.drawX = (float)Settings.WIDTH * 0.75f;
        this.drawY = AbstractDungeon.floorY;
        this.body = DIALOG_1;
        if (AbstractDungeon.player.chosenClass == AbstractPlayer.PlayerClass.IRONCLAD) {
            this.damage = 12;
        } else if (AbstractDungeon.player.chosenClass == AbstractPlayer.PlayerClass.THE_SILENT) {
            this.damage = 8;
        }
        RoomEventDialog.addDialogOption("[Enter] #gUpgrade #g2 #grandom #gcards. #rLose #r" + this.damage + " #rHP.");
        RoomEventDialog.addDialogOption("[Leave]");
        this.hasDialog = true;
        this.hasFocus = true;
    }

    @Override
    public void update() {
        super.update();
        if (!RoomEventDialog.waitForInput) {
            this.buttonEffect(RoomEventDialog.getSelectedOption());
        }
    }

    private void buttonEffect(int buttonPressed) {
        block0 : switch (this.screenNum) {
            case 0: {
                switch (buttonPressed) {
                    case 0: {
                        RoomEventDialog.updateBodyText(DIALOG_2);
                        AbstractDungeon.player.damage(new DamageInfo(AbstractDungeon.player, this.damage));
                        this.logMetric("Entered Light");
                        AbstractDungeon.effectList.add(new FlashAtkImgEffect(AbstractDungeon.player.hb.cX, AbstractDungeon.player.hb.cY, AbstractGameAction.AttackEffect.FIRE));
                        this.upgradeCards();
                        this.screenNum = 1;
                        RoomEventDialog.updateDialogOption(0, "[Leave]");
                        RoomEventDialog.removeDialogOption(1);
                        this.lightGone = true;
                        break block0;
                    }
                }
                this.logMetric("Ignored");
                RoomEventDialog.updateBodyText(DIALOG_3);
                this.screenNum = 1;
                RoomEventDialog.updateDialogOption(0, "[Leave]");
                RoomEventDialog.removeDialogOption(1);
                break;
            }
            case 1: {
                this.openMap();
                break;
            }
            default: {
                this.openMap();
            }
        }
    }

    private void upgradeCards() {
        ArrayList<AbstractCard> upgradableCards = new ArrayList<AbstractCard>();
        for (AbstractCard c : AbstractDungeon.player.masterDeck.group) {
            if (!c.canUpgrade()) continue;
            upgradableCards.add(c);
        }
        Collections.shuffle(upgradableCards);
        if (!upgradableCards.isEmpty()) {
            if (upgradableCards.size() == 1) {
                ((AbstractCard)upgradableCards.get(0)).upgrade();
                AbstractDungeon.effectList.add(new PurgeCardEffect(((AbstractCard)upgradableCards.get(0)).makeStatEquivalentCopy()));
            } else {
                ((AbstractCard)upgradableCards.get(0)).upgrade();
                ((AbstractCard)upgradableCards.get(1)).upgrade();
                AbstractDungeon.effectList.add(new PurgeCardEffect(((AbstractCard)upgradableCards.get(0)).makeStatEquivalentCopy()));
                AbstractDungeon.effectList.add(new PurgeCardEffect(((AbstractCard)upgradableCards.get(1)).makeStatEquivalentCopy()));
            }
        }
    }

    @Override
    public void render(SpriteBatch sb) {
        if (!this.lightGone) {
            sb.setColor(Color.WHITE);
            sb.draw(this.img, this.drawX - (float)this.img.getWidth() * Settings.scale / 2.0f, this.drawY, (float)this.img.getWidth() * Settings.scale, (float)this.img.getHeight() * Settings.scale, 0, 0, this.img.getWidth(), this.img.getHeight(), false, false);
        }
    }

    public void logMetric(String actionTaken) {
        AbstractEvent.logMetric(NAME, actionTaken);
    }
}

