/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.events.deprecated;

import com.badlogic.gdx.math.MathUtils;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.DamageInfo;
import com.megacrit.cardcrawl.cards.curses.Injury;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.events.AbstractEvent;
import com.megacrit.cardcrawl.events.AbstractImageEvent;
import com.megacrit.cardcrawl.events.GenericEventDialog;
import com.megacrit.cardcrawl.helpers.ScreenShake;
import com.megacrit.cardcrawl.localization.EventStrings;
import com.megacrit.cardcrawl.vfx.cardManip.PurgeCardEffect;
import com.megacrit.cardcrawl.vfx.cardManip.ShowCardAndObtainEffect;
import java.util.ArrayList;

public class OLDShimmeringPuddle
extends AbstractImageEvent {
    public static final String ID = "Thinking with Puddles";
    private static final EventStrings eventStrings = CardCrawlGame.languagePack.getEventString("Thinking with Puddles");
    public static final String NAME = OLDShimmeringPuddle.eventStrings.NAME;
    public static final String[] DESCRIPTIONS = OLDShimmeringPuddle.eventStrings.DESCRIPTIONS;
    public static final String[] OPTIONS = OLDShimmeringPuddle.eventStrings.OPTIONS;
    private static final String DIALOG_1 = DESCRIPTIONS[0];
    private static final String CARD_RESULT = DESCRIPTIONS[1];
    private static final String HURT_RESULT = DESCRIPTIONS[2];
    private CurScreen screen = CurScreen.INTRO;
    private int hpAmount = 0;
    private static final float HP_PERCENT = 0.1f;

    public OLDShimmeringPuddle() {
        super(NAME, DIALOG_1, "images/events/OLD/portal.png");
        this.hpAmount = (int)((float)AbstractDungeon.player.maxHealth * 0.1f);
        GenericEventDialog.setDialogOption(OPTIONS[0]);
        GenericEventDialog.setDialogOption(OPTIONS[1] + this.hpAmount + OPTIONS[2]);
    }

    @Override
    protected void buttonEffect(int buttonPressed) {
        switch (this.screen) {
            case INTRO: {
                if (buttonPressed == 0) {
                    ArrayList<AbstractCard> tmp = new ArrayList<AbstractCard>();
                    for (AbstractCard card : AbstractDungeon.player.masterDeck.group) {
                        if (card.rarity != AbstractCard.CardRarity.RARE || card.inBottleLightning || card.inBottleFlame) continue;
                        tmp.add(card);
                    }
                    AbstractCard c = (AbstractCard)tmp.get(MathUtils.random(tmp.size() - 1));
                    AbstractDungeon.player.masterDeck.removeCard(c);
                    AbstractDungeon.effectList.add(new PurgeCardEffect(c));
                    this.logMetric("Lose Rare Card");
                    GenericEventDialog.updateBodyText(CARD_RESULT);
                } else {
                    CardCrawlGame.screenShake.shake(ScreenShake.ShakeIntensity.HIGH, ScreenShake.ShakeDur.SHORT, true);
                    CardCrawlGame.sound.play("BLUNT_FAST");
                    AbstractDungeon.player.damage(new DamageInfo(null, this.hpAmount));
                    AbstractDungeon.effectList.add(new ShowCardAndObtainEffect(new Injury(), (float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT / 2.0f));
                    GenericEventDialog.updateBodyText(HURT_RESULT);
                    this.logMetric("Damage and Injury");
                }
                GenericEventDialog.clearAllDialogs();
                GenericEventDialog.setDialogOption(OPTIONS[3]);
                this.screen = CurScreen.RESULT;
                break;
            }
            default: {
                this.openMap();
            }
        }
    }

    public void logMetric(String actionTaken) {
        AbstractEvent.logMetric(ID, actionTaken);
    }

    private static enum CurScreen {
        INTRO,
        RESULT;

    }
}

