/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.events.deprecated;

import com.badlogic.gdx.math.MathUtils;
import com.megacrit.cardcrawl.cards.DamageInfo;
import com.megacrit.cardcrawl.cards.red.Clothesline;
import com.megacrit.cardcrawl.cards.red.Dropkick;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.events.AbstractEvent;
import com.megacrit.cardcrawl.events.AbstractImageEvent;
import com.megacrit.cardcrawl.events.GenericEventDialog;
import com.megacrit.cardcrawl.relics.ChampionsBelt;
import com.megacrit.cardcrawl.vfx.cardManip.ShowCardAndObtainEffect;

public class OLDRockmania
extends AbstractImageEvent {
    public static final String NAME = "Rockmania";
    private static final String DIALOG_1 = "You stumble upon a gathering of humanoid rock creatures that are paired up and wrestling for sport. NL Moving between pairs, the largest of the creatures seems to be teaching the others the fine art of wrestling. NL As you observe the students, the teacher turns and faces your direction. NL \"Welcome to the Rock Gym. Have you come to learn?\"";
    private static final String DIALOG_2 = "NL You spend hours training with Master Rock, learning his unique fighting style.";
    private static final String DIALOG_3 = "NL @VICTORY!@";
    private static final String DIALOG_4 = "NL @DEFEAT!@";
    private static final String DIALOG_5 = "NL The rocks ignore you completely and let you go on your way.";
    private static final float HP_LOSS = 0.15f;
    private int screenNum = 0;
    private int ACTUAL_RATE = 0;

    public OLDRockmania() {
        super(NAME, DIALOG_1, "images/events/rockBros.png");
        GenericEventDialog.setDialogOption("Teach Me Your Ways [Learn #yClothesline and #yDropkick]");
        GenericEventDialog.setDialogOption("Challenge to a Wrestling Match [ #b" + this.ACTUAL_RATE + "% chance of success ]");
        GenericEventDialog.setDialogOption("This is too weird for me. [ #bLeave ]");
    }

    @Override
    protected void buttonEffect(int buttonPressed) {
        block0 : switch (this.screenNum) {
            case 0: {
                switch (buttonPressed) {
                    case 0: {
                        this.logMetric("Learn", 0);
                        GenericEventDialog.updateBodyText(DIALOG_2);
                        this.learn();
                        this.screenNum = 1;
                        GenericEventDialog.updateDialogOption(0, "[ #bLeave ]");
                        GenericEventDialog.clearRemainingOptions();
                        break block0;
                    }
                    case 1: {
                        int random = MathUtils.random(0, 99);
                        if (random < this.ACTUAL_RATE) {
                            GenericEventDialog.updateBodyText(DIALOG_3);
                            AbstractDungeon.getCurrRoom().spawnRelicAndObtain(Settings.WIDTH / 2, Settings.HEIGHT / 2, new ChampionsBelt());
                            this.logMetric("Challenge", 0);
                            GenericEventDialog.updateDialogOption(0, "[ #bLeave ]");
                        } else {
                            int DAMAGE = Math.round((float)AbstractDungeon.player.currentHealth * 0.15f);
                            this.logMetric("Challenge", DAMAGE);
                            AbstractDungeon.player.damage(new DamageInfo(null, DAMAGE));
                            GenericEventDialog.updateBodyText(DIALOG_4);
                            GenericEventDialog.updateDialogOption(0, "Shamed and humiliated. [ #bLeave ]");
                        }
                        this.screenNum = 1;
                        GenericEventDialog.clearRemainingOptions();
                        break block0;
                    }
                }
                this.logMetric("Ignored", 0);
                GenericEventDialog.updateBodyText(DIALOG_5);
                this.screenNum = 2;
                GenericEventDialog.updateDialogOption(0, "[ #bLeave ]");
                GenericEventDialog.clearRemainingOptions();
                break;
            }
            case 1: {
                this.openMap();
                break;
            }
            default: {
                this.openMap();
            }
        }
    }

    protected void learn() {
        AbstractDungeon.effectList.add(new ShowCardAndObtainEffect(new Clothesline(), (float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT / 2.0f));
        AbstractDungeon.effectList.add(new ShowCardAndObtainEffect(new Dropkick(), (float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT / 2.0f));
    }

    public void logMetric(String actionTaken, int damageTaken) {
        AbstractEvent.logMetric(NAME, actionTaken, damageTaken);
    }
}

