/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.events.deprecated;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.MathUtils;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.events.AbstractEvent;
import com.megacrit.cardcrawl.events.RoomEventDialog;
import com.megacrit.cardcrawl.helpers.Hitbox;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.rooms.AbstractRoom;
import com.megacrit.cardcrawl.vfx.cardManip.PurgeCardEffect;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OLDPurifier
extends AbstractEvent {
    private static final Logger logger = LogManager.getLogger(OLDPurifier.class.getName());
    public static final String NAME = "Purifier";
    private boolean done = false;
    private Texture usedImg = ImageMaster.loadImage("images/npcs/skeletonCubeUsed.png");
    private int screenNum = 0;
    private static final String DIALOG_1 = "NL Before you lies an elaborate shrine to a forgotten spirit.";
    private static final String DIALOG_2 = "NL As you kneel in reverence, you feel a weight lifted off your shoulders.";
    private static final String IGNORE = "NL You ignore the shrine.";
    private float IMG_WIDTH = 512.0f * Settings.scale;
    private Texture imgShadow = ImageMaster.loadImage("images/npcs/octahedronShadow.png");
    private float animateY = 0.0f;
    private float wave = 0.0f;
    private static final float BOUNCE_LENGTH = 20.0f * Settings.scale;
    private static final float BOUNCE_SPEED = 3.0f;

    public OLDPurifier() {
        AbstractDungeon.getCurrRoom().phase = AbstractRoom.RoomPhase.COMPLETE;
        this.initializeImage("images/npcs/skeletonCube.png", (float)Settings.WIDTH * 0.45f, AbstractDungeon.floorY);
        this.hitbox = new Hitbox(this.drawX + this.IMG_WIDTH / 4.0f, this.drawY + this.IMG_WIDTH / 15.0f, this.IMG_WIDTH / 2.0f, this.IMG_WIDTH * 0.6f);
        this.bgmKey = "SHRINE";
        this.body = DIALOG_1;
        RoomEventDialog.addDialogOption("[Pray] #gRemove #ga #gcard #gfrom #gyour #gdeck.");
        RoomEventDialog.addDialogOption("[Leave]");
        this.hasDialog = true;
        this.hasFocus = true;
        AbstractDungeon.getCurrRoom().phase = AbstractRoom.RoomPhase.EVENT;
    }

    @Override
    public void onEnterRoom() {
        CardCrawlGame.music.playTempBGM("SHRINE");
    }

    @Override
    public void update() {
        super.update();
        if (!RoomEventDialog.waitForInput) {
            this.buttonEffect(RoomEventDialog.getSelectedOption());
        }
        if (!this.done) {
            this.animate();
        }
        if (!AbstractDungeon.isScreenUp && !AbstractDungeon.gridSelectScreen.selectedCards.isEmpty()) {
            CardCrawlGame.sound.play("CARD_EXHAUST");
            AbstractDungeon.topLevelEffects.add(new PurgeCardEffect(AbstractDungeon.gridSelectScreen.selectedCards.get(0), Settings.WIDTH / 2, Settings.HEIGHT / 2));
            AbstractDungeon.player.masterDeck.removeCard(AbstractDungeon.gridSelectScreen.selectedCards.get(0));
            AbstractDungeon.gridSelectScreen.selectedCards.clear();
        }
    }

    private void buttonEffect(int buttonPressed) {
        switch (this.screenNum) {
            case 0: {
                switch (buttonPressed) {
                    case 0: {
                        RoomEventDialog.updateBodyText(DIALOG_2);
                        this.use(1);
                        this.logMetric("One Purge");
                        break;
                    }
                    case 2: {
                        RoomEventDialog.updateBodyText(IGNORE);
                        this.logMetric("Ignored");
                    }
                }
                this.screenNum = 1;
                RoomEventDialog.updateDialogOption(0, "[Leave]");
                RoomEventDialog.clearRemainingOptions();
                break;
            }
            case 1: {
                this.openMap();
                break;
            }
            default: {
                logger.info("UNSPECIFIED SCREEN: " + this.screenNum);
            }
        }
    }

    private void animate() {
        this.wave += Gdx.graphics.getDeltaTime() * 3.0f;
        this.animateY = MathUtils.sin(this.wave) * BOUNCE_LENGTH;
    }

    public void use(int amount) {
        if (amount == 1) {
            AbstractDungeon.gridSelectScreen.open(AbstractDungeon.player.masterDeck, 1, "Select a cards to remove from your deck.", false, false, false, true);
        }
        this.img = this.usedImg;
        this.done = true;
    }

    @Override
    public void render(SpriteBatch sb) {
        sb.setColor(this.imgColor);
        sb.draw(this.imgShadow, this.drawX, this.drawY, this.imgWidth, this.imgHeight);
        sb.draw(this.img, this.drawX, this.drawY + this.animateY, this.imgWidth, this.imgHeight);
        this.hitbox.render(sb);
    }

    public void logMetric(String result) {
        AbstractEvent.logMetric(NAME, result);
    }
}

