/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.events.deprecated;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.megacrit.cardcrawl.cards.curses.Doubt;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.events.AbstractEvent;
import com.megacrit.cardcrawl.events.RoomEventDialog;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.unlock.UnlockTracker;
import com.megacrit.cardcrawl.vfx.RainingGoldEffect;
import com.megacrit.cardcrawl.vfx.cardManip.ShowCardAndObtainEffect;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OLDLiarGame
extends AbstractEvent {
    private static final Logger logger = LogManager.getLogger(OLDLiarGame.class.getName());
    public static final String NAME = "Liar Game";
    private Texture holeImg = ImageMaster.loadImage("images/npcs/holeInGround.png");
    private Texture monsterImg = ImageMaster.loadImage("images/npcs/holeInGroundMonster.png");
    private Texture monsterVomitImg = ImageMaster.loadImage("images/npcs/holeInGroundMonsterVomit.png");
    private boolean showMonster = false;
    private static final float DRAW_X = 1200.0f * Settings.scale;
    private static final float DRAW_Y = AbstractDungeon.floorY - 20.0f * Settings.scale;
    private static final String DIALOG_1 = "NL You walk into a room to find a large hole in the ground...";
    private static final String DIALOG_2 = "As you approach the hole, a strange serpent creature appears! NL     ~\"Ho~ ~hooo!~ ~Hello~ ~hello!~   ~...what~ ~have~ ~we~ ~got~ ~here...?\"~";
    private static final String DIALOG_3 = "Fellow adventurer, I ask a simple question. NL The most fulfilling of lives is that which you can #y~buy~ #y~anything!~ NL Do you agree?";
    private static final String AGREE_DIALOG = "~Yeeeeeeessssssssssessss.........!~ NL ~Thisss~ ~will~ ~all~ ~be~ ~worthhh~ ~it..~ NL ~..ssSSs.....~ ~ss...~ ~sssss....!~";
    private static final String DISAGREE_DIALOG = "The serpent stares at you with a look of extreme disappointment.";
    private static final String GOLD_RAIN_MSG = "The serpent rears its head and blasts a stream of gold upwards! NL It is amazing and terrifying simultaneously. NL You gather all the #ygold, thank the snake, and get going.";
    private int screenNum = 0;
    private static final int GOLD_REWARD = 125;
    private float vomitTimer = 0.0f;

    public OLDLiarGame() {
        this.body = DIALOG_1;
        RoomEventDialog.addDialogOption("[Investigate]");
        this.hasDialog = true;
        this.hasFocus = true;
    }

    @Override
    public void update() {
        super.update();
        this.vomitTimer -= Gdx.graphics.getDeltaTime();
        if (!RoomEventDialog.waitForInput) {
            this.buttonEffect(RoomEventDialog.getSelectedOption());
        }
    }

    private void buttonEffect(int buttonPressed) {
        switch (this.screenNum) {
            case 0: {
                RoomEventDialog.updateBodyText(DIALOG_2);
                RoomEventDialog.updateDialogOption(0, "[Continue]");
                ++this.screenNum;
                this.showMonster = true;
                break;
            }
            case 1: {
                RoomEventDialog.updateBodyText(DIALOG_3);
                RoomEventDialog.updateDialogOption(0, "[Agree] #gReceive #g125 #gGol. #rCurse #r- #rDoubt.");
                RoomEventDialog.addDialogOption("[Disagree]");
                ++this.screenNum;
                break;
            }
            case 2: {
                if (buttonPressed == 0) {
                    RoomEventDialog.updateBodyText(AGREE_DIALOG);
                    RoomEventDialog.removeDialogOption(1);
                    RoomEventDialog.updateDialogOption(0, "[Leave]");
                    this.screenNum = 3;
                    this.logMetric(true);
                    break;
                }
                RoomEventDialog.updateBodyText(DISAGREE_DIALOG);
                RoomEventDialog.removeDialogOption(1);
                RoomEventDialog.updateDialogOption(0, "[Leave]");
                this.screenNum = 4;
                this.logMetric(false);
                break;
            }
            case 3: {
                AbstractDungeon.effectList.add(new ShowCardAndObtainEffect(new Doubt(), (float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT / 2.0f));
                UnlockTracker.markCardAsSeen("Doubt");
                AbstractDungeon.effectList.add(new RainingGoldEffect(125));
                RoomEventDialog.updateBodyText(GOLD_RAIN_MSG);
                RoomEventDialog.updateDialogOption(0, "[Leave]");
                this.vomitTimer = 3.0f;
                this.screenNum = 4;
                break;
            }
            case 4: {
                this.openMap();
                break;
            }
            default: {
                logger.info("UNSPECIFIED SCREEN: " + this.screenNum);
            }
        }
    }

    public void logMetric(boolean agreed) {
        String actionTaken = "agreed";
        if (!agreed) {
            actionTaken = "disagreed";
        }
        AbstractEvent.logMetric(NAME, actionTaken);
    }

    @Override
    public void render(SpriteBatch sb) {
        sb.setColor(Color.WHITE);
        if (this.showMonster) {
            if (this.vomitTimer > 0.0f) {
                sb.draw(this.monsterVomitImg, DRAW_X, DRAW_Y, (float)this.monsterVomitImg.getWidth() * Settings.scale, (float)this.monsterVomitImg.getHeight() * Settings.scale);
            } else {
                sb.draw(this.monsterImg, DRAW_X, DRAW_Y, (float)this.monsterImg.getWidth() * Settings.scale, (float)this.monsterImg.getHeight() * Settings.scale);
            }
        } else {
            sb.draw(this.holeImg, DRAW_X, DRAW_Y, (float)this.holeImg.getWidth() * Settings.scale, (float)this.holeImg.getHeight() * Settings.scale);
        }
    }
}

