/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.events.deprecated;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.MathUtils;
import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.DamageInfo;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.events.AbstractEvent;
import com.megacrit.cardcrawl.events.RoomEventDialog;
import com.megacrit.cardcrawl.helpers.CardHelper;
import com.megacrit.cardcrawl.helpers.EffectHelper;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.vfx.ThoughtBubble;
import com.megacrit.cardcrawl.vfx.cardManip.PurgeCardEffect;
import com.megacrit.cardcrawl.vfx.combat.FlashAtkImgEffect;

public class OLDGoldenWing
extends AbstractEvent {
    public static final String NAME = "Golden Wing";
    private static final String DIALOG_1 = "You come across a crumbling geometrical statue resembling a wing. NL At some of the seams and dings you notice glints of #ygold. NL If you were strong enough, you could hack through the material and obtain some #ygold.";
    private static final String DIALOG_2 = "As you kneel before the Wing, you begin to ~feel~ ~...~ ~lightheaded...~ NL You wake up feeling a bit #rweaker, but strangely #bfocused.";
    private static final String DIALOG_3 = "You hack away at the statue with all your might. NL #yGold flies everywhere! NL You grab as much as you can and exit.";
    private static final String DIALOG_4 = "NL You walk right past the strange tribute. NL As you peak back behind your shoulder, you can't help but notice how ominous it was.";
    private int screenNum = 0;
    private int healthLoss = 0;
    private boolean canAttack;
    private boolean purgeResult = false;
    private static final int MIN_GOLD = 50;
    private static final int MAX_GOLD = 80;
    private static final int REQUIRED_DAMAGE = 10;
    private int goldAmount = MathUtils.random(50, 80);

    public OLDGoldenWing() {
        this.img = ImageMaster.loadImage("images/npcs/goldWing.png");
        this.drawX = (float)Settings.WIDTH * 0.75f;
        this.drawY = AbstractDungeon.floorY;
        this.body = DIALOG_1;
        this.canAttack = CardHelper.hasCardWithXDamage(10);
        this.healthLoss = 7;
        RoomEventDialog.addDialogOption("[Kneel] #gRemove #ga #gcard #gfrom #gyour #gdeck. #rLose #r" + this.healthLoss + " #rHP.");
        if (this.canAttack) {
            RoomEventDialog.addDialogOption("[Destroy] #gGain #g50 - #g80 #gGold.");
        } else {
            RoomEventDialog.addDialogOption("[Locked] Requires: Card with 10 or more damage ]", !this.canAttack);
        }
        RoomEventDialog.addDialogOption("[Leave]");
        this.hasDialog = true;
        this.hasFocus = true;
    }

    @Override
    public void update() {
        super.update();
        this.purgeLogic();
        if (!RoomEventDialog.waitForInput) {
            this.buttonEffect(RoomEventDialog.getSelectedOption());
        }
    }

    private void buttonEffect(int buttonPressed) {
        block0 : switch (this.screenNum) {
            case 0: {
                switch (buttonPressed) {
                    case 0: {
                        RoomEventDialog.updateBodyText(DIALOG_2);
                        AbstractDungeon.player.damage(new DamageInfo(AbstractDungeon.player, this.healthLoss, DamageInfo.DamageType.HP_LOSS));
                        AbstractDungeon.effectList.add(new FlashAtkImgEffect(AbstractDungeon.player.hb.cX, AbstractDungeon.player.hb.cY, AbstractGameAction.AttackEffect.BLUNT_HEAVY));
                        this.screenNum = 1;
                        RoomEventDialog.updateDialogOption(0, "[Continue]");
                        RoomEventDialog.removeDialogOption(1);
                        RoomEventDialog.removeDialogOption(1);
                        this.logMetric("Card Removal");
                        break block0;
                    }
                    case 1: {
                        if (this.canAttack) {
                            EffectHelper.gainGold(AbstractDungeon.player, this.drawX, this.drawY, this.goldAmount);
                            this.logMetric("Gained Gold");
                            RoomEventDialog.updateBodyText(DIALOG_3);
                            this.screenNum = 2;
                            RoomEventDialog.updateDialogOption(0, "[Leave]");
                            RoomEventDialog.removeDialogOption(1);
                            RoomEventDialog.removeDialogOption(1);
                            break block0;
                        }
                        AbstractDungeon.effectList.add(new ThoughtBubble(AbstractDungeon.player.dialogX, AbstractDungeon.player.dialogY, 3.0f, "I don't have a card with #b10+ Attack", true));
                        break block0;
                    }
                }
                RoomEventDialog.updateBodyText(DIALOG_4);
                this.logMetric("Ignored");
                this.screenNum = 3;
                RoomEventDialog.updateDialogOption(0, "[Leave]");
                RoomEventDialog.removeDialogOption(1);
                RoomEventDialog.removeDialogOption(1);
                break;
            }
            case 1: {
                AbstractDungeon.gridSelectScreen.open(AbstractDungeon.player.masterDeck, 1, "Select a card to remove from your deck.", false, false, false, true);
                RoomEventDialog.updateDialogOption(0, "[Leave]");
                this.purgeResult = true;
                this.screenNum = 3;
                break;
            }
            case 2: {
                this.openMap();
                break;
            }
            default: {
                this.openMap();
            }
        }
    }

    private void purgeLogic() {
        if (this.purgeResult && !AbstractDungeon.isScreenUp && !AbstractDungeon.gridSelectScreen.selectedCards.isEmpty()) {
            AbstractCard c = AbstractDungeon.gridSelectScreen.selectedCards.get(0);
            AbstractDungeon.topLevelEffects.add(new PurgeCardEffect(c, Settings.WIDTH / 2, Settings.HEIGHT / 2));
            AbstractDungeon.player.masterDeck.removeCard(c);
            AbstractDungeon.gridSelectScreen.selectedCards.clear();
            this.purgeResult = false;
        }
    }

    public void logMetric(String actionTaken) {
        AbstractEvent.logMetric(NAME, actionTaken);
    }

    @Override
    public void render(SpriteBatch sb) {
        sb.setColor(Color.WHITE);
        sb.draw(this.img, this.drawX - (float)this.img.getWidth() * Settings.scale / 2.0f, this.drawY, (float)this.img.getWidth() * Settings.scale, (float)this.img.getHeight() * Settings.scale, 0, 0, this.img.getWidth(), this.img.getHeight(), false, false);
    }
}

