/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.events.deprecated;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.MathUtils;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.CardGroup;
import com.megacrit.cardcrawl.cards.curses.Decay;
import com.megacrit.cardcrawl.cards.curses.Regret;
import com.megacrit.cardcrawl.cards.curses.Writhe;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.events.AbstractEvent;
import com.megacrit.cardcrawl.events.RoomEventDialog;
import com.megacrit.cardcrawl.helpers.InputHelper;
import com.megacrit.cardcrawl.localization.EventStrings;
import com.megacrit.cardcrawl.unlock.UnlockTracker;
import com.megacrit.cardcrawl.vfx.cardManip.ShowCardAndObtainEffect;

public class OLDDemonBallAndCup
extends AbstractEvent {
    public static final String ID = "Demon Dealer";
    private static final EventStrings eventStrings = CardCrawlGame.languagePack.getEventString("Demon Dealer");
    public static final String NAME = OLDDemonBallAndCup.eventStrings.NAME;
    public static final String[] DESCRIPTIONS = OLDDemonBallAndCup.eventStrings.DESCRIPTIONS;
    public static final String[] OPTIONS = OLDDemonBallAndCup.eventStrings.OPTIONS;
    private AbstractCard chosenCard = null;
    private CardGroup cards = new CardGroup(CardGroup.CardGroupType.UNSPECIFIED);
    private float[] timers;
    private boolean isAnimating = false;
    private boolean doneAnimating = false;
    private float animationTimer = 10.0f;
    private float waitTimer = 1.0f;
    private float cleanUpTimer = 0.5f;
    private boolean cleanedUp = false;
    private static final float MIN_STOP_TIME = 0.5f;
    private static final float MAX_STOP_TIME = 0.9f;
    private static final float MIN_X = (float)Settings.WIDTH * 0.15f;
    private static final float MAX_X = (float)Settings.WIDTH * 0.85f;
    private static final float MIN_Y = (float)Settings.HEIGHT * 0.25f;
    private static final float MAX_Y = (float)Settings.HEIGHT * 0.65f;
    private CUR_SCREEN screen = CUR_SCREEN.INTRO;
    private static final float SPACING_X = 300.0f * Settings.scale;

    public OLDDemonBallAndCup() {
        this.body = DESCRIPTIONS[4];
        RoomEventDialog.addDialogOption("");
        this.hasDialog = true;
        this.hasFocus = true;
    }

    private void shuffle() {
        for (int i = 0; i < this.timers.length; ++i) {
            int n = i;
            this.timers[n] = this.timers[n] - Gdx.graphics.getDeltaTime();
            if (!(this.timers[i] <= 0.0f)) continue;
            this.cards.group.get((int)i).target_x = MathUtils.random(MIN_X, MAX_X);
            this.cards.group.get((int)i).target_y = MathUtils.random(MIN_Y, MAX_Y);
            this.timers[i] = MathUtils.random(0.5f, 0.9f);
            if (this.overlaps(this.cards.group.get(i))) continue;
            this.reorderCard(i);
        }
    }

    private void moveToSlots() {
        for (int i = 0; i < this.cards.group.size(); ++i) {
            this.cards.group.get((int)i).target_x = this.cards.group.size() % 2 == 0 ? (float)Settings.WIDTH / 2.0f - SPACING_X / 2.0f - (float)(i - this.cards.group.size() / 2) * SPACING_X : (float)Settings.WIDTH / 2.0f - (float)(i - this.cards.group.size() / 2) * SPACING_X;
            this.cards.group.get((int)i).target_y = (float)Settings.HEIGHT / 2.0f;
        }
    }

    private boolean overlaps(AbstractCard card) {
        for (AbstractCard c : this.cards.group) {
            if (card.equals(c) || !card.hb.intersects(c.hb)) continue;
            return true;
        }
        return false;
    }

    private void reorderCard(int index) {
        int newIndex = MathUtils.random(0, this.cards.size() - 1);
        if (index == newIndex) {
            return;
        }
        AbstractCard c = this.cards.group.get(newIndex);
        this.cards.group.set(newIndex, this.cards.group.get(index));
        this.cards.group.set(index, c);
    }

    @Override
    public void update() {
        super.update();
        this.cards.update();
        if (this.screen == CUR_SCREEN.PICK) {
            this.cards.updateHoverLogic();
            for (AbstractCard c : this.cards.group) {
                if (!c.hb.hovered || !InputHelper.justClickedLeft) continue;
                this.revealCards();
                this.chosenCard = c;
                this.logMetric(c.cardID);
                c.isFlipped = false;
                AbstractDungeon.effectList.add(new ShowCardAndObtainEffect(c, c.current_x, c.current_y));
                if (c.type == AbstractCard.CardType.CURSE) {
                    this.screen = CUR_SCREEN.FAIL;
                    RoomEventDialog.updateBodyText("");
                    RoomEventDialog.addDialogOption(OPTIONS[1]);
                    continue;
                }
                if (c.color == AbstractCard.CardColor.COLORLESS) {
                    this.screen = CUR_SCREEN.SUCCESS;
                    RoomEventDialog.updateBodyText("");
                    RoomEventDialog.addDialogOption(OPTIONS[1]);
                    continue;
                }
                this.screen = CUR_SCREEN.SUCCESS;
                RoomEventDialog.updateBodyText("");
                RoomEventDialog.addDialogOption(OPTIONS[1]);
            }
        }
        if (this.chosenCard != null) {
            this.cleanUpTimer -= Gdx.graphics.getDeltaTime();
            if (this.cleanUpTimer < 0.0f && !this.cleanedUp) {
                this.cleanUp(this.chosenCard);
                this.cleanedUp = true;
            }
        }
        if (!RoomEventDialog.waitForInput) {
            this.buttonEffect(RoomEventDialog.getSelectedOption());
        }
        if (this.isAnimating) {
            for (AbstractCard c : this.cards.group) {
                c.targetDrawScale = 0.6f;
            }
            if (this.waitTimer > 0.0f) {
                this.waitTimer -= Gdx.graphics.getDeltaTime();
                return;
            }
            if (this.animationTimer > 0.0f) {
                this.animationTimer -= Gdx.graphics.getDeltaTime();
                this.shuffle();
                if (this.animationTimer < 0.0f) {
                    this.doneAnimating = true;
                    this.isAnimating = false;
                    this.moveToSlots();
                    this.waitTimer = 1.0f;
                }
            }
        } else if (this.doneAnimating && this.waitTimer > 0.0f) {
            this.waitTimer -= Gdx.graphics.getDeltaTime();
            if (this.waitTimer < 0.0f) {
                this.doneAnimating = false;
                this.screen = CUR_SCREEN.PICK;
                AbstractDungeon.dialog.show("");
            }
        }
    }

    private void revealCards() {
        for (AbstractCard c : this.cards.group) {
            c.isFlipped = false;
        }
    }

    private void cleanUp(AbstractCard card) {
        for (AbstractCard c : this.cards.group) {
            if (c.equals(this.chosenCard)) continue;
            c.target_y -= MathUtils.random((float)Settings.HEIGHT * 2.0f, (float)Settings.HEIGHT * 4.0f);
        }
    }

    private void buttonEffect(int buttonPressed) {
        switch (this.screen) {
            case INTRO: {
                switch (buttonPressed) {
                    case 0: {
                        RoomEventDialog.updateBodyText("");
                        RoomEventDialog.updateDialogOption(0, OPTIONS[2]);
                        this.screen = CUR_SCREEN.INTRO_2;
                        this.cards.addToTop(AbstractDungeon.returnColorlessCard(AbstractCard.CardRarity.UNCOMMON));
                        this.cards.addToTop(AbstractDungeon.returnColorlessCard(AbstractCard.CardRarity.RARE));
                        this.cards.addToTop(new Decay());
                        this.cards.addToTop(new Writhe());
                        this.cards.addToTop(new Regret());
                        UnlockTracker.markCardAsSeen("Decay");
                        UnlockTracker.markCardAsSeen("Writhe");
                        UnlockTracker.markCardAsSeen("Regret");
                        this.cards.shuffle();
                        for (AbstractCard c : this.cards.group) {
                            UnlockTracker.markCardAsSeen(c.cardID);
                        }
                        this.moveToSlots();
                    }
                }
                break;
            }
            case INTRO_2: {
                switch (buttonPressed) {
                    case 0: {
                        RoomEventDialog.removeDialogOption(0);
                        for (AbstractCard c : this.cards.group) {
                            c.isFlipped = true;
                        }
                        this.timers = new float[this.cards.size()];
                        for (int i = 0; i < this.timers.length; ++i) {
                            this.timers[i] = MathUtils.random(0.5f, 0.9f);
                        }
                        this.isAnimating = true;
                        AbstractDungeon.dialog.hide();
                    }
                }
                break;
            }
            case SUCCESS: {
                if (!this.cleanedUp) {
                    this.cleanUp(this.chosenCard);
                }
                this.openMap();
                break;
            }
            case FAIL: {
                if (!this.cleanedUp) {
                    this.cleanUp(this.chosenCard);
                }
                this.openMap();
                break;
            }
        }
    }

    @Override
    public void render(SpriteBatch sb) {
    }

    @Override
    public void renderAboveTopPanel(SpriteBatch sb) {
        if (this.chosenCard != null) {
            this.cards.renderExceptOneCard(sb, this.chosenCard);
        } else {
            this.cards.render(sb);
        }
    }

    public void logMetric(String result) {
        AbstractEvent.logMetric(NAME, result);
    }

    private static enum CUR_SCREEN {
        INTRO,
        INTRO_2,
        PICK,
        FAIL,
        SUCCESS;

    }
}

