/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.desktop;

import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.backends.lwjgl.LwjglApplication;
import com.badlogic.gdx.backends.lwjgl.LwjglApplicationConfiguration;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.ExceptionHandler;
import com.megacrit.cardcrawl.core.Settings;
import io.sentry.Sentry;
import io.sentry.SentryClient;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Scanner;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DesktopLauncher {
    private static final Logger logger;
    private static final String DISPLAY_CONFIG_LOC = "info.displayconfig";
    private static final int DEFAULT_W = 1280;
    private static final int DEFAULT_H = 720;
    private static final String DEFAULT_FS = "false";
    private static final String DEFAULT_WFS = "false";
    private static final String DEFAULT_VSYNC = "true";
    private static ArrayList<String> displayConfigFile;

    public static void main(String[] arg) throws FileNotFoundException {
        SentryClient client = Sentry.init();
        client.addTag("player", CardCrawlGame.playerName);
        client.addTag("server_name", "redacted");
        client.addTag("isBeta", String.valueOf(Settings.isBeta));
        client.addTag("isDemo", String.valueOf(Settings.isDemo));
        client.addTag("isPublisherBuild", String.valueOf(Settings.isPublisherBuild));
        client.setRelease("[EARLY_ACCESS_004] (11-24-2017)");
        try {
            LwjglApplicationConfiguration config = new LwjglApplicationConfiguration();
            config.addIcon("images/ui/icon.png", Files.FileType.Internal);
            config.resizable = false;
            config.title = "Slay the Spire";
            DesktopLauncher.loadSettings(config);
            config.foregroundFPS = 0;
            config.backgroundFPS = 0;
            new LwjglApplication((ApplicationListener)new CardCrawlGame(config.preferencesDirectory), config);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, logger);
            Gdx.app.exit();
        }
    }

    private static void loadSettings(LwjglApplicationConfiguration config) throws FileNotFoundException {
        Scanner s = null;
        try {
            s = new Scanner(new File(DISPLAY_CONFIG_LOC));
            while (s.hasNextLine()) {
                displayConfigFile.add(s.nextLine());
            }
            if (displayConfigFile.size() < 4) {
                DesktopLauncher.createNewConfig(config);
            } else if (displayConfigFile.size() == 4) {
                DesktopLauncher.appendFpsUnlock(config);
            }
        }
        catch (FileNotFoundException e) {
            DesktopLauncher.createNewConfig(config);
            return;
        }
        s.close();
        s = new Scanner(new File(DISPLAY_CONFIG_LOC));
        config.width = Integer.valueOf(s.nextLine());
        config.height = Integer.valueOf(s.nextLine());
        if (Boolean.valueOf(s.nextLine()).booleanValue()) {
            System.setProperty("org.lwjgl.opengl.Window.undecorated", "false");
            config.fullscreen = true;
            config.width = LwjglApplicationConfiguration.getDesktopDisplayMode().width;
            config.height = LwjglApplicationConfiguration.getDesktopDisplayMode().height;
        } else {
            config.fullscreen = false;
            if (s.hasNextLine() && Boolean.valueOf(s.nextLine()).booleanValue()) {
                System.setProperty("org.lwjgl.opengl.Window.undecorated", DEFAULT_VSYNC);
                config.width = LwjglApplicationConfiguration.getDesktopDisplayMode().width;
                config.height = LwjglApplicationConfiguration.getDesktopDisplayMode().height;
            }
        }
        config.vSyncEnabled = Boolean.valueOf(s.nextLine());
        s.close();
    }

    private static void createNewConfig(LwjglApplicationConfiguration config) throws FileNotFoundException {
        logger.info("Creating new config...");
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(DISPLAY_CONFIG_LOC, "UTF-8");
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        writer.println(1280);
        writer.println(720);
        writer.println("false");
        writer.println("false");
        writer.println(DEFAULT_VSYNC);
        writer.close();
        DesktopLauncher.loadSettings(config);
    }

    private static void appendFpsUnlock(LwjglApplicationConfiguration config) throws FileNotFoundException {
        logger.info("Updating config...");
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(DISPLAY_CONFIG_LOC, "UTF-8");
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        writer.println(displayConfigFile.get(0));
        writer.println(displayConfigFile.get(1));
        writer.println(displayConfigFile.get(2));
        writer.println(displayConfigFile.get(3));
        writer.println(DEFAULT_VSYNC);
        writer.close();
        DesktopLauncher.loadSettings(config);
    }

    static {
        System.setProperty("log4j.configurationFile", "log4j2.xml");
        logger = LogManager.getLogger(DesktopLauncher.class.getName());
        displayConfigFile = new ArrayList();
    }
}

