/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.daily;

import com.megacrit.cardcrawl.daily.TimeHelper;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.net.ntp.NTPUDPClient;
import org.apache.commons.net.ntp.NtpV3Packet;
import org.apache.commons.net.ntp.TimeInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TimeLookup
implements Runnable {
    private static final Logger logger = LogManager.getLogger(TimeLookup.class.getName());
    private static volatile ArrayList<String> servers = new ArrayList();
    public static volatile int index = 0;
    public static volatile boolean isDone = false;

    public TimeLookup() {
        servers.add("nist-time-server.eoni.com");
        servers.add("nist.netservicesgroup.com");
        servers.add("time-a.nist.gov");
        servers.add("time-a.timefreq.bldrdoc.gov");
        servers.add("time-b.nist.gov");
        servers.add("time-b.timefreq.bldrdoc.gov");
        servers.add("time-c.nist.gov");
        servers.add("time-c.timefreq.bldrdoc.gov");
        servers.add("time-d.nist.gov");
        servers.add("time.nist.gov");
        servers.add("utcnist.colorado.edu");
        Collections.shuffle(servers);
    }

    public static long getNTPTime() {
        NTPUDPClient timeClient = new NTPUDPClient();
        InetAddress inetAddress = null;
        try {
            logger.info("Trying server " + index + "... " + servers.get(index));
            inetAddress = InetAddress.getByName(servers.get(index));
            ++index;
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        TimeInfo timeInfo = null;
        try {
            timeInfo = timeClient.getTime(inetAddress);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        NtpV3Packet message = timeInfo.getMessage();
        long serverTime = message.getTransmitTimeStamp().getTime();
        logger.info("NTP TIME (ms): " + serverTime);
        return serverTime;
    }

    public static void getEpochDays() {
        TimeHelper.setTime(TimeLookup.getNTPTime());
    }

    @Override
    public void run() {
        logger.info("Attempting to ping time server");
        if (!isDone) {
            TimeLookup.getEpochDays();
        }
    }
}

