/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.daily;

import com.badlogic.gdx.Gdx;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TimeHelper {
    private static final Logger logger = LogManager.getLogger(TimeHelper.class.getName());
    public static boolean isTimeSet = false;
    public static long startTimeNs;
    public static long startTimeMs;
    public static long currentTimeMs;
    public static long daySince1970;
    public static long endTimeMs;
    private static final float UPDATE_FREQ = -1.0f;
    private static float updateTimer;
    private static DateFormat format;

    public static void setTime(long ntpTime) {
        if (!isTimeSet) {
            startTimeMs = ntpTime;
            daySince1970 = startTimeMs / 1000L / 86400L;
            logger.info("Today is: " + daySince1970);
            endTimeMs = (daySince1970 + 1L) * 86400000L;
            logger.info("Day was set!");
            isTimeSet = true;
            startTimeNs = System.nanoTime();
            format.setTimeZone(TimeZone.getTimeZone("Etc/UTC"));
        }
    }

    public static void update() {
        if (isTimeSet && (updateTimer -= Gdx.graphics.getDeltaTime()) < 0.0f) {
            updateTimer = -1.0f;
            currentTimeMs = startTimeMs - (startTimeNs - System.nanoTime()) / 1000000L;
        }
    }

    public static String getTodayDate() {
        return format.format(new Date(currentTimeMs));
    }

    public static String getTimeLeft() {
        if (endTimeMs - currentTimeMs < 0L) {
            endTimeMs += 86400000L;
            ++daySince1970;
        }
        long tmp = (endTimeMs - currentTimeMs) / 1000L;
        long hours = tmp / 3600L;
        long minutes = (tmp %= 3600L) / 60L;
        tmp %= 60L;
        if (hours != 0L) {
            return hours + "h " + minutes + "m " + tmp + "s";
        }
        return minutes + "m " + tmp + "s";
    }

    static {
        updateTimer = -1.0f;
        format = new SimpleDateFormat("MMMM dd, yyyy");
    }
}

