/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.characters;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Bezier;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.megacrit.cardcrawl.actions.GameActionManager;
import com.megacrit.cardcrawl.actions.utility.UseCardAction;
import com.megacrit.cardcrawl.actions.utility.WaitAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.CardGroup;
import com.megacrit.cardcrawl.cards.CardQueueItem;
import com.megacrit.cardcrawl.cards.DamageInfo;
import com.megacrit.cardcrawl.characters.Crowbot;
import com.megacrit.cardcrawl.characters.Ironclad;
import com.megacrit.cardcrawl.characters.TheSilent;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.EnergyManager;
import com.megacrit.cardcrawl.core.GameCursor;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.CardLibrary;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.Hitbox;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.helpers.InputHelper;
import com.megacrit.cardcrawl.helpers.MathHelper;
import com.megacrit.cardcrawl.helpers.RelicLibrary;
import com.megacrit.cardcrawl.helpers.ShaderHelper;
import com.megacrit.cardcrawl.helpers.TipTracker;
import com.megacrit.cardcrawl.localization.TutorialStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;
import com.megacrit.cardcrawl.potions.AbstractPotion;
import com.megacrit.cardcrawl.potions.PotionPlaceholder;
import com.megacrit.cardcrawl.powers.AbstractPower;
import com.megacrit.cardcrawl.relics.AbstractRelic;
import com.megacrit.cardcrawl.relics.BottledFlame;
import com.megacrit.cardcrawl.relics.BottledLightning;
import com.megacrit.cardcrawl.relics.LizardTail;
import com.megacrit.cardcrawl.rooms.AbstractRoom;
import com.megacrit.cardcrawl.rooms.CampfireUI;
import com.megacrit.cardcrawl.rooms.MonsterRoom;
import com.megacrit.cardcrawl.rooms.RestRoom;
import com.megacrit.cardcrawl.rooms.ShopRoom;
import com.megacrit.cardcrawl.screens.CharSelectInfo;
import com.megacrit.cardcrawl.screens.DeathScreen;
import com.megacrit.cardcrawl.ui.FtueTip;
import com.megacrit.cardcrawl.ui.MultiPageFtue;
import com.megacrit.cardcrawl.ui.panels.EnergyPanel;
import com.megacrit.cardcrawl.vfx.BorderFlashEffect;
import com.megacrit.cardcrawl.vfx.ThoughtBubble;
import com.megacrit.cardcrawl.vfx.cardManip.PurgeCardEffect;
import com.megacrit.cardcrawl.vfx.combat.BlockedWordEffect;
import com.megacrit.cardcrawl.vfx.combat.HbBlockBrokenEffect;
import com.megacrit.cardcrawl.vfx.combat.StrikeEffect;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractPlayer
extends AbstractCreature {
    private static final Logger logger = LogManager.getLogger(AbstractPlayer.class.getName());
    private static final TutorialStrings tutorialStrings = CardCrawlGame.languagePack.getTutorialString("Player Tips");
    public static final String[] MSG = AbstractPlayer.tutorialStrings.TEXT;
    public static final String[] LABEL = AbstractPlayer.tutorialStrings.LABEL;
    public PlayerClass chosenClass;
    public int gameHandSize;
    public int masterHandSize;
    public CardGroup masterDeck = new CardGroup(CardGroup.CardGroupType.MASTER_DECK);
    public CardGroup drawPile = new CardGroup(CardGroup.CardGroupType.DRAW_PILE);
    public CardGroup hand = new CardGroup(CardGroup.CardGroupType.HAND);
    public CardGroup discardPile = new CardGroup(CardGroup.CardGroupType.DISCARD_PILE);
    public CardGroup exhaustPile = new CardGroup(CardGroup.CardGroupType.EXHAUST_PILE);
    public CardGroup limbo = new CardGroup(CardGroup.CardGroupType.UNSPECIFIED);
    public ArrayList<AbstractRelic> relics = new ArrayList();
    public AbstractPotion[] potions = new AbstractPotion[3];
    public EnergyManager energy;
    public boolean isEndingTurn = false;
    public int charge = 0;
    public static int poisonKillCount = 0;
    public int damagedThisCombat = 0;
    public int cardsPlayedThisTurn = 0;
    private boolean isHoveringCard = false;
    public boolean isHoveringDropZone = false;
    private float hoverTimer = 0.0f;
    private float hoverStartLine = 0.0f;
    private boolean passedHesitationLine = false;
    public AbstractCard hoveredCard = null;
    public AbstractCard toHover = null;
    public AbstractCard cardInUse = null;
    public boolean isDraggingCard = false;
    private boolean isUsingClickDragControl = false;
    private float clickDragTimer = 0.0f;
    public boolean inSingleTargetMode = false;
    private AbstractMonster hoveredMonster = null;
    public float hoverEnemyWaitTimer = 0.0f;
    private static final float HOVER_ENEMY_WAIT_TIME = 1.0f;
    public Texture img;
    public Texture shoulderImg;
    public Texture shoulder2Img;
    public Texture corpseImg;
    private static final Color ARROW_COLOR = new Color(1.0f, 0.2f, 0.3f, 1.0f);
    private float arrowScale;
    private float arrowScaleTimer = 0.0f;
    private float arrowX;
    private float arrowY;
    private static final float ARROW_TARGET_SCALE = 1.2f;
    private static final int TARGET_ARROW_W = 256;
    public boolean drawDisabledUI = false;
    public static final float HOVER_CARD_Y_POSITION = 210.0f * Settings.scale;
    public boolean endTurnQueued = false;
    private static final int SEGMENTS = 20;
    private Vector2[] points = new Vector2[20];
    private Vector2 controlPoint;
    private boolean renderCorpse = false;

    public AbstractPlayer(String name, PlayerClass setClass) {
        this.name = name;
        this.title = AbstractPlayer.getTitle(setClass);
        this.drawX = (float)Settings.WIDTH * 0.25f;
        this.drawY = AbstractDungeon.floorY;
        this.chosenClass = setClass;
        this.isPlayer = true;
        this.initializeStarterDeck();
        this.initializeStarterRelics(setClass);
        AbstractDungeon.playtimeStart = System.currentTimeMillis() / 1000L;
        this.potions[0] = new PotionPlaceholder(0);
        this.potions[1] = new PotionPlaceholder(1);
        this.potions[2] = new PotionPlaceholder(2);
        for (int i = 0; i < this.points.length; ++i) {
            this.points[i] = new Vector2();
        }
    }

    public static String getTitle(PlayerClass plyrClass) {
        switch (plyrClass) {
            case IRONCLAD: {
                return "the Ironclad";
            }
            case THE_SILENT: {
                return "the Silent";
            }
            case CROWBOT: {
                return "the Crowbot";
            }
        }
        return "NOT SET, getTitle()";
    }

    public void adjustPotionPositions() {
        for (int i = 0; i < this.potions.length; ++i) {
            this.potions[i].adjustPosition(i);
        }
    }

    public int potionCount() {
        int count = 3;
        for (AbstractPotion p : this.potions) {
            if (!(p instanceof PotionPlaceholder)) continue;
            --count;
        }
        return count;
    }

    protected void initializeClass(String imgUrl, String shoulder2ImgUrl, String shouldImgUrl, String corpseImgUrl, CharSelectInfo info, float hb_x, float hb_y, float hb_w, float hb_h, EnergyManager energy) {
        this.img = ImageMaster.loadImage(imgUrl);
        if (this.img != null) {
            this.atlas = null;
        }
        this.shoulderImg = ImageMaster.loadImage(shouldImgUrl);
        this.shoulder2Img = ImageMaster.loadImage(shoulder2ImgUrl);
        this.corpseImg = ImageMaster.loadImage(corpseImgUrl);
        this.maxHealth = info.maxHp;
        this.currentHealth = info.currentHp;
        this.energy = energy;
        this.gameHandSize = this.masterHandSize = info.cardDraw;
        this.displayGold = this.gold = info.gold;
        this.hb_h = hb_h * Settings.scale;
        this.hb_w = hb_w * Settings.scale;
        this.hb_x = hb_x * Settings.scale;
        this.hb_y = hb_y * Settings.scale;
        this.hb = new Hitbox(this.hb_w, this.hb_h);
        this.healthHb = new Hitbox(this.hb.width, 72.0f * Settings.scale);
        this.refreshHitboxLocation();
    }

    protected void initializeStarterDeck() {
        ArrayList<String> cards = null;
        switch (this.chosenClass) {
            case IRONCLAD: {
                cards = Ironclad.getStartingDeck();
                break;
            }
            case THE_SILENT: {
                cards = TheSilent.getStartingDeck();
                break;
            }
            case CROWBOT: {
                cards = Crowbot.getStartingDeck();
            }
        }
        for (String s : cards) {
            this.masterDeck.addToTop(CardLibrary.getCard(this.chosenClass, s).makeCopy());
        }
    }

    protected void initializeStarterRelics(PlayerClass chosenClass) {
        ArrayList<String> relics = null;
        switch (chosenClass) {
            case IRONCLAD: {
                relics = Ironclad.getStartingRelics();
                break;
            }
            case THE_SILENT: {
                relics = TheSilent.getStartingRelics();
                break;
            }
            case CROWBOT: {
                relics = Crowbot.getStartingRelics();
            }
        }
        int index = 0;
        for (String s : relics) {
            if (s.equals("Philosopher's Stone") || s.equals("Velvet Choker") || s.equals("Sozu") || s.equals("Gremlin Horn") || s.equals("Cursed Key") || s.equals("Lantern")) {
                RelicLibrary.getRelic(s).makeCopy(chosenClass).instantObtain(this, index, false);
            } else {
                RelicLibrary.getRelic(s).makeCopy().instantObtain(this, index, false);
            }
            ++index;
        }
        AbstractDungeon.relicsToRemoveOnStart.addAll(relics);
    }

    public void combatUpdate() {
        if (this.cardInUse != null) {
            this.cardInUse.update();
        }
        this.limbo.update();
        this.exhaustPile.update();
        for (AbstractPower p : this.powers) {
            p.updateParticles();
        }
    }

    public void update() {
        this.hb.update();
        this.updateHealthBar();
        this.updatePowers();
        this.healthHb.update();
        this.updateReticle();
        this.tint.update();
    }

    @Override
    public void loseGold(int goldAmount) {
        if (!(AbstractDungeon.getCurrRoom() instanceof ShopRoom) && AbstractDungeon.getCurrRoom().phase != AbstractRoom.RoomPhase.COMBAT) {
            CardCrawlGame.sound.play("EVENT_PURCHASE");
        }
        if (goldAmount > 0) {
            this.gold -= goldAmount;
            if (this.gold < 0) {
                this.gold = 0;
            }
            for (AbstractRelic r : this.relics) {
                r.onLoseGold();
            }
        } else {
            logger.info("NEGATIVE MONEY???");
        }
    }

    @Override
    public void gainGold(int amount) {
        if (this.hasRelic("Ectoplasm")) {
            this.getRelic("Ectoplasm").flash();
            return;
        }
        if (amount <= 0) {
            logger.info("NEGATIVE MONEY???");
        } else {
            this.gold += amount;
            for (AbstractRelic r : this.relics) {
                r.onGainGold();
            }
        }
    }

    public void playDeathAnimation() {
        this.img = this.corpseImg;
        this.renderCorpse = true;
    }

    public boolean isCursed() {
        boolean cursed = false;
        for (AbstractCard c : this.masterDeck.group) {
            if (c.type != AbstractCard.CardType.CURSE) continue;
            cursed = true;
        }
        return cursed;
    }

    public void updateInput() {
        if (this.hoverEnemyWaitTimer > 0.0f) {
            this.hoverEnemyWaitTimer -= Gdx.graphics.getDeltaTime();
        }
        if (!this.inSingleTargetMode) {
            int y = InputHelper.mY;
            boolean hMonster = false;
            for (AbstractMonster m : AbstractDungeon.getCurrRoom().monsters.monsters) {
                m.hb.update();
                if (!m.hb.hovered || m.isDying || m.isEscaping || m.currentHealth <= 0) continue;
                hMonster = true;
                break;
            }
            boolean tmp = this.isHoveringDropZone;
            boolean bl = this.isHoveringDropZone = ((float)y > this.hoverStartLine || (float)y > 300.0f * Settings.scale) && (float)y < Settings.CARD_DROP_END_Y || hMonster;
            if (!tmp && this.isHoveringDropZone && this.isDraggingCard) {
                this.hoveredCard.flash(Color.SKY.cpy());
            }
            if (this.isDraggingCard && this.isHoveringDropZone && this.hoveredCard != null) {
                this.passedHesitationLine = true;
            }
            if (this.isDraggingCard && ((float)y < this.hoverStartLine - 100.0f * Settings.scale || (float)y < 50.0f * Settings.scale) && this.passedHesitationLine) {
                this.releaseCard();
                CardCrawlGame.sound.play("UI_CLICK_1");
            }
            if (this.hoveredCard == null && AbstractDungeon.screen == AbstractDungeon.CurrentScreen.NONE) {
                this.isHoveringCard = false;
                if (this.toHover != null) {
                    this.hoveredCard = this.toHover;
                    this.toHover = null;
                } else {
                    this.hoveredCard = this.hand.getHoveredCard();
                }
                if (this.hoveredCard != null) {
                    this.isHoveringCard = true;
                    this.hoveredCard.current_y = HOVER_CARD_Y_POSITION;
                    this.hoveredCard.target_y = HOVER_CARD_Y_POSITION;
                    this.hoveredCard.setAngle(0.0f, true);
                    this.hand.hoverCardPush(this.hoveredCard);
                }
            }
            if (this.hoveredCard != null) {
                this.hoveredCard.drawScale = 1.0f;
                this.hoveredCard.targetDrawScale = 1.0f;
            }
            if (!this.isDraggingCard && this.hasRelic("Necronomicon")) {
                this.getRelic("Necronomicon").stopPulse();
            }
            if (!this.endTurnQueued) {
                if (!AbstractDungeon.actionManager.turnHasEnded && this.clickAndDragCards()) {
                    return;
                }
                if (this.isHoveringCard && this.hoveredCard != null && !this.hoveredCard.isHoveredInHand(1.0f)) {
                    for (int i = 0; i < this.hand.group.size(); ++i) {
                        if (this.hand.group.get(i) != this.hoveredCard || i == 0 || !this.hand.group.get(i - 1).isHoveredInHand(1.0f)) continue;
                        this.toHover = this.hand.group.get(i - 1);
                        break;
                    }
                    this.releaseCard();
                }
                if (this.hoveredCard != null) {
                    this.hoveredCard.updateHoverLogic();
                }
            } else if (AbstractDungeon.actionManager.cardQueue.isEmpty() && !AbstractDungeon.actionManager.hasControl) {
                this.endTurnQueued = false;
                this.isEndingTurn = true;
            }
        } else {
            this.hoveredMonster = null;
            for (AbstractMonster m : AbstractDungeon.getCurrRoom().monsters.monsters) {
                m.hb.update();
                if (!m.hb.hovered || m.isDying || m.isEscaping || m.currentHealth <= 0) continue;
                this.hoveredMonster = m;
                break;
            }
            if (AbstractDungeon.getCurrRoom().monsters.areMonstersBasicallyDead() || InputHelper.justClickedRight || (float)InputHelper.mY < this.hoverStartLine - 100.0f * Settings.scale || (float)InputHelper.mY < 50.0f * Settings.scale) {
                this.releaseCard();
                CardCrawlGame.sound.play("UI_CLICK_2");
                this.isUsingClickDragControl = false;
                this.inSingleTargetMode = false;
                GameCursor.hidden = false;
                this.hoveredMonster = null;
                return;
            }
            if (InputHelper.justClickedLeft) {
                InputHelper.justClickedLeft = false;
                if (this.hoveredMonster == null) {
                    CardCrawlGame.sound.play("UI_CLICK_1");
                    return;
                }
                if (this.hoveredCard.canUse(this, this.hoveredMonster)) {
                    this.playCard();
                } else {
                    AbstractDungeon.effectList.add(new ThoughtBubble(this.dialogX, this.dialogY, 3.0f, this.hoveredCard.cantUseMessage, true));
                    this.energyTip(this.hoveredCard);
                    this.releaseCard();
                }
                this.isUsingClickDragControl = false;
                this.inSingleTargetMode = false;
                GameCursor.hidden = false;
                this.hoveredMonster = null;
                return;
            }
            if (!this.isUsingClickDragControl && InputHelper.justReleasedClickLeft && this.hoveredMonster != null) {
                if (this.hoveredCard.canUse(this, this.hoveredMonster)) {
                    this.playCard();
                } else {
                    AbstractDungeon.effectList.add(new ThoughtBubble(this.dialogX, this.dialogY, 3.0f, this.hoveredCard.cantUseMessage, true));
                    this.energyTip(this.hoveredCard);
                    this.releaseCard();
                }
                this.inSingleTargetMode = false;
                GameCursor.hidden = false;
                this.hoveredMonster = null;
                return;
            }
        }
    }

    private void energyTip(AbstractCard cardToCheck) {
        int availableEnergy;
        switch (AbstractDungeon.player.chosenClass) {
            case IRONCLAD: {
                availableEnergy = EnergyPanel.redCount;
                break;
            }
            case THE_SILENT: {
                availableEnergy = EnergyPanel.greenCount;
                break;
            }
            case CROWBOT: {
                availableEnergy = EnergyPanel.blueCount;
                break;
            }
            default: {
                availableEnergy = EnergyPanel.redCount;
            }
        }
        if (cardToCheck.cost > availableEnergy && !TipTracker.tips.get("ENERGY_USE_TIP").booleanValue() && ++TipTracker.energyUseCounter >= 2) {
            AbstractDungeon.ftue = new FtueTip(LABEL[1], MSG[1], 330.0f * Settings.scale, 400.0f * Settings.scale, FtueTip.TipType.ENERGY);
            TipTracker.neverShowAgain("ENERGY_USE_TIP");
        }
    }

    private boolean clickAndDragCards() {
        if (InputHelper.justClickedLeft && this.isHoveringCard && !this.isDraggingCard) {
            this.hoverStartLine = (float)InputHelper.mY + 140.0f * Settings.scale;
            InputHelper.justClickedLeft = false;
            if (this.hoveredCard != null) {
                CardCrawlGame.sound.play("CARD_OBTAIN");
                this.isDraggingCard = true;
                this.passedHesitationLine = false;
                this.hoveredCard.targetDrawScale = 0.7f;
                return true;
            }
        }
        this.clickDragTimer = InputHelper.isMouseDown ? (this.clickDragTimer += Gdx.graphics.getDeltaTime()) : 0.0f;
        if (InputHelper.justClickedLeft && this.isUsingClickDragControl) {
            if (InputHelper.justClickedRight) {
                CardCrawlGame.sound.play("UI_CLICK_2");
                this.releaseCard();
                return true;
            }
            InputHelper.justClickedLeft = false;
            if (this.isHoveringDropZone && this.hoveredCard.canUse(this, null)) {
                this.playCard();
            } else {
                CardCrawlGame.sound.play("CARD_OBTAIN");
                this.releaseCard();
            }
            this.isUsingClickDragControl = false;
            return true;
        }
        if (this.isDraggingCard && (InputHelper.isMouseDown || this.isUsingClickDragControl)) {
            if (InputHelper.justClickedRight) {
                CardCrawlGame.sound.play("UI_CLICK_2");
                this.releaseCard();
                return true;
            }
            this.hoveredCard.target_x = InputHelper.mX;
            this.hoveredCard.target_y = InputHelper.mY;
            if (!this.hoveredCard.hasEnoughEnergy() && this.isHoveringDropZone) {
                AbstractDungeon.effectList.add(new ThoughtBubble(this.dialogX, this.dialogY, 3.0f, this.hoveredCard.cantUseMessage, true));
                this.energyTip(this.hoveredCard);
                this.releaseCard();
                CardCrawlGame.sound.play("CARD_REJECT");
                return true;
            }
            if (this.isHoveringDropZone && (this.hoveredCard.target == AbstractCard.CardTarget.ENEMY || this.hoveredCard.target == AbstractCard.CardTarget.SELF_AND_ENEMY)) {
                this.inSingleTargetMode = true;
                this.arrowX = InputHelper.mX;
                this.arrowY = InputHelper.mY;
                GameCursor.hidden = true;
                this.hoveredCard.untip();
                this.hand.refreshHandLayout();
                this.hoveredCard.target_y = AbstractCard.IMG_HEIGHT * 0.75f / 2.5f;
                this.hoveredCard.target_x = (float)Settings.WIDTH / 2.0f;
                this.isDraggingCard = false;
            }
            return true;
        }
        if (this.isDraggingCard && InputHelper.justReleasedClickLeft) {
            if (this.isHoveringDropZone) {
                if (this.hoveredCard.target == AbstractCard.CardTarget.ENEMY || this.hoveredCard.target == AbstractCard.CardTarget.SELF_AND_ENEMY) {
                    this.inSingleTargetMode = true;
                    this.arrowX = InputHelper.mX;
                    this.arrowY = InputHelper.mY;
                    GameCursor.hidden = true;
                    this.hoveredCard.untip();
                    this.hand.refreshHandLayout();
                    this.hoveredCard.target_y = AbstractCard.IMG_HEIGHT * 0.75f / 2.5f;
                    this.hoveredCard.target_x = (float)Settings.WIDTH / 2.0f;
                    this.isDraggingCard = false;
                    return true;
                }
                if (this.hoveredCard.canUse(this, null)) {
                    this.playCard();
                    return true;
                }
                AbstractDungeon.effectList.add(new ThoughtBubble(this.dialogX, this.dialogY, 3.0f, this.hoveredCard.cantUseMessage, true));
                this.energyTip(this.hoveredCard);
                this.releaseCard();
                return true;
            }
            if (this.clickDragTimer < 0.4f) {
                this.isUsingClickDragControl = true;
                return true;
            }
            if (AbstractDungeon.actionManager.currentAction == null) {
                this.releaseCard();
                logger.info("DERP?");
                CardCrawlGame.sound.play("CARD_OBTAIN");
                return true;
            }
        }
        return false;
    }

    private void playCard() {
        InputHelper.justClickedLeft = false;
        this.hoverEnemyWaitTimer = 1.0f;
        this.hoveredCard.unhover();
        if (this.hoveredCard.target == AbstractCard.CardTarget.ENEMY || this.hoveredCard.target == AbstractCard.CardTarget.SELF_AND_ENEMY) {
            AbstractDungeon.actionManager.cardQueue.add(new CardQueueItem(this.hoveredCard, this.hoveredMonster));
        } else {
            AbstractDungeon.actionManager.cardQueue.add(new CardQueueItem(this.hoveredCard, null));
        }
        this.isUsingClickDragControl = false;
        this.hoveredCard = null;
        this.isDraggingCard = false;
    }

    public void releaseCard() {
        this.passedHesitationLine = false;
        InputHelper.justClickedLeft = false;
        InputHelper.justReleasedClickLeft = false;
        InputHelper.isMouseDown = false;
        this.inSingleTargetMode = false;
        GameCursor.hidden = false;
        this.isUsingClickDragControl = false;
        this.isHoveringDropZone = false;
        this.isDraggingCard = false;
        this.isHoveringCard = false;
        if (this.hoveredCard != null) {
            if (this.hoveredCard.canUse(this, null)) {
                this.hoveredCard.beginGlowing();
            }
            this.hoveredCard.untip();
            this.hoveredCard.hoverTimer = 0.25f;
            this.hoveredCard.unhover();
        }
        this.hoveredCard = null;
        this.hand.refreshHandLayout();
    }

    public void onCardDrawOrDiscard() {
        for (AbstractPower p : this.powers) {
            p.onDrawOrDiscard();
        }
        for (AbstractRelic r : this.relics) {
            r.onDrawOrDiscard();
        }
        if (this.hasPower("Corruption")) {
            for (AbstractCard c : this.hand.group) {
                if (c.type != AbstractCard.CardType.SKILL || c.costForTurn == 0) continue;
                c.modifyCostForCombat(-9);
            }
        }
        this.hand.applyPowers();
        this.hand.glowCheck();
    }

    public void useCard(AbstractCard c, AbstractMonster monster, int energyOnUse) {
        if (c.type == AbstractCard.CardType.ATTACK) {
            this.useFastAttackAnimation();
        }
        c.calculateCardDamage(monster);
        if (c.cost == -1) {
            c.use(this, monster, energyOnUse);
        } else {
            c.use(this, monster);
        }
        AbstractDungeon.actionManager.addToBottom(new UseCardAction(c, monster));
        this.hand.triggerOnOtherCardPlayed(c);
        this.hand.removeCard(c);
        this.cardInUse = c;
        c.target_x = Settings.WIDTH / 2;
        c.target_y = Settings.HEIGHT / 2;
        if (c.cost > 0 && !c.freeToPlayOnce) {
            switch (c.color) {
                case RED: {
                    if (this.hasPower("Corruption") && c.type == AbstractCard.CardType.SKILL) break;
                    this.energy.use(c.costForTurn, 0, 0);
                    break;
                }
                case GREEN: {
                    if (this.hasPower("Bullet Time")) break;
                    this.energy.use(0, c.costForTurn, 0);
                    break;
                }
                case BLUE: {
                    this.energy.use(0, 0, c.costForTurn);
                    break;
                }
            }
        }
        if (!c.freeToPlayOnce && c.chargeCost > 0) {
            this.loseCharge(c.chargeCost);
        }
        if (!this.hand.canUseAnyCard() && !this.endTurnQueued) {
            AbstractDungeon.overlayMenu.endTurnButton.isGlowing = true;
        }
    }

    @Override
    public void damage(DamageInfo info) {
        int damageAmount = info.output;
        boolean hadBlock = true;
        if (this.currentBlock == 0) {
            hadBlock = false;
        }
        if (damageAmount < 0) {
            damageAmount = 0;
            logger.info("LINE 726: AbstractPlayer.java: Why is damageAmount less than 0?");
        }
        damageAmount = this.decrementBlock(info, damageAmount);
        if (info.owner == this) {
            for (AbstractRelic r : this.relics) {
                r.onAttack(info, damageAmount, this);
            }
        }
        if (info.owner != null) {
            for (AbstractPower p : info.owner.powers) {
                p.onAttack(info, damageAmount, this);
            }
            for (AbstractPower p : this.powers) {
                damageAmount = p.onAttacked(info, damageAmount);
            }
            for (AbstractRelic r : this.relics) {
                damageAmount = r.onAttacked(info, damageAmount);
            }
        } else {
            logger.info("NO OWNER, DON'T TRIGGER POWERS");
        }
        if (damageAmount > 0) {
            for (AbstractPower p : this.powers) {
                p.onLoseHp(damageAmount);
            }
            if (info.owner != this) {
                this.useStaggerAnimation();
            }
            GameActionManager.damageReceivedThisTurn += damageAmount;
            GameActionManager.damageReceivedThisCombat += damageAmount;
            this.updateCardsOnDamage();
            ++this.damagedThisCombat;
            this.currentHealth -= damageAmount;
            AbstractDungeon.effectList.add(new StrikeEffect((AbstractCreature)this, this.hb.cX, this.hb.cY, damageAmount));
            if (this.currentHealth < 0) {
                this.currentHealth = 0;
            } else if (this.currentHealth < this.maxHealth / 4) {
                AbstractDungeon.topLevelEffects.add(new BorderFlashEffect(new Color(1.0f, 0.1f, 0.05f, 0.0f)));
            }
            this.healthBarUpdatedEvent();
            if ((float)this.currentHealth < (float)this.maxHealth / 2.0f && !this.isBloodied) {
                this.isBloodied = true;
                for (AbstractRelic r : this.relics) {
                    if (r == null) continue;
                    r.onBloodied();
                }
            }
            if (this.currentHealth < 1) {
                if (this.hasRelic("Lizard Tail") && ((LizardTail)this.getRelic((String)"Lizard Tail")).counter == -1) {
                    this.currentHealth = 0;
                    this.getRelic("Lizard Tail").onTrigger();
                    return;
                }
                this.isDead = true;
                AbstractDungeon.deathScreen = new DeathScreen(AbstractDungeon.getMonsters());
                this.currentHealth = 0;
                if (this.currentBlock > 0) {
                    this.loseBlock();
                    AbstractDungeon.effectList.add(new HbBlockBrokenEffect(this.hb.cX - this.hb.width / 2.0f + BLOCK_ICON_X, this.hb.cY - this.hb.height / 2.0f + BLOCK_ICON_Y));
                }
            }
        } else if (this.currentBlock > 0) {
            AbstractDungeon.effectList.add(new BlockedWordEffect(this, this.hb.cX, this.hb.cY, "Blocked"));
        } else if (!hadBlock) {
            AbstractDungeon.effectList.add(new StrikeEffect((AbstractCreature)this, this.hb.cX, this.hb.cY, 0));
        }
    }

    private void updateCardsOnDamage() {
        for (AbstractCard c : this.hand.group) {
            c.tookDamage();
        }
        for (AbstractCard c : this.discardPile.group) {
            c.tookDamage();
        }
        for (AbstractCard c : this.drawPile.group) {
            c.tookDamage();
        }
    }

    @Override
    public void heal(int healAmount) {
        super.heal(healAmount);
        if (this.currentHealth >= this.maxHealth / 2 && this.isBloodied) {
            this.isBloodied = false;
            for (AbstractRelic r : this.relics) {
                if (r == null) continue;
                r.onNotBloodied();
            }
        }
    }

    public void gainEnergy(int a) {
        switch (AbstractDungeon.player.chosenClass) {
            case IRONCLAD: {
                EnergyPanel.addEnergy(a, 0, 0);
                break;
            }
            case THE_SILENT: {
                EnergyPanel.addEnergy(0, a, 0);
                break;
            }
            case CROWBOT: {
                EnergyPanel.addEnergy(0, 0, a);
                break;
            }
        }
        this.hand.glowCheck();
    }

    public void gainEnergy(int r, int g, int b) {
        EnergyPanel.addEnergy(r, g, b);
        this.hand.glowCheck();
    }

    public void loseEnergy(int r, int g, int b) {
        EnergyPanel.useEnergy(r, g, b);
    }

    public void preBattlePrep() {
        if (!TipTracker.tips.get("COMBAT_TIP").booleanValue()) {
            AbstractDungeon.ftue = new MultiPageFtue();
            TipTracker.neverShowAgain("COMBAT_TIP");
        }
        AbstractDungeon.actionManager.clear();
        this.damagedThisCombat = 0;
        this.cardsPlayedThisTurn = 0;
        if (this.currentHealth > this.maxHealth / 2) {
            this.isBloodied = false;
        }
        poisonKillCount = 0;
        this.charge = 0;
        GameActionManager.playerHpLastTurn = this.currentHealth;
        this.endTurnQueued = false;
        this.gameHandSize = this.masterHandSize;
        this.isDraggingCard = false;
        this.isHoveringDropZone = false;
        this.hoveredCard = null;
        this.cardInUse = null;
        this.drawPile.initializeDeck(this.masterDeck);
        AbstractDungeon.overlayMenu.endTurnButton.enabled = false;
        this.hand.clear();
        this.discardPile.clear();
        this.exhaustPile.clear();
        this.energy.prep();
        this.powers.clear();
        this.isEndingTurn = false;
        this.healthBarUpdatedEvent();
        AbstractDungeon.getCurrRoom().monsters.usePreBattleAction();
        AbstractDungeon.actionManager.addToTop(new WaitAction(1.0f));
        this.applyPreCombatLogic();
    }

    public ArrayList<String> getRelicNames() {
        ArrayList<String> arr = new ArrayList<String>();
        for (AbstractRelic relic : this.relics) {
            arr.add(relic.relicId);
        }
        return arr;
    }

    public void draw(int numCards) {
        for (int i = 0; i < numCards; ++i) {
            if (!this.drawPile.isEmpty()) {
                int newCost;
                AbstractCard c = this.drawPile.getTopCard();
                c.current_x = CardGroup.DRAW_PILE_X;
                c.current_y = CardGroup.DRAW_PILE_Y;
                c.setAngle(0.0f, true);
                c.lighten(false);
                c.drawScale = 0.12f;
                c.targetDrawScale = 0.75f;
                if (AbstractDungeon.player.hasPower("Confusion") && c.color != AbstractCard.CardColor.COLORLESS && c.cost > -1 && c.color != AbstractCard.CardColor.CURSE && c.cost != (newCost = MathUtils.random(0, 3))) {
                    c.costForTurn = c.cost = newCost;
                    c.isCostModified = true;
                }
                c.triggerWhenDrawn();
                if (c.type == AbstractCard.CardType.POWER && !TipTracker.tips.get("POWER_TIP").booleanValue()) {
                    AbstractDungeon.ftue = new FtueTip(LABEL[0], MSG[0], (float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT / 2.0f, c);
                    TipTracker.neverShowAgain("POWER_TIP");
                }
                this.hand.addToHand(c);
                this.drawPile.removeTopCard();
                if (AbstractDungeon.player.hasPower("Corruption") && c.type == AbstractCard.CardType.SKILL) {
                    c.setCostForTurn(-9);
                }
                for (AbstractRelic r : this.relics) {
                    r.onCardDraw(c);
                }
                continue;
            }
            logger.info("ERROR: How did this happen? No cards in draw pile?? Player.java");
        }
    }

    public void draw() {
        if (this.hand.size() == 10) {
            AbstractDungeon.player.createHandIsFullDialog();
            return;
        }
        this.draw(1);
        this.onCardDrawOrDiscard();
    }

    @Override
    public void render(SpriteBatch sb) {
        if ((AbstractDungeon.getCurrRoom().phase == AbstractRoom.RoomPhase.COMBAT || AbstractDungeon.getCurrRoom() instanceof MonsterRoom) && !this.isDead) {
            this.renderHealth(sb);
        }
        if (!(AbstractDungeon.getCurrRoom() instanceof RestRoom)) {
            if (this.damageFlash) {
                ShaderHelper.setShader(sb, ShaderHelper.Shader.WHITE_SILHOUETTE);
            }
            if (this.atlas == null || this.renderCorpse) {
                sb.setColor(Color.WHITE);
                sb.draw(this.img, this.drawX - (float)this.img.getWidth() * Settings.scale / 2.0f + this.animX, this.drawY, (float)this.img.getWidth() * Settings.scale, (float)this.img.getHeight() * Settings.scale, 0, 0, this.img.getWidth(), this.img.getHeight(), false, false);
                if (this.chosenClass == PlayerClass.CROWBOT) {
                    FontHelper.renderFontCentered(sb, FontHelper.topPanelInfoFont, Integer.toString(this.charge), this.drawX - 90.0f * Settings.scale, this.drawY + 170.0f * Settings.scale, Color.CYAN.cpy());
                }
            } else {
                this.renderPlayerImage(sb);
            }
            if (this.damageFlash) {
                ShaderHelper.setShader(sb, ShaderHelper.Shader.DEFAULT);
                --this.damageFlashFrames;
                if (this.damageFlashFrames == 0) {
                    this.damageFlash = false;
                }
            }
            this.hb.render(sb);
            this.healthHb.render(sb);
        } else {
            sb.setColor(Color.WHITE);
            if (CampfireUI.hidden) {
                sb.draw(this.shoulder2Img, 0.0f, 0.0f, (float)Settings.WIDTH, 1136.0f * Settings.scale);
            } else {
                sb.draw(this.shoulderImg, this.animX, 0.0f, (float)Settings.WIDTH, 1136.0f * Settings.scale);
            }
        }
    }

    public void renderPlayerImage(SpriteBatch sb) {
        this.state.update(Gdx.graphics.getDeltaTime());
        this.state.apply(this.skeleton);
        this.skeleton.updateWorldTransform();
        this.skeleton.setPosition(this.drawX + this.animX, this.drawY + this.animY + AbstractDungeon.sceneOffsetY);
        this.skeleton.setColor(this.tint.color);
        sb.end();
        CardCrawlGame.psb.begin();
        sr.draw(CardCrawlGame.psb, this.skeleton);
        CardCrawlGame.psb.end();
        sb.begin();
        if (this.chosenClass == PlayerClass.CROWBOT) {
            FontHelper.renderFontCentered(sb, FontHelper.topPanelInfoFont, Integer.toString(this.charge), this.drawX - 90.0f * Settings.scale, this.drawY + 170.0f * Settings.scale, Color.CYAN.cpy());
        }
    }

    public void renderPlayerBattleUi(SpriteBatch sb) {
        if ((this.hb.hovered || this.healthHb.hovered) && !AbstractDungeon.isScreenUp) {
            this.renderPowerTips(sb);
        }
    }

    public void renderHand(SpriteBatch sb) {
        if (this.hoveredCard != null) {
            int aliveMonsters = 0;
            this.hand.renderHand(sb, this.hoveredCard);
            this.hoveredCard.renderHoverShadow(sb);
            if ((this.isDraggingCard || this.inSingleTargetMode) && this.isHoveringDropZone) {
                if (this.isDraggingCard && !this.inSingleTargetMode) {
                    AbstractMonster theMonster = null;
                    for (AbstractMonster m : AbstractDungeon.getMonsters().monsters) {
                        if (m.isDying || m.currentHealth <= 0) continue;
                        ++aliveMonsters;
                        theMonster = m;
                    }
                    if (aliveMonsters == 1 && this.hoveredMonster == null) {
                        this.hoveredCard.calculateCardDamage(theMonster);
                        this.hoveredCard.render(sb);
                        this.hoveredCard.applyPowers();
                    } else {
                        this.hoveredCard.render(sb);
                    }
                }
                if (!AbstractDungeon.getCurrRoom().isBattleEnding()) {
                    this.renderHoverReticle(sb);
                }
            }
            if (this.hoveredMonster != null) {
                this.hoveredCard.calculateCardDamage(this.hoveredMonster);
                this.hoveredCard.render(sb);
                this.hoveredCard.applyPowers();
            } else if (aliveMonsters != 1) {
                this.hoveredCard.render(sb);
            }
        } else if (AbstractDungeon.screen == AbstractDungeon.CurrentScreen.HAND_SELECT) {
            this.hand.render(sb);
        } else {
            this.hand.renderHand(sb, this.cardInUse);
        }
        if (this.cardInUse != null && AbstractDungeon.screen != AbstractDungeon.CurrentScreen.HAND_SELECT) {
            this.cardInUse.render(sb);
            if (AbstractDungeon.getCurrRoom().phase != AbstractRoom.RoomPhase.COMBAT) {
                AbstractDungeon.effectList.add(new PurgeCardEffect(this.cardInUse.makeCopy(), this.cardInUse.current_x, this.cardInUse.current_y));
                this.cardInUse = null;
            }
        }
        this.limbo.render(sb);
        if (this.inSingleTargetMode && AbstractDungeon.getCurrRoom().phase == AbstractRoom.RoomPhase.COMBAT && !AbstractDungeon.getCurrRoom().isBattleEnding()) {
            this.renderTargetingUi(sb);
        }
        this.renderHoverNumberLogic(sb);
    }

    private void renderHoverNumberLogic(SpriteBatch sb) {
        if (this.isHoveringDropZone && this.hoveredCard != null && Settings.isInfo) {
            if (this.hoveredCard.target == AbstractCard.CardTarget.ENEMY && this.hoveredMonster != null) {
                this.hoverTimer = MathHelper.fadeLerpSnap(this.hoverTimer, 1.0f);
                this.hoveredCard.calculateDamageDisplay(this.hoveredMonster);
                FontHelper.renderFontCentered(sb, FontHelper.bannerFont, Integer.toString(this.hoveredCard.damage), this.hoveredMonster.hb.cX, this.hoveredMonster.hb.cY + this.hoveredMonster.hb.height / 2.0f + 80.0f * Settings.scale + this.hoverTimer * 30.0f * Settings.scale, new Color(1.0f, 0.9f, 0.4f, this.hoverTimer));
            } else if (this.hoveredCard.target == AbstractCard.CardTarget.ALL_ENEMY) {
                this.hoverTimer = MathHelper.fadeLerpSnap(this.hoverTimer, 1.0f);
                this.hoveredCard.calculateDamageDisplay(null);
                float tmpY = 80.0f * Settings.scale + this.hoverTimer * 30.0f * Settings.scale;
                int i = 0;
                for (AbstractMonster m : AbstractDungeon.getMonsters().monsters) {
                    FontHelper.renderFontCentered(sb, FontHelper.bannerFont, Integer.toString(this.hoveredCard.multiDamage[i]), m.hb.cX, m.hb.cY + m.hb.height / 2.0f + tmpY, new Color(1.0f, 0.9f, 0.4f, this.hoverTimer));
                    ++i;
                }
            } else {
                this.hoverTimer = MathHelper.fadeLerpSnap(this.hoverTimer, 0.0f);
            }
        } else {
            this.hoverTimer = MathHelper.fadeLerpSnap(this.hoverTimer, 0.0f);
        }
    }

    private void renderTargetingUi(SpriteBatch sb) {
        this.arrowX = MathHelper.mouseLerpSnap(this.arrowX, InputHelper.mX);
        this.arrowY = MathHelper.mouseLerpSnap(this.arrowY, InputHelper.mY);
        this.controlPoint = new Vector2(this.hoveredCard.current_x - (this.arrowX - this.hoveredCard.current_x) / 4.0f, this.arrowY + (this.arrowY - this.hoveredCard.current_y) / 2.0f);
        if (this.hoveredMonster == null) {
            this.arrowScale = Settings.scale;
            this.arrowScaleTimer = 0.0f;
            sb.setColor(Color.WHITE);
        } else {
            this.arrowScaleTimer += Gdx.graphics.getDeltaTime();
            if (this.arrowScaleTimer > 1.0f) {
                this.arrowScaleTimer = 1.0f;
            }
            this.arrowScale = Interpolation.elasticOut.apply(Settings.scale, Settings.scale * 1.2f, this.arrowScaleTimer);
            sb.setColor(ARROW_COLOR);
        }
        Vector2 tmp = new Vector2(this.controlPoint.x - this.arrowX, this.controlPoint.y - this.arrowY);
        tmp.nor();
        this.drawCurvedLine(sb, new Vector2(this.hoveredCard.current_x, this.hoveredCard.current_y), new Vector2(this.arrowX, this.arrowY), this.controlPoint);
        sb.draw(ImageMaster.TARGET_UI_ARROW, this.arrowX - 128.0f, this.arrowY - 128.0f, 128.0f, 128.0f, 256.0f, 256.0f, this.arrowScale, this.arrowScale, tmp.angle() + 90.0f, 0, 0, 256, 256, false, false);
    }

    private void drawCurvedLine(SpriteBatch sb, Vector2 start, Vector2 end, Vector2 control) {
        float radius = 7.0f * Settings.scale;
        for (int i = 0; i < this.points.length - 1; ++i) {
            float angle;
            Vector2 tmp;
            this.points[i] = Bezier.quadratic(this.points[i], (float)i / 20.0f, start, control, end, new Vector2());
            radius += 0.4f * Settings.scale;
            if (i != 0) {
                tmp = new Vector2(this.points[i - 1].x - this.points[i].x, this.points[i - 1].y - this.points[i].y);
                angle = tmp.nor().angle() + 90.0f;
            } else {
                tmp = new Vector2(this.controlPoint.x - this.points[i].x, this.controlPoint.y - this.points[i].y);
                angle = tmp.nor().angle() + 270.0f;
            }
            sb.draw(ImageMaster.TARGET_UI_CIRCLE, this.points[i].x - 64.0f, this.points[i].y - 64.0f, 64.0f, 64.0f, 128.0f, 128.0f, radius / 18.0f, radius / 18.0f, angle, 0, 0, 128, 128, false, false);
        }
    }

    public void createHandIsFullDialog() {
        AbstractDungeon.effectList.add(new ThoughtBubble(this.dialogX, this.dialogY, 3.0f, MSG[2], true));
    }

    private void renderHoverReticle(SpriteBatch sb) {
        switch (this.hoveredCard.target) {
            case ENEMY: {
                if (!this.inSingleTargetMode || this.hoveredMonster == null) break;
                this.hoveredMonster.renderReticle(sb);
                break;
            }
            case ALL_ENEMY: {
                AbstractDungeon.getCurrRoom().monsters.renderReticle(sb);
                break;
            }
            case SELF: {
                this.renderReticle(sb);
                break;
            }
            case SELF_AND_ENEMY: {
                this.renderReticle(sb);
                if (!this.inSingleTargetMode || this.hoveredMonster == null) break;
                this.hoveredMonster.renderReticle(sb);
                break;
            }
            case ALL: {
                this.renderReticle(sb);
                AbstractDungeon.getCurrRoom().monsters.renderReticle(sb);
                break;
            }
            case NONE: {
                break;
            }
        }
    }

    public void applyPreCombatLogic() {
        for (AbstractRelic r : this.relics) {
            if (r == null) continue;
            r.atPreBattle();
        }
    }

    public void applyStartOfCombatLogic() {
        for (AbstractRelic r : this.relics) {
            if (r == null) continue;
            r.atBattleStart();
        }
    }

    public void applyStartOfTurnRelics() {
        for (AbstractRelic r : this.relics) {
            if (r == null) continue;
            r.atTurnStart();
        }
    }

    public void applyStartOfTurnCards() {
        for (AbstractCard c : this.drawPile.group) {
            if (c == null) continue;
            c.atTurnStart();
        }
        for (AbstractCard c : this.hand.group) {
            if (c == null) continue;
            c.atTurnStart();
        }
        for (AbstractCard c : this.discardPile.group) {
            if (c == null) continue;
            c.atTurnStart();
        }
    }

    public void onVictory() {
        if (!this.isDying) {
            for (AbstractRelic r : this.relics) {
                r.onVictory();
            }
        }
        this.damagedThisCombat = 0;
    }

    public boolean hasRelic(String targetID) {
        for (AbstractRelic r : this.relics) {
            if (!r.relicId.equals(targetID)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPotion(String id) {
        for (AbstractPotion p : this.potions) {
            if (!p.ID.equals(id)) continue;
            return true;
        }
        return false;
    }

    public boolean losePotion(String id) {
        if (!this.hasPotion(id)) {
            return false;
        }
        for (int i = 0; i < this.potions.length; ++i) {
            if (!this.potions[i].ID.equals(id)) continue;
            AbstractDungeon.topPanel.destroyPotion(i);
            return true;
        }
        logger.info("WHY WAS POTION: " + id + " NOT FOUND???");
        return false;
    }

    public void loseRandomRelics(int amount) {
        if (amount > this.relics.size()) {
            for (AbstractRelic r : this.relics) {
                r.onUnequip();
            }
            this.relics.clear();
            return;
        }
        for (int i = 0; i < amount; ++i) {
            int index = MathUtils.random(0, this.relics.size() - 1);
            this.relics.get(index).onUnequip();
            this.relics.remove(index);
        }
        this.reorganizeRelics();
    }

    public boolean loseRelic(String targetID) {
        if (!this.hasRelic(targetID)) {
            return false;
        }
        AbstractRelic toRemove = null;
        for (AbstractRelic r : this.relics) {
            if (!r.relicId.equals(targetID)) continue;
            r.onUnequip();
            toRemove = r;
        }
        if (toRemove == null) {
            logger.info("WHY WAS RELIC: " + this.name + " NOT FOUND???");
            return false;
        }
        this.relics.remove(toRemove);
        this.reorganizeRelics();
        return true;
    }

    public void reorganizeRelics() {
        logger.info("Reorganizing relics");
        ArrayList<AbstractRelic> tmpRelics = new ArrayList<AbstractRelic>();
        tmpRelics.addAll(this.relics);
        this.relics.clear();
        for (int i = 0; i < tmpRelics.size(); ++i) {
            ((AbstractRelic)tmpRelics.get(i)).reorganizeObtain(this, i, false, tmpRelics.size());
        }
    }

    public AbstractRelic getRelic(String targetID) {
        for (AbstractRelic r : this.relics) {
            if (!r.relicId.equals(targetID)) continue;
            return r;
        }
        return null;
    }

    public void renderRelics(SpriteBatch sb) {
        for (AbstractRelic r : this.relics) {
            r.render(sb);
        }
        for (AbstractRelic r : this.relics) {
            if (!r.hitbox.hovered || !Settings.RELIC_TIP) continue;
            r.renderTip(sb);
        }
    }

    public static String getClass(PlayerClass c) {
        switch (c) {
            case IRONCLAD: {
                return "The Ironclad";
            }
            case THE_SILENT: {
                return "The Silent";
            }
            case CROWBOT: {
                return "The Robot";
            }
        }
        return "Unknown";
    }

    public void gainCharge(int amount) {
        for (AbstractPower pow : AbstractDungeon.player.powers) {
            pow.onGainCharge(amount);
        }
        this.charge += amount;
    }

    public void loseCharge(int amount) {
        this.charge -= amount;
        if (this.charge < 0) {
            this.charge = 0;
        }
    }

    public void bottledCardUpgradeCheck(AbstractCard c) {
        if (c.inBottleFlame && AbstractDungeon.player.hasRelic("Bottled Flame")) {
            ((BottledFlame)AbstractDungeon.player.getRelic("Bottled Flame")).setDescriptionAfterLoading();
        }
        if (c.inBottleLightning && AbstractDungeon.player.hasRelic("Bottled Lightning")) {
            ((BottledLightning)AbstractDungeon.player.getRelic("Bottled Lightning")).setDescriptionAfterLoading();
        }
    }

    public static enum PlayerClass {
        IRONCLAD,
        THE_SILENT,
        CROWBOT;

    }
}

