/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.cards.red;

import com.megacrit.cardcrawl.actions.common.GainBlockAction;
import com.megacrit.cardcrawl.actions.common.GainEnergyAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.localization.CardStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;

public class Sentinel
extends AbstractCard {
    public static final String ID = "Sentinel";
    private static final CardStrings cardStrings = CardCrawlGame.languagePack.getCardStrings("Sentinel");
    public static final String NAME = Sentinel.cardStrings.NAME;
    public static final String DESCRIPTION = Sentinel.cardStrings.DESCRIPTION;
    public static final String UPGRADE_DESCRIPTION = Sentinel.cardStrings.UPGRADE_DESCRIPTION;
    private static final int COST = 1;
    private static final int BLOCK_AMT = 5;
    private static final int POOL = 1;

    public Sentinel() {
        super(ID, NAME, "red/skill/sentinel", "red/skill/sentinel", 1, DESCRIPTION, AbstractCard.CardType.SKILL, AbstractCard.CardColor.RED, AbstractCard.CardRarity.UNCOMMON, AbstractCard.CardTarget.SELF, 1);
        this.baseBlock = 5;
    }

    @Override
    public void use(AbstractPlayer p, AbstractMonster m) {
        AbstractDungeon.actionManager.addToBottom(new GainBlockAction(p, p, this.block));
    }

    @Override
    public void triggerOnExhaust() {
        if (this.upgraded) {
            AbstractDungeon.actionManager.addToTop(new GainEnergyAction(3));
        } else {
            AbstractDungeon.actionManager.addToTop(new GainEnergyAction(2));
        }
    }

    @Override
    public AbstractCard makeCopy() {
        return new Sentinel();
    }

    @Override
    public void upgrade() {
        if (!this.upgraded) {
            this.upgradeName();
            this.upgradeBlock(3);
            this.rawDescription = UPGRADE_DESCRIPTION;
            this.initializeDescription();
        }
    }
}

