/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.cards.red;

import com.megacrit.cardcrawl.actions.unique.FiendFireAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.DamageInfo;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.localization.CardStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;

public class FiendFire
extends AbstractCard {
    public static final String ID = "Fiend Fire";
    private static final CardStrings cardStrings = CardCrawlGame.languagePack.getCardStrings("Fiend Fire");
    public static final String NAME = FiendFire.cardStrings.NAME;
    public static final String DESCRIPTION = FiendFire.cardStrings.DESCRIPTION;
    private static final int BASE_DAMAGE = 7;
    private static final int COST = 2;
    private static final int POOL = 2;

    public FiendFire() {
        super(ID, NAME, "red/attack/demonFire", "red/attack/fiendFire", 2, DESCRIPTION, AbstractCard.CardType.ATTACK, AbstractCard.CardColor.RED, AbstractCard.CardRarity.RARE, AbstractCard.CardTarget.ENEMY, 2);
        this.baseDamage = 7;
        this.exhaust = true;
    }

    @Override
    public void use(AbstractPlayer p, AbstractMonster m) {
        AbstractDungeon.actionManager.addToBottom(new FiendFireAction(m, new DamageInfo(p, this.damage, this.damageTypeForTurn)));
    }

    @Override
    public AbstractCard makeCopy() {
        return new FiendFire();
    }

    @Override
    public void upgrade() {
        if (!this.upgraded) {
            this.upgradeName();
            this.upgradeDamage(3);
        }
    }
}

