/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.cards.green;

import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.actions.common.DamageAllEnemiesAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.localization.CardStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;

public class GrandFinale
extends AbstractCard {
    public static final String ID = "Grand Finale";
    private static final CardStrings cardStrings = CardCrawlGame.languagePack.getCardStrings("Grand Finale");
    public static final String NAME = GrandFinale.cardStrings.NAME;
    public static final String DESCRIPTION = GrandFinale.cardStrings.DESCRIPTION;
    private static final int COST = 2;
    private static final int ATTACK_DMG = 40;
    private static final int POOL = 2;

    public GrandFinale() {
        super(ID, NAME, "green/attack/grandFinale", "green/attack/grandFinale", 2, DESCRIPTION, AbstractCard.CardType.ATTACK, AbstractCard.CardColor.GREEN, AbstractCard.CardRarity.RARE, AbstractCard.CardTarget.ALL_ENEMY, 2);
        this.baseDamage = 40;
        this.isMultiDamage = true;
    }

    @Override
    public void use(AbstractPlayer p, AbstractMonster m) {
        AbstractDungeon.actionManager.addToBottom(new DamageAllEnemiesAction(p, this.multiDamage, this.damageTypeForTurn, AbstractGameAction.AttackEffect.SLASH_HEAVY));
    }

    @Override
    public boolean canUse(AbstractPlayer p, AbstractMonster m) {
        boolean canUse = super.canUse(p, m);
        if (!canUse) {
            return false;
        }
        if (p.drawPile.size() > 0) {
            this.cantUseMessage = "My draw pile NL must be #rEmpty.";
            return false;
        }
        return canUse;
    }

    @Override
    public AbstractCard makeCopy() {
        return new GrandFinale();
    }

    @Override
    public void upgrade() {
        if (!this.upgraded) {
            this.upgradeName();
            this.upgradeDamage(10);
        }
    }
}

