/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.cards.green;

import com.megacrit.cardcrawl.actions.common.ApplyPowerAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.localization.CardStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;
import com.megacrit.cardcrawl.powers.DrawCardNextTurnPower;
import com.megacrit.cardcrawl.powers.EnergizedPower;
import com.megacrit.cardcrawl.ui.panels.EnergyPanel;

public class Doppelganger
extends AbstractCard {
    public static final String ID = "Doppelganger";
    private static final CardStrings cardStrings = CardCrawlGame.languagePack.getCardStrings("Doppelganger");
    public static final String NAME = Doppelganger.cardStrings.NAME;
    public static final String DESCRIPTION = Doppelganger.cardStrings.DESCRIPTION;
    public static final String UPGRADE_DESCRIPTION = Doppelganger.cardStrings.UPGRADE_DESCRIPTION;
    private static final int COST = -1;
    private static final int POOL = 1;

    public Doppelganger() {
        super(ID, NAME, "green/skill/doppelganger", "green/skill/doppelganger", -1, DESCRIPTION, AbstractCard.CardType.SKILL, AbstractCard.CardColor.GREEN, AbstractCard.CardRarity.RARE, AbstractCard.CardTarget.SELF, 1);
        this.exhaust = true;
    }

    @Override
    public void use(AbstractPlayer p, AbstractMonster m, int energyAmount) {
        int effect = energyAmount;
        if (p.hasRelic("Chemical X")) {
            effect += 2;
            p.getRelic("Chemical X").flash();
        }
        if (this.upgraded) {
            ++effect;
        }
        if (effect > 0) {
            AbstractDungeon.actionManager.addToBottom(new ApplyPowerAction(p, p, new EnergizedPower(p, effect), effect));
            AbstractDungeon.actionManager.addToBottom(new ApplyPowerAction(p, p, new DrawCardNextTurnPower(p, effect), effect));
            if (!this.freeToPlayOnce) {
                p.energy.use(0, EnergyPanel.greenCount, 0);
            }
        }
    }

    @Override
    public void use(AbstractPlayer p, AbstractMonster m) {
        this.use(p, m, EnergyPanel.greenCount);
    }

    @Override
    public AbstractCard makeCopy() {
        return new Doppelganger();
    }

    @Override
    public void upgrade() {
        if (!this.upgraded) {
            this.upgradeName();
            this.rawDescription = UPGRADE_DESCRIPTION;
            this.initializeDescription();
        }
    }
}

