/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.cards.green;

import com.megacrit.cardcrawl.actions.unique.DoublePoisonAction;
import com.megacrit.cardcrawl.actions.unique.TriplePoisonAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.localization.CardStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;

public class Catalyst
extends AbstractCard {
    public static final String ID = "Catalyst";
    private static final CardStrings cardStrings = CardCrawlGame.languagePack.getCardStrings("Catalyst");
    public static final String NAME = Catalyst.cardStrings.NAME;
    public static final String DESCRIPTION = Catalyst.cardStrings.DESCRIPTION;
    public static final String UPGRADE_DESCRIPTION = Catalyst.cardStrings.UPGRADE_DESCRIPTION;
    private static final int COST = 1;
    private static final int POOL = 1;

    public Catalyst() {
        super(ID, NAME, null, "green/skill/catalyst", 1, DESCRIPTION, AbstractCard.CardType.SKILL, AbstractCard.CardColor.GREEN, AbstractCard.CardRarity.UNCOMMON, AbstractCard.CardTarget.ENEMY, 1);
        this.exhaust = true;
    }

    @Override
    public void use(AbstractPlayer p, AbstractMonster m) {
        if (!this.upgraded) {
            AbstractDungeon.actionManager.addToBottom(new DoublePoisonAction(m, p));
        } else {
            AbstractDungeon.actionManager.addToBottom(new TriplePoisonAction(m, p));
        }
    }

    @Override
    public AbstractCard makeCopy() {
        return new Catalyst();
    }

    @Override
    public void upgrade() {
        if (!this.upgraded) {
            this.upgradeName();
            this.rawDescription = UPGRADE_DESCRIPTION;
            this.initializeDescription();
        }
    }
}

