/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.cards.green;

import com.megacrit.cardcrawl.actions.animations.VFXAction;
import com.megacrit.cardcrawl.actions.unique.BouncingFlaskAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.localization.CardStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;
import com.megacrit.cardcrawl.vfx.combat.PotionBounceEffect;

public class BouncingFlask
extends AbstractCard {
    public static final String ID = "Bouncing Flask";
    private static final CardStrings cardStrings = CardCrawlGame.languagePack.getCardStrings("Bouncing Flask");
    public static final String NAME = BouncingFlask.cardStrings.NAME;
    public static final String DESCRIPTION = BouncingFlask.cardStrings.DESCRIPTION;
    private static final int COST = 2;
    private static final int POISON_AMT = 3;
    private static final int NUM_BOUNCES = 3;
    private static final int POOL = 1;

    public BouncingFlask() {
        super(ID, NAME, "green/skill/bouncingFlask", "green/skill/bouncingFlask", 2, DESCRIPTION, AbstractCard.CardType.SKILL, AbstractCard.CardColor.GREEN, AbstractCard.CardRarity.UNCOMMON, AbstractCard.CardTarget.ALL_ENEMY, 1);
        this.magicNumber = this.baseMagicNumber = 3;
    }

    @Override
    public void use(AbstractPlayer p, AbstractMonster m) {
        AbstractMonster randomMonster = AbstractDungeon.getMonsters().getRandomMonster(true);
        if (randomMonster != null) {
            AbstractDungeon.actionManager.addToBottom(new VFXAction(new PotionBounceEffect(p.hb.cY, p.hb.cX, randomMonster.hb.cX, this.hb.cY), 0.3f));
        }
        AbstractDungeon.actionManager.addToBottom(new BouncingFlaskAction(randomMonster, 3, this.magicNumber));
    }

    @Override
    public AbstractCard makeCopy() {
        return new BouncingFlask();
    }

    @Override
    public void upgrade() {
        if (!this.upgraded) {
            this.upgradeName();
            this.upgradeMagicNumber(1);
        }
    }
}

