/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.cards.curses;

import com.megacrit.cardcrawl.actions.utility.UseCardAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.localization.CardStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;

public class Normality
extends AbstractCard {
    public static final String ID = "Normality";
    private static final CardStrings cardStrings = CardCrawlGame.languagePack.getCardStrings("Normality");
    public static final String NAME = Normality.cardStrings.NAME;
    public static final String DESCRIPTION = Normality.cardStrings.DESCRIPTION;
    private static final int COST = -2;
    private static final int POOL = 2;
    private static final int PLAY_LIMIT = 3;

    public Normality() {
        super(ID, NAME, "curse/normality", "curse/normality", -2, DESCRIPTION, AbstractCard.CardType.CURSE, AbstractCard.CardColor.CURSE, AbstractCard.CardRarity.CURSE, AbstractCard.CardTarget.NONE, 2);
    }

    @Override
    public boolean canPlay(AbstractCard card) {
        if (AbstractDungeon.player.cardsPlayedThisTurn >= 3) {
            card.cantUseMessage = "I can only play up to NL #r3 cards per turn.";
            return false;
        }
        return true;
    }

    @Override
    public void use(AbstractPlayer p, AbstractMonster m) {
        if (p.hasRelic("Blue Candle")) {
            this.useBlueCandle(p);
        } else {
            AbstractDungeon.actionManager.addToBottom(new UseCardAction(this));
        }
    }

    @Override
    public void applyPowers() {
        super.applyPowers();
        this.rawDescription = AbstractDungeon.player.cardsPlayedThisTurn == 0 ? "Unplayable. NL You cannot play more than 3 cards per turn." : (AbstractDungeon.player.cardsPlayedThisTurn == 1 ? "Unplayable. NL You cannot play more than 3 cards per turn. NL You have played " + AbstractDungeon.player.cardsPlayedThisTurn + " card this turn." : "Unplayable. NL You cannot play more than 3 cards per turn. NL You have played " + AbstractDungeon.player.cardsPlayedThisTurn + " cards this turn.");
        this.initializeDescription();
    }

    @Override
    public AbstractCard makeCopy() {
        return new Normality();
    }

    @Override
    public void upgrade() {
    }
}

