/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.cards.colorless;

import com.megacrit.cardcrawl.actions.unique.SkillFromDeckToHandAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.localization.CardStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;

public class SecretTechnique
extends AbstractCard {
    public static final String ID = "Secret Technique";
    private static final CardStrings cardStrings = CardCrawlGame.languagePack.getCardStrings("Secret Technique");
    public static final String NAME = SecretTechnique.cardStrings.NAME;
    public static final String DESCRIPTION = SecretTechnique.cardStrings.DESCRIPTION;
    private static final int POOL = 1;

    public SecretTechnique() {
        super(ID, NAME, "colorless/skill/secretTechnique", "colorless/skill/secretTechnique", 0, DESCRIPTION, AbstractCard.CardType.SKILL, AbstractCard.CardColor.COLORLESS, AbstractCard.CardRarity.RARE, AbstractCard.CardTarget.NONE, 1);
        this.exhaust = true;
    }

    @Override
    public void use(AbstractPlayer p, AbstractMonster m) {
        AbstractDungeon.actionManager.addToBottom(new SkillFromDeckToHandAction(1));
    }

    @Override
    public boolean canUse(AbstractPlayer p, AbstractMonster m) {
        boolean canUse = super.canUse(p, m);
        if (!canUse) {
            return false;
        }
        boolean hasSkill = false;
        for (AbstractCard c : p.drawPile.group) {
            if (c.type != AbstractCard.CardType.SKILL) continue;
            hasSkill = true;
        }
        if (!hasSkill) {
            this.cantUseMessage = "There are no Skills NL in my draw pile.";
            canUse = false;
        }
        return canUse;
    }

    @Override
    public AbstractCard makeCopy() {
        return new SecretTechnique();
    }

    @Override
    public void upgrade() {
    }
}

