/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.cards.blue;

import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.actions.common.DamageAllEnemiesAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.localization.CardStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;

public class ChainLightning
extends AbstractCard {
    public static final String ID = "Chain Lightning";
    private static final CardStrings cardStrings = CardCrawlGame.languagePack.getCardStrings("Chain Lightning");
    public static final String NAME = ChainLightning.cardStrings.NAME;
    public static final String DESCRIPTION = ChainLightning.cardStrings.DESCRIPTION;
    private static final int COST = 1;
    private static final int DAMAGE_AMT = 10;
    private static final int POOL = 1;

    public ChainLightning() {
        super(ID, NAME, null, 1, DESCRIPTION, AbstractCard.CardType.ATTACK, AbstractCard.CardColor.BLUE, AbstractCard.CardRarity.COMMON, AbstractCard.CardTarget.ALL_ENEMY, 1);
        this.chargeCost = 2;
        this.baseDamage = 10;
        this.isMultiDamage = true;
    }

    @Override
    public void use(AbstractPlayer p, AbstractMonster m) {
        AbstractDungeon.actionManager.addToBottom(new DamageAllEnemiesAction(p, this.multiDamage, this.damageTypeForTurn, AbstractGameAction.AttackEffect.SLASH_HORIZONTAL));
    }

    @Override
    public AbstractCard makeCopy() {
        return new ChainLightning();
    }

    @Override
    public void upgrade() {
        if (!this.upgraded) {
            this.upgradeName();
            this.upgradeDamage(3);
        }
    }
}

