/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.cards.blue;

import com.megacrit.cardcrawl.actions.common.ApplyPowerAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.localization.CardStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;
import com.megacrit.cardcrawl.powers.KnowledgePower;

public class AncestralKnowledge
extends AbstractCard {
    public static final String ID = "Ancestral Knowledge";
    private static final CardStrings cardStrings = CardCrawlGame.languagePack.getCardStrings("Ancestral Knowledge");
    public static final String NAME = AncestralKnowledge.cardStrings.NAME;
    public static final String DESCRIPTION = AncestralKnowledge.cardStrings.DESCRIPTION;
    private static final int COST = 1;
    private static final int DRAW_AMT = 2;
    private static final int DRAW_UPG = 1;
    private static final int POOL = 1;

    public AncestralKnowledge() {
        super(ID, NAME, null, 1, DESCRIPTION, AbstractCard.CardType.POWER, AbstractCard.CardColor.BLUE, AbstractCard.CardRarity.RARE, AbstractCard.CardTarget.SELF, 1);
        this.magicNumber = this.baseMagicNumber = 2;
    }

    @Override
    public void use(AbstractPlayer p, AbstractMonster m) {
        AbstractDungeon.actionManager.addToBottom(new ApplyPowerAction(p, p, new KnowledgePower(p, this.magicNumber), this.magicNumber));
    }

    @Override
    public AbstractCard makeCopy() {
        return new AncestralKnowledge();
    }

    @Override
    public void upgrade() {
        if (!this.upgraded) {
            this.upgradeName();
            this.upgradeMagicNumber(1);
        }
    }
}

