/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.cards;

import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.MathUtils;
import com.megacrit.cardcrawl.actions.common.DrawCardAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.CardQueueItem;
import com.megacrit.cardcrawl.cards.CardSave;
import com.megacrit.cardcrawl.cards.curses.Necronomicurse;
import com.megacrit.cardcrawl.cards.curses.Parasite;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.powers.AbstractPower;
import com.megacrit.cardcrawl.relics.AbstractRelic;
import com.megacrit.cardcrawl.relics.BottledFlame;
import com.megacrit.cardcrawl.relics.BottledLightning;
import com.megacrit.cardcrawl.unlock.UnlockTracker;
import com.megacrit.cardcrawl.vfx.NecronomicurseEffect;
import com.megacrit.cardcrawl.vfx.cardManip.ExhaustCardEffect;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CardGroup {
    private static final Logger logger = LogManager.getLogger(CardGroup.class.getName());
    public ArrayList<AbstractCard> group = new ArrayList();
    public float HAND_START_X = (float)Settings.WIDTH * 0.36f;
    public float HAND_OFFSET_X = AbstractCard.IMG_WIDTH * 0.35f;
    private static final float HAND_HOVER_PUSH_AMT = 0.4f;
    private static final float PUSH_TAPER = 0.25f;
    private static final float TWO_CARD_PUSH_AMT = 0.2f;
    private static final float THREE_FOUR_CARD_PUSH_AMT = 0.27f;
    public static final float DRAW_PILE_X = (float)Settings.WIDTH * 0.04f;
    public static final float DRAW_PILE_Y = 50.0f * Settings.scale;
    public static final int DISCARD_PILE_X = (int)((float)Settings.WIDTH + AbstractCard.IMG_WIDTH_S / 2.0f + 100.0f * Settings.scale);
    public static final int DISCARD_PILE_Y = 0;
    public CardGroupType type;
    public HashMap<Integer, Integer> handPositioningMap = new HashMap();

    public CardGroup(CardGroupType type) {
        this.type = type;
    }

    public CardGroup(CardGroup g, CardGroupType type) {
        this.type = type;
        for (AbstractCard c : g.group) {
            this.group.add(c.makeStatEquivalentCopy());
        }
    }

    public ArrayList<CardSave> getCardDeck() {
        ArrayList<CardSave> retVal = new ArrayList<CardSave>();
        for (AbstractCard card : this.group) {
            retVal.add(new CardSave(card.cardID, card.timesUpgraded));
        }
        return retVal;
    }

    public ArrayList<String> getCardNames() {
        ArrayList<String> retVal = new ArrayList<String>();
        for (AbstractCard card : this.group) {
            retVal.add(card.cardID);
        }
        return retVal;
    }

    public void clear() {
        this.group.clear();
    }

    public boolean contains(AbstractCard c) {
        return this.group.contains(c);
    }

    public boolean canUseAnyCard() {
        for (AbstractCard c : this.group) {
            if (!c.hasEnoughEnergy()) continue;
            return true;
        }
        return false;
    }

    public void applyPowers() {
        for (AbstractCard c : this.group) {
            c.applyPowers();
        }
    }

    public void removeCard(AbstractCard c) {
        if (c instanceof Necronomicurse && this.type == CardGroupType.MASTER_DECK) {
            if (AbstractDungeon.player.hasRelic("Necronomicon")) {
                AbstractDungeon.player.getRelic("Necronomicon").flash();
            }
            AbstractDungeon.effectsQueue.add(new NecronomicurseEffect(new Necronomicurse(), (float)Settings.WIDTH / 2.0f, (float)Settings.HEIGHT / 2.0f));
        } else if (c instanceof Parasite && this.type == CardGroupType.MASTER_DECK) {
            AbstractDungeon.player.decreaseMaxHealth(3);
            CardCrawlGame.sound.play("BLOOD_SWISH");
        }
        this.group.remove(c);
        if (this.type == CardGroupType.MASTER_DECK) {
            for (AbstractRelic r : AbstractDungeon.player.relics) {
                r.onMasterDeckChange();
            }
        }
    }

    public boolean removeCard(String targetID) {
        Iterator<AbstractCard> i = this.group.iterator();
        while (i.hasNext()) {
            AbstractCard e = i.next();
            if (!e.cardID.equals(targetID)) continue;
            i.remove();
            return true;
        }
        return false;
    }

    public void addToHand(AbstractCard c) {
        this.group.add(c);
    }

    public void refreshHandLayout() {
        if (AbstractDungeon.getCurrRoom().monsters != null && AbstractDungeon.getCurrRoom().monsters.areMonstersBasicallyDead()) {
            return;
        }
        for (AbstractRelic r : AbstractDungeon.player.relics) {
            r.onRefreshHand();
        }
        float angleRange = 50.0f - (float)(10 - this.group.size()) * 5.0f;
        float incrementAngle = angleRange / (float)this.group.size();
        float sinkStart = 80.0f * Settings.scale;
        float sinkRange = 300.0f * Settings.scale;
        float incrementSink = sinkRange / (float)this.group.size() / 2.0f;
        int middle = this.group.size() / 2;
        for (int i = 0; i < this.group.size(); ++i) {
            this.group.get(i).setAngle(angleRange / 2.0f - incrementAngle * (float)i - incrementAngle / 2.0f);
            int t = i - middle;
            if (t >= 0) {
                if (this.group.size() % 2 == 0) {
                    ++t;
                    t = -t;
                } else {
                    t = -t;
                }
            }
            if (this.group.size() % 2 == 0) {
                ++t;
            }
            t = (int)((float)t * 1.7f);
            this.group.get((int)i).target_y = sinkStart + incrementSink * (float)t;
        }
        for (AbstractCard c : this.group) {
            c.targetDrawScale = 0.75f;
        }
        switch (this.group.size()) {
            case 0: {
                return;
            }
            case 1: {
                this.group.get((int)0).target_x = (float)Settings.WIDTH / 2.0f;
                break;
            }
            case 2: {
                this.group.get((int)0).target_x = (float)Settings.WIDTH / 2.0f - AbstractCard.IMG_WIDTH_S * 0.47f;
                this.group.get((int)1).target_x = (float)Settings.WIDTH / 2.0f + AbstractCard.IMG_WIDTH_S * 0.53f;
                break;
            }
            case 3: {
                this.group.get((int)0).target_x = (float)Settings.WIDTH / 2.0f - AbstractCard.IMG_WIDTH_S * 0.9f;
                this.group.get((int)1).target_x = (float)Settings.WIDTH / 2.0f;
                this.group.get((int)2).target_x = (float)Settings.WIDTH / 2.0f + AbstractCard.IMG_WIDTH_S * 0.9f;
                this.group.get((int)0).target_y += 20.0f * Settings.scale;
                this.group.get((int)2).target_y += 20.0f * Settings.scale;
                break;
            }
            case 4: {
                this.group.get((int)0).target_x = (float)Settings.WIDTH / 2.0f - AbstractCard.IMG_WIDTH_S * 1.36f;
                this.group.get((int)1).target_x = (float)Settings.WIDTH / 2.0f - AbstractCard.IMG_WIDTH_S * 0.46f;
                this.group.get((int)2).target_x = (float)Settings.WIDTH / 2.0f + AbstractCard.IMG_WIDTH_S * 0.46f;
                this.group.get((int)3).target_x = (float)Settings.WIDTH / 2.0f + AbstractCard.IMG_WIDTH_S * 1.36f;
                this.group.get((int)1).target_y -= 10.0f * Settings.scale;
                this.group.get((int)2).target_y -= 10.0f * Settings.scale;
                break;
            }
            case 5: {
                this.group.get((int)0).target_x = (float)Settings.WIDTH / 2.0f - AbstractCard.IMG_WIDTH_S * 1.7f;
                this.group.get((int)1).target_x = (float)Settings.WIDTH / 2.0f - AbstractCard.IMG_WIDTH_S * 0.9f;
                this.group.get((int)2).target_x = (float)Settings.WIDTH / 2.0f;
                this.group.get((int)3).target_x = (float)Settings.WIDTH / 2.0f + AbstractCard.IMG_WIDTH_S * 0.9f;
                this.group.get((int)4).target_x = (float)Settings.WIDTH / 2.0f + AbstractCard.IMG_WIDTH_S * 1.7f;
                this.group.get((int)0).target_y += 25.0f * Settings.scale;
                this.group.get((int)2).target_y -= 10.0f * Settings.scale;
                this.group.get((int)4).target_y += 25.0f * Settings.scale;
                break;
            }
            case 6: {
                this.group.get((int)0).target_x = (float)Settings.WIDTH / 2.0f - AbstractCard.IMG_WIDTH_S * 2.1f;
                this.group.get((int)1).target_x = (float)Settings.WIDTH / 2.0f - AbstractCard.IMG_WIDTH_S * 1.3f;
                this.group.get((int)2).target_x = (float)Settings.WIDTH / 2.0f - AbstractCard.IMG_WIDTH_S * 0.43f;
                this.group.get((int)3).target_x = (float)Settings.WIDTH / 2.0f + AbstractCard.IMG_WIDTH_S * 0.43f;
                this.group.get((int)4).target_x = (float)Settings.WIDTH / 2.0f + AbstractCard.IMG_WIDTH_S * 1.3f;
                this.group.get((int)5).target_x = (float)Settings.WIDTH / 2.0f + AbstractCard.IMG_WIDTH_S * 2.1f;
                this.group.get((int)0).target_y += 10.0f * Settings.scale;
                this.group.get((int)5).target_y += 10.0f * Settings.scale;
                break;
            }
            case 7: {
                this.group.get((int)0).target_x = (float)Settings.WIDTH / 2.0f - AbstractCard.IMG_WIDTH_S * 2.4f;
                this.group.get((int)1).target_x = (float)Settings.WIDTH / 2.0f - AbstractCard.IMG_WIDTH_S * 1.7f;
                this.group.get((int)2).target_x = (float)Settings.WIDTH / 2.0f - AbstractCard.IMG_WIDTH_S * 0.9f;
                this.group.get((int)3).target_x = (float)Settings.WIDTH / 2.0f;
                this.group.get((int)4).target_x = (float)Settings.WIDTH / 2.0f + AbstractCard.IMG_WIDTH_S * 0.9f;
                this.group.get((int)5).target_x = (float)Settings.WIDTH / 2.0f + AbstractCard.IMG_WIDTH_S * 1.7f;
                this.group.get((int)6).target_x = (float)Settings.WIDTH / 2.0f + AbstractCard.IMG_WIDTH_S * 2.4f;
                this.group.get((int)0).target_y += 25.0f * Settings.scale;
                this.group.get((int)1).target_y += 18.0f * Settings.scale;
                this.group.get((int)3).target_y -= 6.0f * Settings.scale;
                this.group.get((int)5).target_y += 18.0f * Settings.scale;
                this.group.get((int)6).target_y += 25.0f * Settings.scale;
                break;
            }
            case 8: {
                this.group.get((int)0).target_x = (float)Settings.WIDTH / 2.0f - AbstractCard.IMG_WIDTH_S * 2.5f;
                this.group.get((int)1).target_x = (float)Settings.WIDTH / 2.0f - AbstractCard.IMG_WIDTH_S * 1.82f;
                this.group.get((int)2).target_x = (float)Settings.WIDTH / 2.0f - AbstractCard.IMG_WIDTH_S * 1.1f;
                this.group.get((int)3).target_x = (float)Settings.WIDTH / 2.0f - AbstractCard.IMG_WIDTH_S * 0.38f;
                this.group.get((int)4).target_x = (float)Settings.WIDTH / 2.0f + AbstractCard.IMG_WIDTH_S * 0.38f;
                this.group.get((int)5).target_x = (float)Settings.WIDTH / 2.0f + AbstractCard.IMG_WIDTH_S * 1.1f;
                this.group.get((int)6).target_x = (float)Settings.WIDTH / 2.0f + AbstractCard.IMG_WIDTH_S * 1.77f;
                this.group.get((int)7).target_x = (float)Settings.WIDTH / 2.0f + AbstractCard.IMG_WIDTH_S * 2.5f;
                this.group.get((int)1).target_y += 10.0f * Settings.scale;
                this.group.get((int)6).target_y += 10.0f * Settings.scale;
                for (AbstractCard c : this.group) {
                    c.targetDrawScale = 0.7125f;
                }
                break;
            }
            case 9: {
                this.group.get((int)0).target_x = (float)Settings.WIDTH / 2.0f - AbstractCard.IMG_WIDTH_S * 2.8f;
                this.group.get((int)1).target_x = (float)Settings.WIDTH / 2.0f - AbstractCard.IMG_WIDTH_S * 2.2f;
                this.group.get((int)2).target_x = (float)Settings.WIDTH / 2.0f - AbstractCard.IMG_WIDTH_S * 1.53f;
                this.group.get((int)3).target_x = (float)Settings.WIDTH / 2.0f - AbstractCard.IMG_WIDTH_S * 0.8f;
                this.group.get((int)4).target_x = (float)Settings.WIDTH / 2.0f + AbstractCard.IMG_WIDTH_S * 0.0f;
                this.group.get((int)5).target_x = (float)Settings.WIDTH / 2.0f + AbstractCard.IMG_WIDTH_S * 0.8f;
                this.group.get((int)6).target_x = (float)Settings.WIDTH / 2.0f + AbstractCard.IMG_WIDTH_S * 1.53f;
                this.group.get((int)7).target_x = (float)Settings.WIDTH / 2.0f + AbstractCard.IMG_WIDTH_S * 2.2f;
                this.group.get((int)8).target_x = (float)Settings.WIDTH / 2.0f + AbstractCard.IMG_WIDTH_S * 2.8f;
                this.group.get((int)1).target_y += 22.0f * Settings.scale;
                this.group.get((int)2).target_y += 18.0f * Settings.scale;
                this.group.get((int)3).target_y += 12.0f * Settings.scale;
                this.group.get((int)5).target_y += 12.0f * Settings.scale;
                this.group.get((int)6).target_y += 18.0f * Settings.scale;
                this.group.get((int)7).target_y += 22.0f * Settings.scale;
                for (AbstractCard c : this.group) {
                    c.targetDrawScale = 0.67499995f;
                }
                break;
            }
            case 10: {
                this.group.get((int)0).target_x = (float)Settings.WIDTH / 2.0f - AbstractCard.IMG_WIDTH_S * 2.9f;
                this.group.get((int)1).target_x = (float)Settings.WIDTH / 2.0f - AbstractCard.IMG_WIDTH_S * 2.4f;
                this.group.get((int)2).target_x = (float)Settings.WIDTH / 2.0f - AbstractCard.IMG_WIDTH_S * 1.8f;
                this.group.get((int)3).target_x = (float)Settings.WIDTH / 2.0f - AbstractCard.IMG_WIDTH_S * 1.1f;
                this.group.get((int)4).target_x = (float)Settings.WIDTH / 2.0f - AbstractCard.IMG_WIDTH_S * 0.4f;
                this.group.get((int)5).target_x = (float)Settings.WIDTH / 2.0f + AbstractCard.IMG_WIDTH_S * 0.4f;
                this.group.get((int)6).target_x = (float)Settings.WIDTH / 2.0f + AbstractCard.IMG_WIDTH_S * 1.1f;
                this.group.get((int)7).target_x = (float)Settings.WIDTH / 2.0f + AbstractCard.IMG_WIDTH_S * 1.8f;
                this.group.get((int)8).target_x = (float)Settings.WIDTH / 2.0f + AbstractCard.IMG_WIDTH_S * 2.4f;
                this.group.get((int)9).target_x = (float)Settings.WIDTH / 2.0f + AbstractCard.IMG_WIDTH_S * 2.9f;
                this.group.get((int)1).target_y += 20.0f * Settings.scale;
                this.group.get((int)2).target_y += 17.0f * Settings.scale;
                this.group.get((int)3).target_y += 12.0f * Settings.scale;
                this.group.get((int)4).target_y += 5.0f * Settings.scale;
                this.group.get((int)5).target_y += 5.0f * Settings.scale;
                this.group.get((int)6).target_y += 12.0f * Settings.scale;
                this.group.get((int)7).target_y += 17.0f * Settings.scale;
                this.group.get((int)8).target_y += 20.0f * Settings.scale;
                for (AbstractCard c : this.group) {
                    c.targetDrawScale = 0.63750005f;
                }
                break;
            }
            default: {
                logger.info("WTF MATE, why so many cards");
            }
        }
        AbstractCard card = AbstractDungeon.player.hoveredCard;
        if (card != null) {
            card.setAngle(0.0f);
            card.target_x = (card.current_x + card.target_x) / 2.0f;
            card.target_y = card.current_y;
        }
        for (CardQueueItem q : AbstractDungeon.actionManager.cardQueue) {
            q.card.setAngle(0.0f);
            q.card.target_x = q.card.current_x;
            q.card.target_y = q.card.current_y;
        }
    }

    public void glowCheck() {
        for (AbstractCard c : this.group) {
            if (c.canUse(AbstractDungeon.player, null) && AbstractDungeon.screen != AbstractDungeon.CurrentScreen.HAND_SELECT) {
                c.beginGlowing();
                continue;
            }
            c.stopGlowing();
        }
    }

    public void stopGlowing() {
        for (AbstractCard c : this.group) {
            c.stopGlowing();
        }
    }

    public void hoverCardPush(AbstractCard c) {
        if (this.group.size() > 1) {
            int currentSlot;
            int cardNum = -1;
            for (int i = 0; i < this.group.size(); ++i) {
                if (!c.equals(this.group.get(i))) continue;
                cardNum = i;
                break;
            }
            float pushAmt = 0.4f;
            if (this.group.size() == 2) {
                pushAmt = 0.2f;
            } else if (this.group.size() == 3 || this.group.size() == 4) {
                pushAmt = 0.27f;
            }
            for (currentSlot = cardNum + 1; currentSlot < this.group.size(); ++currentSlot) {
                this.group.get((int)currentSlot).target_x += AbstractCard.IMG_WIDTH_S * pushAmt;
                pushAmt *= 0.25f;
            }
            pushAmt = 0.4f;
            if (this.group.size() == 2) {
                pushAmt = 0.2f;
            } else if (this.group.size() == 3 || this.group.size() == 4) {
                pushAmt = 0.27f;
            }
            for (currentSlot = cardNum - 1; currentSlot > -1 && currentSlot < this.group.size(); --currentSlot) {
                this.group.get((int)currentSlot).target_x -= AbstractCard.IMG_WIDTH_S * pushAmt;
                pushAmt *= 0.25f;
            }
        }
    }

    public void addToTop(AbstractCard c) {
        this.group.add(c);
    }

    public void addToBottom(AbstractCard c) {
        this.group.add(0, c);
    }

    public void addToRandomSpot(AbstractCard c) {
        if (this.group.size() == 0) {
            this.group.add(c);
        } else {
            this.group.add(MathUtils.random.nextInt(this.group.size()), c);
        }
    }

    public AbstractCard getTopCard() {
        return this.group.get(this.group.size() - 1);
    }

    public AbstractCard getNCardFromTop(int num) {
        return this.group.get(this.group.size() - 1 - num);
    }

    public AbstractCard getBottomCard() {
        return this.group.get(0);
    }

    public AbstractCard getHoveredCard() {
        for (AbstractCard c : this.group) {
            if (!c.isHoveredInHand(0.7f)) continue;
            boolean success = true;
            for (CardQueueItem q : AbstractDungeon.actionManager.cardQueue) {
                if (q.card != c) continue;
                success = false;
                break;
            }
            if (!success) continue;
            return c;
        }
        return null;
    }

    public AbstractCard getRandomCard(boolean useRng) {
        if (useRng) {
            return this.group.get(AbstractDungeon.cardRng.random(this.group.size() - 1));
        }
        return this.group.get(MathUtils.random(this.group.size() - 1));
    }

    public AbstractCard getRandomCard(boolean useRng, AbstractCard.CardRarity rarity) {
        ArrayList<AbstractCard> tmp = new ArrayList<AbstractCard>();
        for (AbstractCard c : this.group) {
            if (c.rarity != rarity) continue;
            tmp.add(c);
        }
        if (tmp.isEmpty()) {
            logger.info("ERROR: No cards left for type: " + this.type.name());
            return null;
        }
        Collections.sort(tmp);
        if (useRng) {
            return (AbstractCard)tmp.get(AbstractDungeon.cardRng.random(tmp.size() - 1));
        }
        return (AbstractCard)tmp.get(MathUtils.random(tmp.size() - 1));
    }

    public AbstractCard getRandomCard(AbstractCard.CardType type, boolean useRng) {
        ArrayList<AbstractCard> tmp = new ArrayList<AbstractCard>();
        for (AbstractCard c : this.group) {
            if (c.type != type) continue;
            tmp.add(c);
        }
        if (tmp.isEmpty()) {
            logger.info("ERROR: No cards left for type: " + type.name());
            return null;
        }
        Collections.sort(tmp);
        if (useRng) {
            return (AbstractCard)tmp.get(AbstractDungeon.cardRng.random(tmp.size() - 1));
        }
        return (AbstractCard)tmp.get(MathUtils.random(tmp.size() - 1));
    }

    public void removeTopCard() {
        this.group.remove(this.group.size() - 1);
    }

    public void shuffle() {
        Collections.shuffle(this.group);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("");
        for (AbstractCard c : this.group) {
            sb.append(c.cardID);
            sb.append("\n");
        }
        return sb.toString();
    }

    public void update() {
        for (AbstractCard c : this.group) {
            c.update();
        }
    }

    public void updateHoverLogic() {
        for (AbstractCard c : this.group) {
            c.updateHoverLogic();
        }
    }

    public void render(SpriteBatch sb) {
        for (AbstractCard c : this.group) {
            AbstractRelic r;
            c.render(sb);
            if (c.inBottleFlame) {
                r = new BottledFlame();
                r.currentX = c.current_x + 390.0f * c.drawScale / 3.0f * Settings.scale;
                r.currentY = c.current_y + 546.0f * c.drawScale / 3.0f * Settings.scale;
                r.renderOutline(sb);
                r.render(sb);
                continue;
            }
            if (!c.inBottleLightning) continue;
            r = new BottledLightning();
            r.currentX = c.current_x + 390.0f * c.drawScale / 3.0f * Settings.scale;
            r.currentY = c.current_y + 546.0f * c.drawScale / 3.0f * Settings.scale;
            r.renderOutline(sb);
            r.render(sb);
        }
    }

    public void renderExceptOneCard(SpriteBatch sb, AbstractCard card) {
        for (AbstractCard c : this.group) {
            AbstractRelic r;
            if (c.equals(card)) continue;
            c.render(sb);
            if (c.inBottleFlame) {
                r = new BottledFlame();
                r.currentX = c.current_x + 390.0f * c.drawScale / 3.0f * Settings.scale;
                r.currentY = c.current_y + 546.0f * c.drawScale / 3.0f * Settings.scale;
                r.renderOutline(sb);
                r.render(sb);
                continue;
            }
            if (!c.inBottleLightning) continue;
            r = new BottledLightning();
            r.currentX = c.current_x + 390.0f * c.drawScale / 3.0f * Settings.scale;
            r.currentY = c.current_y + 546.0f * c.drawScale / 3.0f * Settings.scale;
            r.renderOutline(sb);
            r.render(sb);
        }
    }

    public void renderHand(SpriteBatch sb, AbstractCard exceptThis) {
        ArrayList<AbstractCard> queued = new ArrayList<AbstractCard>();
        ArrayList<AbstractCard> inHand = new ArrayList<AbstractCard>();
        for (AbstractCard c : this.group) {
            if (c == exceptThis) continue;
            boolean inQueue = false;
            for (CardQueueItem i : AbstractDungeon.actionManager.cardQueue) {
                if (!i.card.equals(c)) continue;
                queued.add(c);
                inQueue = true;
                break;
            }
            if (inQueue) continue;
            inHand.add(c);
        }
        for (AbstractCard c : inHand) {
            c.render(sb);
        }
        for (AbstractCard c : queued) {
            c.render(sb);
        }
    }

    public void renderInLibrary(SpriteBatch sb) {
        for (AbstractCard c : this.group) {
            c.renderInLibrary(sb);
        }
    }

    public void renderTip(SpriteBatch sb) {
        for (AbstractCard c : this.group) {
            c.renderCardTip(sb);
        }
    }

    public void renderWithSelections(SpriteBatch sb) {
        for (AbstractCard c : this.group) {
            c.renderWithSelections(sb);
        }
    }

    public void renderDiscardPile(SpriteBatch sb) {
        for (AbstractCard c : this.group) {
            c.render(sb);
        }
    }

    public void moveToDiscardPile(AbstractCard c) {
        this.resetCardBeforeMoving(c);
        c.shrink();
        c.darken(false);
        AbstractDungeon.getCurrRoom().souls.discard(c);
        AbstractDungeon.player.onCardDrawOrDiscard();
    }

    public void empower(AbstractCard c) {
        this.resetCardBeforeMoving(c);
        c.shrink();
        AbstractDungeon.getCurrRoom().souls.empower(c);
    }

    public void moveToExhaustPile(AbstractCard c) {
        for (AbstractRelic r : AbstractDungeon.player.relics) {
            r.onExhaust(c);
        }
        for (AbstractPower p : AbstractDungeon.player.powers) {
            p.onExhaust(c);
        }
        c.triggerOnExhaust();
        this.resetCardBeforeMoving(c);
        AbstractDungeon.effectList.add(new ExhaustCardEffect(c));
        AbstractDungeon.player.exhaustPile.addToTop(c);
        AbstractDungeon.player.onCardDrawOrDiscard();
    }

    public void moveToDeck(AbstractCard c, boolean randomSpot) {
        this.resetCardBeforeMoving(c);
        c.shrink();
        AbstractDungeon.getCurrRoom().souls.onToDeck(c, randomSpot);
    }

    public void moveToBottomOfDeck(AbstractCard c) {
        this.resetCardBeforeMoving(c);
        c.shrink();
        AbstractDungeon.getCurrRoom().souls.onToBottomOfDeck(c);
    }

    private void resetCardBeforeMoving(AbstractCard c) {
        if (AbstractDungeon.player.hoveredCard == c) {
            AbstractDungeon.player.releaseCard();
        }
        AbstractDungeon.actionManager.removeFromQueue(c);
        c.unhover();
        c.untip();
        c.stopGlowing();
        this.group.remove(c);
    }

    public boolean isEmpty() {
        return this.group.isEmpty();
    }

    private void discardAll(CardGroup discardPile) {
        for (AbstractCard c : this.group) {
            c.target_x = DISCARD_PILE_X;
            c.target_y = 0.0f;
            discardPile.addToTop(c);
        }
        this.group.clear();
    }

    public void initializeDeck(CardGroup masterDeck) {
        this.clear();
        CardGroup copy = new CardGroup(masterDeck, CardGroupType.DRAW_PILE);
        copy.shuffle();
        ArrayList<AbstractCard> placeOnTop = new ArrayList<AbstractCard>();
        for (AbstractCard c : copy.group) {
            if (c.isInnate) {
                placeOnTop.add(c);
                continue;
            }
            if (c.inBottleFlame || c.inBottleLightning) {
                placeOnTop.add(c);
                continue;
            }
            c.target_x = DRAW_PILE_X;
            c.target_y = DRAW_PILE_Y;
            c.current_x = DRAW_PILE_X;
            c.current_y = DRAW_PILE_Y;
            this.addToTop(c);
        }
        if (AbstractDungeon.player.hasRelic("Enchiridion")) {
            AbstractCard c3 = AbstractDungeon.getCardFromPool(AbstractDungeon.rollRareOrUncommon(0.5f), AbstractCard.CardType.POWER, false).makeCopy();
            if (c3.cost != -1) {
                c3.updateCost(-99);
            }
            UnlockTracker.markCardAsSeen(c3.cardID);
            placeOnTop.add(c3);
        }
        for (AbstractCard c : placeOnTop) {
            this.addToTop(c);
        }
        if (placeOnTop.size() > AbstractDungeon.player.masterHandSize) {
            AbstractDungeon.actionManager.addToTurnStart(new DrawCardAction(AbstractDungeon.player, placeOnTop.size() - AbstractDungeon.player.masterHandSize));
        }
        placeOnTop.clear();
    }

    public int size() {
        return this.group.size();
    }

    public CardGroup getUpgradableCards() {
        CardGroup retVal = new CardGroup(CardGroupType.UNSPECIFIED);
        for (AbstractCard c : this.group) {
            if (!c.canUpgrade()) continue;
            retVal.group.add(c);
        }
        return retVal;
    }

    public CardGroup getPurgeableCards() {
        CardGroup retVal = new CardGroup(CardGroupType.UNSPECIFIED);
        for (AbstractCard c : this.group) {
            if (c.cardID.equals("Necronomicurse")) continue;
            retVal.group.add(c);
        }
        return retVal;
    }

    public AbstractCard getSpecificCard(AbstractCard targetCard) {
        if (this.group.contains(targetCard)) {
            return targetCard;
        }
        return null;
    }

    public void triggerOnOtherCardPlayed(AbstractCard usedCard) {
        for (AbstractCard c : this.group) {
            if (c == usedCard) continue;
            c.triggerOnOtherCardPlayed(usedCard);
        }
        for (AbstractPower p : AbstractDungeon.player.powers) {
            p.onAfterCardPlayed(usedCard);
        }
    }

    public void sortByRarity(boolean ascending) {
        ArrayList<AbstractCard> tmp = new ArrayList<AbstractCard>();
        for (AbstractCard c : this.group) {
            int addIndex = 0;
            for (AbstractCard c2 : tmp) {
                if (!ascending ? c.rarity.compareTo(c2.rarity) < 0 : c.rarity.compareTo(c2.rarity) > 0) break;
                ++addIndex;
            }
            tmp.add(addIndex, c);
        }
        this.group = tmp;
    }

    public void sortByType(boolean ascending) {
        ArrayList<AbstractCard> tmp = new ArrayList<AbstractCard>();
        for (AbstractCard c : this.group) {
            int addIndex = 0;
            for (AbstractCard c2 : tmp) {
                if (!ascending ? c.type.compareTo(c2.type) < 0 : c.type.compareTo(c2.type) > 0) break;
                ++addIndex;
            }
            tmp.add(addIndex, c);
        }
        this.group = tmp;
    }

    public void sortByAcquisition() {
    }

    public void sortByStatus(boolean ascending) {
        ArrayList<AbstractCard> tmp = new ArrayList<AbstractCard>();
        for (AbstractCard c : this.group) {
            int addIndex = 0;
            for (AbstractCard c2 : tmp) {
                if (!ascending ? UnlockTracker.isCardSeen(c.cardID) && !UnlockTracker.isCardSeen(c2.cardID) || !UnlockTracker.isCardSeen(c2.cardID) && !UnlockTracker.isCardLocked(c.cardID) : !UnlockTracker.isCardSeen(c.cardID) && UnlockTracker.isCardSeen(c2.cardID) || UnlockTracker.isCardSeen(c2.cardID) || UnlockTracker.isCardLocked(c.cardID)) break;
                ++addIndex;
            }
            tmp.add(addIndex, c);
        }
        this.group = tmp;
    }

    public void sortAlphabetically(boolean ascending) {
        ArrayList<AbstractCard> tmp = new ArrayList<AbstractCard>();
        for (AbstractCard c : this.group) {
            int addIndex = 0;
            for (AbstractCard c2 : tmp) {
                if (!ascending ? c.originalName.compareTo(c2.originalName) < 0 : c.originalName.compareTo(c2.originalName) > 0) break;
                ++addIndex;
            }
            tmp.add(addIndex, c);
        }
        this.group = tmp;
    }

    public CardGroup getSkills() {
        CardGroup retVal = new CardGroup(CardGroupType.UNSPECIFIED);
        for (AbstractCard card : this.group) {
            if (card.type != AbstractCard.CardType.SKILL) continue;
            retVal.addToBottom(card);
        }
        return retVal;
    }

    public CardGroup getAttacks() {
        CardGroup retVal = new CardGroup(CardGroupType.UNSPECIFIED);
        for (AbstractCard card : this.group) {
            if (card.type != AbstractCard.CardType.ATTACK) continue;
            retVal.addToBottom(card);
        }
        return retVal;
    }

    public AbstractCard findCardByName(String id) {
        for (AbstractCard c : this.group) {
            if (!c.cardID.equals(id)) continue;
            return c;
        }
        return null;
    }

    public static CardGroup getGroupWithoutBottledCards(CardGroup group) {
        CardGroup retVal = new CardGroup(CardGroupType.UNSPECIFIED);
        for (AbstractCard c : group.group) {
            if (c.inBottleFlame || c.inBottleLightning) continue;
            retVal.addToTop(c);
        }
        return retVal;
    }

    public static enum CardGroupType {
        DRAW_PILE,
        MASTER_DECK,
        HAND,
        DISCARD_PILE,
        EXHAUST_PILE,
        CARD_POOL,
        UNSPECIFIED;

    }
}

