/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.actions.unique;

import com.badlogic.gdx.math.MathUtils;
import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.actions.common.ExhaustSpecificCardAction;
import com.megacrit.cardcrawl.actions.utility.WaitAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.cards.CardGroup;
import com.megacrit.cardcrawl.cards.green.Defend_Green;
import com.megacrit.cardcrawl.cards.green.Strike_Green;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import java.util.Iterator;

public class WraithFormAction
extends AbstractGameAction {
    public WraithFormAction() {
        this.duration = Settings.ACTION_DUR_MED;
        this.actionType = AbstractGameAction.ActionType.WAIT;
    }

    @Override
    public void update() {
        if (this.duration == Settings.ACTION_DUR_MED) {
            AbstractPlayer p = AbstractDungeon.player;
            this.moveStrikeAndDefendToLimbo(p.hand);
            this.moveStrikeAndDefendToLimbo(p.drawPile);
            this.moveStrikeAndDefendToLimbo(p.discardPile);
            AbstractDungeon.actionManager.addToTop(new WaitAction(1.5f));
            for (AbstractCard c : p.limbo.group) {
                c.target_x = MathUtils.random(0.4f * (float)Settings.WIDTH, 0.6f * (float)Settings.WIDTH);
                c.target_y = MathUtils.random(0.3f * (float)Settings.HEIGHT, 0.7f * (float)Settings.HEIGHT);
                AbstractDungeon.actionManager.addToTop(new ExhaustSpecificCardAction(c, p.limbo, true));
            }
            this.isDone = true;
        }
    }

    private void moveStrikeAndDefendToLimbo(CardGroup cardGroup) {
        AbstractPlayer p = AbstractDungeon.player;
        Iterator<AbstractCard> i = cardGroup.group.iterator();
        while (i.hasNext()) {
            AbstractCard e = i.next();
            if (!(e instanceof Strike_Green) && !(e instanceof Defend_Green)) continue;
            i.remove();
            p.limbo.group.add(e);
        }
    }
}

