/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.actions.unique;

import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LoseEnergyAction
extends AbstractGameAction {
    private static final Logger logger = LogManager.getLogger(LoseEnergyAction.class.getName());
    private int redLoss = 0;
    private int greenLoss = 0;
    private int blueLoss = 0;

    public LoseEnergyAction(int newRed, int newGreen, int newBlue) {
        this.setValues(AbstractDungeon.player, AbstractDungeon.player, 0);
        this.actionType = AbstractGameAction.ActionType.ENERGY;
        this.redLoss = newRed;
        this.greenLoss = newGreen;
        this.blueLoss = newBlue;
    }

    public LoseEnergyAction(int amount) {
        this.setValues(AbstractDungeon.player, AbstractDungeon.player, 0);
        switch (AbstractDungeon.player.chosenClass) {
            case IRONCLAD: {
                this.redLoss = amount;
                break;
            }
            case THE_SILENT: {
                this.greenLoss = amount;
                break;
            }
            case CROWBOT: {
                this.blueLoss = amount;
                break;
            }
            default: {
                logger.info("MISSING CLASS: " + (Object)((Object)AbstractDungeon.player.chosenClass));
            }
        }
    }

    @Override
    public void update() {
        if (this.duration == this.DEFAULT_DURATION) {
            AbstractDungeon.player.loseEnergy(this.redLoss, this.greenLoss, this.blueLoss);
        }
        this.tickDuration();
    }
}

