/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.actions.common;

import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.vfx.combat.PowerExpireTextEffect;

public class RemoveSpecificPowerAction
extends AbstractGameAction {
    private String powerToRemove;
    private boolean powerExists = false;
    private int powerLocation;
    private static final float DURATION = 1.0f;

    public RemoveSpecificPowerAction(AbstractCreature target, AbstractCreature source, String powerToRemove) {
        this.setValues(target, source, this.amount);
        this.actionType = AbstractGameAction.ActionType.DEBUFF;
        this.duration = 1.0f;
        this.powerToRemove = powerToRemove;
    }

    @Override
    public void update() {
        if (this.duration == 1.0f) {
            if (this.target.isDeadOrEscaped()) {
                this.isDone = true;
                return;
            }
            for (int i = 0; i < this.target.powers.size(); ++i) {
                if (!this.target.powers.get((int)i).ID.equals(this.powerToRemove)) continue;
                this.powerExists = true;
                this.powerLocation = i;
            }
            if (this.powerExists) {
                AbstractDungeon.effectList.add(new PowerExpireTextEffect(this.target.hb.cX - this.target.animX, this.target.hb.cY + this.target.hb.height / 2.0f, this.powerToRemove, this.target.getPower((String)this.powerToRemove).region128));
                this.target.powers.get(this.powerLocation).onRemove();
                this.target.powers.remove(this.powerLocation);
                AbstractDungeon.onModifyPower();
            } else {
                this.duration = 0.0f;
            }
        }
        this.tickDuration();
    }
}

