/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.actions.common;

import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.powers.AbstractPower;
import com.megacrit.cardcrawl.relics.AbstractRelic;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GainEnergyAndEnableControlsAction
extends AbstractGameAction {
    private static final Logger logger = LogManager.getLogger(GainEnergyAndEnableControlsAction.class.getName());
    private int redGain = 0;
    private int greenGain = 0;
    private int blueGain = 0;

    public GainEnergyAndEnableControlsAction(int amount) {
        this.setValues(AbstractDungeon.player, AbstractDungeon.player, 0);
        switch (AbstractDungeon.player.chosenClass) {
            case IRONCLAD: {
                this.redGain = amount;
                break;
            }
            case THE_SILENT: {
                this.greenGain = amount;
                break;
            }
            case CROWBOT: {
                this.blueGain = amount;
                break;
            }
            default: {
                logger.info("UNSPECIFIED CLASS: " + AbstractDungeon.player.chosenClass.name());
            }
        }
    }

    public GainEnergyAndEnableControlsAction(int newRed, int newGreen, int newBlue) {
        this.setValues(AbstractDungeon.player, AbstractDungeon.player, 0);
        this.actionType = AbstractGameAction.ActionType.ENERGY;
        this.redGain = newRed;
        this.greenGain = newGreen;
        this.blueGain = newBlue;
    }

    @Override
    public void update() {
        if (this.duration == this.DEFAULT_DURATION) {
            AbstractDungeon.player.gainEnergy(this.redGain, this.greenGain, this.blueGain);
            AbstractDungeon.actionManager.updateEnergyGain(this.redGain, this.greenGain, this.blueGain);
            for (AbstractCard c : AbstractDungeon.player.hand.group) {
                c.triggerOnGainEnergy(this.redGain, this.greenGain, this.blueGain, false);
            }
            for (AbstractRelic r : AbstractDungeon.player.relics) {
                r.onEnergyRecharge();
            }
            for (AbstractPower p : AbstractDungeon.player.powers) {
                p.onEnergyRecharge();
            }
            AbstractDungeon.actionManager.turnHasEnded = false;
        }
        this.tickDuration();
    }
}

