/*
 * Decompiled with CFR 0.152.
 */
package com.crack.me.active.ui.core;

import com.crack.me.active.ui.Loggable;
import com.crack.me.active.ui.core.JarReplacer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class SignatureVerifierReplacer
extends JarReplacer {
    private Loggable log = null;
    private List<String> legalFileList = null;
    private String defaultClassName = "SignatureVerifier.class";

    public SignatureVerifierReplacer(Loggable log) {
        this.log = log;
        this.legalFileList = new ArrayList<String>();
        this.legalFileList.add("/SignatureVerifier.class");
        this.legalFileList.add("/SignatureVerifier$1.class");
        this.legalFileList.add("/SignatureVerifier$1$1.class");
    }

    public boolean isInLegalFile(String fileName) {
        for (String cn : this.legalFileList) {
            if (!fileName.endsWith(cn)) continue;
            return true;
        }
        return false;
    }

    public boolean replace(File f2) {
        if (f2 == null) {
            return false;
        }
        this.log.log("\treplacing file [" + f2.getAbsolutePath() + "]");
        File bakFile = this.createBakFile(f2);
        ZipOutputStream out = null;
        try {
            try {
                if (bakFile != null) {
                    String defaultPackage = "";
                    JarFile bakJar = new JarFile(bakFile);
                    out = new JarOutputStream(new FileOutputStream(f2));
                    Enumeration<JarEntry> jes = bakJar.entries();
                    while (jes.hasMoreElements()) {
                        JarEntry j2 = jes.nextElement();
                        String name = j2.getName();
                        if (this.isInLegalFile(name)) {
                            defaultPackage = name.substring(0, name.lastIndexOf(47));
                            continue;
                        }
                        ((JarOutputStream)out).putNextEntry(j2);
                        InputStream in = bakJar.getInputStream(j2);
                        this.writeJarEntry(in, (JarOutputStream)out);
                    }
                    this.addJarFile(String.valueOf(defaultPackage) + "/" + this.defaultClassName, (JarOutputStream)out);
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
                return false;
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e4) {
                    e4.printStackTrace();
                }
            }
        }
        return true;
    }

    public boolean isFileLegal(File f2) {
        boolean isFoundSV = false;
        boolean isFoundSV$1 = false;
        boolean isFoundSV$1$1 = false;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(f2);
            Enumeration<? extends ZipEntry> zes = zipFile.entries();
            while (zes.hasMoreElements()) {
                ZipEntry ze = zes.nextElement();
                String name = ze.getName();
                if (name.endsWith("/SignatureVerifier.class")) {
                    isFoundSV = true;
                }
                if (name.endsWith("/SignatureVerifier$1.class")) {
                    isFoundSV$1 = true;
                }
                if (!name.endsWith("/SignatureVerifier$1$1.class")) continue;
                isFoundSV$1$1 = true;
            }
            if (isFoundSV && isFoundSV$1 && isFoundSV$1$1) {
                return true;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (IOException e3) {
                e3.printStackTrace();
            }
        }
        return false;
    }

    public String getProcessInfo() {
        return "Replacing [SignatureVerifier].";
    }
}

